/*
 * Decompiled with CFR 0.152.
 */
package dev.kikugie.commandconfig.impl.builders;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import dev.kikugie.commandconfig.Reference;
import dev.kikugie.commandconfig.api.CommandNode;
import java.util.Collection;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import net.minecraft.class_2172;
import net.minecraft.class_2561;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public abstract class CommandNodeImpl<S extends class_2172>
implements CommandNode<S> {
    protected final String name;
    protected final Class<S> type;
    protected BiFunction<CommandContext<S>, class_2561, Integer> printFunc;
    @Nullable
    protected Runnable saveFunc;
    @Nullable
    protected Supplier<class_2561> helpFunc;

    protected CommandNodeImpl(String name, Class<S> type) {
        this.name = name;
        this.type = type;
    }

    @Override
    public int print(CommandContext<S> context, class_2561 text) {
        Validate.notNull(this.printFunc, (String)Reference.nodeError(this.name, "No print function for %s \"%s\".\nAdd it using `printFunc` on current or any higher node."), (Object[])new Object[0]);
        return this.printFunc.apply(context, text);
    }

    @Override
    public int help(CommandContext<S> context) {
        Validate.notNull(this.printFunc, (String)Reference.nodeError(this.name, "No print function for %s \"%s\".\nAdd it using `printFunc` on current or any higher node."), (Object[])new Object[0]);
        return this.helpFunc != null ? this.printFunc.apply(context, this.helpFunc.get()) : -1;
    }

    @Override
    public void save() {
        if (this.saveFunc != null) {
            this.saveFunc.run();
        }
    }

    CommandNode<S> printFunc(@NotNull BiFunction<CommandContext<S>, class_2561, Integer> printFunc) {
        this.printFunc = printFunc;
        return this;
    }

    CommandNode<S> saveFunc(@NotNull Runnable saveFunc) {
        this.saveFunc = saveFunc;
        return this;
    }

    CommandNode<S> helpFunc(@NotNull Supplier<class_2561> helpFunc) {
        this.helpFunc = helpFunc;
        return this;
    }

    public abstract LiteralArgumentBuilder<S> build();

    @Nullable
    public LiteralArgumentBuilder<S> buildHelpFunc() {
        return null;
    }

    public void buildNodes(LiteralArgumentBuilder<S> root, Collection<? extends CommandNodeImpl<S>> nodes) {
        nodes.forEach(builder -> {
            BiFunction<CommandContext<S>, class_2561, Integer> printFunc = builder.printFunc;
            Runnable saveFunc = builder.saveFunc;
            if (printFunc == null && this.printFunc != null) {
                builder.printFunc(this.printFunc);
            }
            if (saveFunc == null && this.saveFunc != null) {
                builder.saveFunc(this.saveFunc);
            }
            root.then(builder.build());
        });
    }

    public void buildHelpers(LiteralArgumentBuilder<S> root, Collection<? extends CommandNodeImpl<S>> nodes) {
        nodes.forEach(builder -> {
            LiteralArgumentBuilder node = builder.buildHelpFunc();
            if (node != null) {
                root.then(node);
            }
        });
    }
}

