/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft.entity;

import immersive_aircraft.config.Config;
import immersive_aircraft.data.AircraftDataLoader;
import immersive_aircraft.entity.InventoryVehicleEntity;
import immersive_aircraft.entity.misc.AircraftProperties;
import immersive_aircraft.entity.misc.PositionDescriptor;
import immersive_aircraft.entity.misc.Trail;
import immersive_aircraft.entity.weapons.Telescope;
import immersive_aircraft.entity.weapons.Weapon;
import immersive_aircraft.item.upgrade.AircraftStat;
import immersive_aircraft.resources.bbmodel.BBAnimationVariables;
import immersive_aircraft.util.Utils;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_1299;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import org.joml.Vector3f;

public abstract class AircraftEntity
extends InventoryVehicleEntity {
    private final AircraftProperties properties;
    protected double lastY;
    private static final List<Trail> TRAILS = Collections.emptyList();

    public AircraftEntity(class_1299<? extends AircraftEntity> entityType, class_1937 world, boolean canExplodeOnCrash) {
        super(entityType, world, canExplodeOnCrash);
        this.properties = new AircraftProperties(AircraftDataLoader.get(this.identifier).getProperties(), this);
    }

    public List<Trail> getTrails() {
        return TRAILS;
    }

    public AircraftProperties getProperties() {
        return this.properties;
    }

    @Override
    protected List<List<PositionDescriptor>> getPassengerPositions() {
        return AircraftDataLoader.get(this.identifier).getPassengerPositions();
    }

    @Override
    public void method_5773() {
        this.prevRoll = this.roll;
        if (this.method_24828()) {
            this.setZRot(this.roll * 0.9f);
        } else {
            this.setZRot(-this.pressingInterpolatedX.getSmooth() * this.getProperties().get(AircraftStat.ROLL_FACTOR));
        }
        if (Double.isNaN(this.method_18798().field_1352) || Double.isNaN(this.method_18798().field_1351) || Double.isNaN(this.method_18798().field_1350)) {
            this.method_18800(0.0, 0.0, 0.0);
        }
        super.method_5773();
    }

    protected void convertPower(class_243 direction) {
        class_243 velocity = this.method_18798();
        double drag = Math.abs(direction.method_1026(velocity.method_1029()));
        this.method_18799(velocity.method_1029().method_35590(direction, (double)this.getProperties().get(AircraftStat.LIFT)).method_1021(velocity.method_1033() * (drag * (double)this.getProperties().get(AircraftStat.FRICTION) + (1.0 - (double)this.getProperties().get(AircraftStat.FRICTION)))));
    }

    protected float falloffGroundVelocityDecay(float original) {
        float gravity = Math.min(1.0f, Math.max(0.0f, this.getGravity() / -0.04f));
        float upgrade = Math.min(1.0f, this.getProperties().get(AircraftStat.ACCELERATION) * 0.5f);
        return (original * gravity + (1.0f - gravity)) * (1.0f - upgrade) + upgrade;
    }

    @Override
    protected void updateVelocity() {
        float decay = 1.0f - this.getProperties().get(AircraftStat.FRICTION);
        float gravity = this.getGravity();
        if (this.field_5957) {
            gravity *= 0.25f;
            decay = 0.9f;
        } else if (this.method_24828()) {
            decay = this.method_5782() ? this.falloffGroundVelocityDecay(this.getProperties().get(AircraftStat.GROUND_FRICTION)) : 0.75f;
        }
        Vector3f direction = this.getForwardDirection();
        float diff = (float)(this.lastY - this.method_23318());
        if (this.lastY != 0.0 && this.getProperties().get(AircraftStat.GLIDE_FACTOR) > 0.0f && (double)diff != 0.0) {
            this.method_18799(this.method_18798().method_1019(this.toVec3d(direction).method_1021((double)(diff * this.getProperties().get(AircraftStat.GLIDE_FACTOR) * (1.0f - Math.abs(direction.y))))));
        }
        this.lastY = (float)this.method_23318();
        this.convertPower(this.toVec3d(direction));
        class_243 velocity = this.method_18798();
        float hd = this.getProperties().get(AircraftStat.HORIZONTAL_DECAY);
        float vd = this.getProperties().get(AircraftStat.VERTICAL_DECAY);
        this.method_18800(velocity.field_1352 * (double)decay * (double)hd, velocity.field_1351 * (double)decay * (double)vd + (double)gravity, velocity.field_1350 * (double)decay * (double)hd);
        float rf = decay * this.getProperties().get(AircraftStat.ROTATION_DECAY);
        this.pressingInterpolatedX.decay(0.0f, 1.0f - rf);
        this.pressingInterpolatedZ.decay(0.0f, 1.0f - rf);
        if (!this.method_24828()) {
            Vector3f effect = this.getWindEffect();
            this.method_36457(this.method_36455() + effect.x);
            this.method_36456(this.method_36454() + effect.z);
            float offsetStrength = 0.005f;
            this.method_18799(this.method_18798().method_1031((double)(effect.x * offsetStrength), 0.0, (double)(effect.z * offsetStrength)));
        }
    }

    @Override
    public void chill() {
        this.lastY = 0.0;
    }

    @Override
    public float getDurability() {
        return this.getProperties().get(AircraftStat.DURABILITY);
    }

    public float getWindStrength() {
        float sensitivity = this.getProperties().get(AircraftStat.WIND);
        float thundering = this.method_37908().method_8430(0.0f);
        float raining = this.method_37908().method_8478(0.0f);
        float weather = (float)((double)Config.getInstance().windClearWeather + this.method_18798().method_1033() + (double)(thundering * Config.getInstance().windThunderWeather) + (double)(raining * Config.getInstance().windRainWeather));
        return weather * sensitivity;
    }

    public Vector3f getWindEffect() {
        float wind = this.getWindStrength();
        float nx = (float)(Utils.cosNoise((double)this.field_6012 / 20.0 / (double)this.getProperties().get(AircraftStat.MASS)) * (double)wind);
        float nz = (float)(Utils.cosNoise((double)this.field_6012 / 21.0 / (double)this.getProperties().get(AircraftStat.MASS)) * (double)wind);
        return new Vector3f(nx, 0.0f, nz);
    }

    public boolean isScoping() {
        Collection<List<Weapon>> values = this.getWeapons().values();
        for (List<Weapon> weapons : values) {
            for (Weapon weapon : weapons) {
                Telescope telescope;
                if (!(weapon instanceof Telescope) || !(telescope = (Telescope)weapon).isScoping().booleanValue()) continue;
                return true;
            }
        }
        return false;
    }

    public void setAnimationVariables(float tickDelta) {
        BBAnimationVariables.set("pressing_interpolated_x", this.pressingInterpolatedX.getSmooth(tickDelta));
        BBAnimationVariables.set("pressing_interpolated_y", this.pressingInterpolatedY.getSmooth(tickDelta));
        BBAnimationVariables.set("pressing_interpolated_z", this.pressingInterpolatedZ.getSmooth(tickDelta));
    }
}

