/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft.data;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import immersive_aircraft.Main;
import immersive_aircraft.data.DataLoader;
import immersive_aircraft.entity.misc.AircraftData;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3695;

public class AircraftDataLoader
extends DataLoader {
    public static final Map<class_2960, AircraftData> REGISTRY = new HashMap<class_2960, AircraftData>();
    public static final Map<class_2960, AircraftData> CLIENT_REGISTRY = new HashMap<class_2960, AircraftData>();
    private static final AircraftData EMPTY = new AircraftData();

    public AircraftDataLoader() {
        super(new Gson(), "aircraft");
    }

    protected void apply(Map<class_2960, JsonElement> jsonMap, class_3300 manager, class_3695 profiler) {
        REGISTRY.clear();
        jsonMap.forEach((identifier, jsonElement) -> {
            try {
                AircraftData data = new AircraftData(jsonElement.getAsJsonObject());
                REGISTRY.put((class_2960)identifier, data);
            }
            catch (JsonParseException | IllegalArgumentException exception) {
                Main.LOGGER.error("Parsing error on aircraft {}: {}", identifier, (Object)exception.getMessage());
            }
        });
        CLIENT_REGISTRY.clear();
        CLIENT_REGISTRY.putAll(REGISTRY);
    }

    public static AircraftData get(class_2960 identifier) {
        return CLIENT_REGISTRY.getOrDefault(identifier, EMPTY);
    }
}

