/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft.client.render.entity.renderer;

import com.mojang.datafixers.util.Pair;
import immersive_aircraft.Main;
import immersive_aircraft.WeaponRendererRegistry;
import immersive_aircraft.client.render.entity.renderer.TrailRenderer;
import immersive_aircraft.client.render.entity.renderer.utils.BBModelRenderer;
import immersive_aircraft.client.render.entity.renderer.utils.ModelPartRenderHandler;
import immersive_aircraft.client.render.entity.weaponRenderer.WeaponRenderer;
import immersive_aircraft.entity.AircraftEntity;
import immersive_aircraft.entity.InventoryVehicleEntity;
import immersive_aircraft.entity.VehicleEntity;
import immersive_aircraft.entity.misc.VehicleInventoryDescription;
import immersive_aircraft.entity.weapons.Weapon;
import immersive_aircraft.resources.BBModelLoader;
import immersive_aircraft.resources.bbmodel.BBAnimationVariables;
import immersive_aircraft.resources.bbmodel.BBFaceContainer;
import immersive_aircraft.resources.bbmodel.BBMesh;
import immersive_aircraft.resources.bbmodel.BBModel;
import immersive_aircraft.resources.bbmodel.BBObject;
import immersive_aircraft.util.Utils;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1746;
import net.minecraft.class_1767;
import net.minecraft.class_1769;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_238;
import net.minecraft.class_2582;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4604;
import net.minecraft.class_5617;
import net.minecraft.class_6880;
import net.minecraft.class_746;
import net.minecraft.class_7833;
import net.minecraft.class_897;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;

public abstract class AircraftEntityRenderer<T extends AircraftEntity>
extends class_897<T> {
    private static final class_2960 TEXTURE = new class_2960("invalid");

    public AircraftEntityRenderer(class_5617.class_5618 context) {
        super(context);
    }

    protected abstract ModelPartRenderHandler<T> getModel(AircraftEntity var1);

    protected abstract class_2960 getModelId();

    protected Vector3f getPivot(AircraftEntity entity) {
        return new Vector3f(0.0f, 0.0f, 0.0f);
    }

    public void render(T entity, float yaw, float tickDelta, class_4587 matrixStack, class_4597 vertexConsumerProvider, int light) {
        class_4587.class_4665 peek = matrixStack.method_23760();
        matrixStack.method_22903();
        float h = (float)((VehicleEntity)((Object)entity)).getDamageWobbleTicks() - tickDelta;
        float j = ((VehicleEntity)((Object)entity)).getDamageWobbleStrength() - tickDelta;
        if (j < 0.0f) {
            j = 0.0f;
        }
        if (h > 0.0f) {
            matrixStack.method_22907(class_7833.field_40714.rotationDegrees(class_3532.method_15374((float)h) * h * j / 10.0f * (float)((VehicleEntity)((Object)entity)).getDamageWobbleSide()));
        }
        Vector3f effect = entity.method_24828() ? new Vector3f(0.0f, 0.0f, 0.0f) : ((AircraftEntity)((Object)entity)).getWindEffect();
        matrixStack.method_22907(class_7833.field_40716.rotationDegrees(-yaw));
        matrixStack.method_22907(class_7833.field_40714.rotationDegrees(entity.method_5695(tickDelta) + effect.z));
        matrixStack.method_22907(class_7833.field_40718.rotationDegrees(((VehicleEntity)((Object)entity)).getRoll(tickDelta) + effect.x));
        Vector3f pivot = this.getPivot((AircraftEntity)((Object)entity));
        matrixStack.method_46416(pivot.x, pivot.y, pivot.z);
        float time = ((float)(entity.method_37908().method_8510() % 24000L) + tickDelta) / 20.0f;
        BBAnimationVariables.set("time", time);
        ((AircraftEntity)((Object)entity)).setAnimationVariables(tickDelta);
        BBModel bbModel = BBModelLoader.MODELS.get(this.getModelId());
        if (bbModel != null) {
            float health = ((VehicleEntity)((Object)entity)).getHealth();
            float r = health * 0.6f + 0.4f;
            float g = health * 0.4f + 0.6f;
            float b = health * 0.4f + 0.6f;
            BBModelRenderer.renderModel(bbModel, matrixStack, vertexConsumerProvider, light, time, entity, this.getModel((AircraftEntity)((Object)entity)), r, g, b, 1.0f);
        }
        class_746 player = class_310.method_1551().field_1724;
        for (List<Weapon> weapons : ((InventoryVehicleEntity)((Object)entity)).getWeapons().values()) {
            for (Weapon weapon : weapons) {
                WeaponRenderer<Weapon> renderer;
                if (weapon.getMount().blocking() && Main.firstPersonGetter.isFirstPerson() && player != null && entity.method_5626((class_1297)player) || (renderer = WeaponRendererRegistry.get(weapon)) == null) continue;
                renderer.render(entity, weapon, matrixStack, vertexConsumerProvider, light, tickDelta);
            }
        }
        ((AircraftEntity)((Object)entity)).getTrails().forEach(t -> TrailRenderer.render(t, vertexConsumerProvider, peek));
        matrixStack.method_22909();
        super.method_3936(entity, yaw, tickDelta, matrixStack, vertexConsumerProvider, light);
    }

    public void renderOptionalObject(String name, BBModel model, class_4597 vertexConsumerProvider, T entity, class_4587 matrixStack, int light, float time) {
        this.renderOptionalObject(name, model, vertexConsumerProvider, entity, matrixStack, light, time, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    public void renderOptionalObject(String name, BBModel model, class_4597 vertexConsumerProvider, T entity, class_4587 matrixStack, int light, float time, float red, float green, float blue, float alpha) {
        BBObject object = model.objectsByName.get(name);
        if (object != null) {
            BBModelRenderer.renderObject(model, object, matrixStack, vertexConsumerProvider, light, time, entity, null, red, green, blue, alpha);
        }
    }

    public boolean shouldRender(T entity, class_4604 frustum, double x, double y, double z) {
        if (!entity.method_5727(x, y, z)) {
            return false;
        }
        class_238 box = ((VehicleEntity)((Object)entity)).method_5830().method_1014(1.0);
        return frustum.method_23093(box);
    }

    public class_2960 getTextureLocation(@NotNull T aircraft) {
        return TEXTURE;
    }

    public void renderBanners(BBModel model, BBObject ignoredObject, class_4597 vertexConsumerProvider, T entity, class_4587 matrixStack, int light, float time, ModelPartRenderHandler<T> modelPartRenderer) {
        List<class_1799> slots = ((InventoryVehicleEntity)((Object)entity)).getSlots(VehicleInventoryDescription.SlotType.BANNER);
        int i = 0;
        for (class_1799 slot : slots) {
            BBObject bannerObject;
            if (slot.method_7960() || !(slot.method_7909() instanceof class_1746)) continue;
            List<Pair<class_6880<class_2582>, class_1767>> patterns = Utils.parseBannerItem(slot);
            if (!((bannerObject = model.objectsByName.get("banner_" + i++)) instanceof BBFaceContainer)) continue;
            BBFaceContainer bannerContainer = (BBFaceContainer)((Object)bannerObject);
            BBModelRenderer.renderBanner(bannerContainer, matrixStack, vertexConsumerProvider, light, true, patterns);
        }
    }

    public void renderSails(BBObject object, class_4597 vertexConsumerProvider, T entity, class_4587 matrixStack, int light, float time) {
        class_1767 color;
        class_1799 stack = ((InventoryVehicleEntity)((Object)entity)).getSlots(VehicleInventoryDescription.SlotType.DYE).get(0);
        class_1792 class_17922 = stack.method_7909();
        if (class_17922 instanceof class_1769) {
            class_1769 item = (class_1769)class_17922;
            color = item.method_7802();
        } else {
            color = class_1767.field_7952;
        }
        float r = color.method_7787()[0];
        float g = color.method_7787()[1];
        float b = color.method_7787()[2];
        if (object instanceof BBMesh) {
            BBMesh mesh = (BBMesh)object;
            BBModelRenderer.renderSailObject(mesh, matrixStack, vertexConsumerProvider, light, time, r, g, b, 1.0f);
        }
    }
}

