/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.servux.network;

import com.google.common.base.Charsets;
import fi.dy.masa.servux.mixin.IMixinCustomPayloadC2SPacket;
import fi.dy.masa.servux.network.IPluginChannelHandler;
import fi.dy.masa.servux.network.PacketSplitter;
import fi.dy.masa.servux.network.util.PacketUtils;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.class_2540;
import net.minecraft.class_2817;
import net.minecraft.class_2960;
import net.minecraft.class_3244;

public class ServerPacketChannelHandler {
    public static final class_2960 REGISTER = new class_2960("minecraft:register");
    public static final class_2960 UNREGISTER = new class_2960("minecraft:unregister");
    public static final ServerPacketChannelHandler INSTANCE = new ServerPacketChannelHandler();
    private final HashMap<class_2960, IPluginChannelHandler> handlers = new HashMap();
    private final HashMap<class_2960, IPluginChannelHandler> subscribableHandlers = new HashMap();

    private ServerPacketChannelHandler() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerServerChannelHandler(IPluginChannelHandler handler) {
        HashMap<class_2960, IPluginChannelHandler> hashMap = this.handlers;
        synchronized (hashMap) {
            ArrayList<class_2960> toRegister = new ArrayList<class_2960>();
            class_2960 channel = handler.getChannel();
            if (!this.handlers.containsKey(channel)) {
                this.handlers.put(channel, handler);
                toRegister.add(channel);
                if (handler.isSubscribable()) {
                    this.subscribableHandlers.put(channel, handler);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterServerChannelHandler(IPluginChannelHandler handler) {
        HashMap<class_2960, IPluginChannelHandler> hashMap = this.handlers;
        synchronized (hashMap) {
            ArrayList<class_2960> toUnRegister = new ArrayList<class_2960>();
            class_2960 channel = handler.getChannel();
            if (this.handlers.remove(channel, handler)) {
                toUnRegister.add(channel);
                this.subscribableHandlers.remove(channel);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processPacketFromClient(class_2817 packet, class_3244 netHandler) {
        IPluginChannelHandler handler;
        IMixinCustomPayloadC2SPacket accessor = (IMixinCustomPayloadC2SPacket)packet;
        class_2960 channel = accessor.servux_getChannel();
        class_2540 data = accessor.servux_getData();
        HashMap<class_2960, IPluginChannelHandler> hashMap = this.handlers;
        synchronized (hashMap) {
            handler = this.handlers.get(channel);
        }
        if (handler != null) {
            class_2540 slice = PacketUtils.retainedSlice((ByteBuf)data);
            this.schedule(() -> this.handleReceivedData(channel, slice, handler, netHandler), netHandler);
        } else if (channel.equals((Object)REGISTER)) {
            channels = ServerPacketChannelHandler.getChannels(data);
            this.schedule(() -> this.updateRegistrationForChannels(channels, IPluginChannelHandler::subscribe, netHandler), netHandler);
        } else if (channel.equals((Object)UNREGISTER)) {
            channels = ServerPacketChannelHandler.getChannels(data);
            this.schedule(() -> this.updateRegistrationForChannels(channels, IPluginChannelHandler::unsubscribe, netHandler), netHandler);
        }
    }

    private void updateRegistrationForChannels(List<class_2960> channels, BiConsumer<IPluginChannelHandler, class_3244> action, class_3244 netHandler) {
        for (class_2960 channel : channels) {
            IPluginChannelHandler handler = this.subscribableHandlers.get(channel);
            if (handler == null) continue;
            action.accept(handler, netHandler);
        }
    }

    private void handleReceivedData(class_2960 channel, class_2540 data, IPluginChannelHandler handler, class_3244 netHandler) {
        class_2540 buf = PacketSplitter.receive(channel, data, netHandler);
        data.release();
        if (buf != null) {
            handler.onPacketReceived(buf, netHandler);
            buf.release();
        }
    }

    private void schedule(Runnable task, class_3244 netHandler) {
        netHandler.method_32311().method_5682().execute(task);
    }

    private static List<class_2960> getChannels(class_2540 buf) {
        buf.readerIndex(0);
        buf = PacketUtils.slice((ByteBuf)buf);
        byte[] bytes = new byte[buf.readableBytes()];
        buf.readBytes(bytes);
        String channelString = new String(bytes, Charsets.UTF_8);
        ArrayList<class_2960> channels = new ArrayList<class_2960>();
        for (String channel : channelString.split("\u0000")) {
            try {
                class_2960 id = new class_2960(channel);
                channels.add(id);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return channels;
    }
}

