/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.servux.dataproviders;

import fi.dy.masa.servux.dataproviders.DataProviderBase;
import fi.dy.masa.servux.network.IPluginChannelHandler;
import fi.dy.masa.servux.network.PacketSplitter;
import fi.dy.masa.servux.network.packet.StructureDataPacketHandler;
import fi.dy.masa.servux.util.PlayerDimensionPosition;
import fi.dy.masa.servux.util.Timeout;
import it.unimi.dsi.fastutil.longs.LongCollection;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_1657;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2791;
import net.minecraft.class_2806;
import net.minecraft.class_2818;
import net.minecraft.class_3195;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3449;
import net.minecraft.class_6625;
import net.minecraft.server.MinecraftServer;

public class StructureDataProvider
extends DataProviderBase {
    public static final StructureDataProvider INSTANCE = new StructureDataProvider();
    protected final Map<UUID, PlayerDimensionPosition> registeredPlayers = new HashMap<UUID, PlayerDimensionPosition>();
    protected final Map<UUID, Map<class_1923, Timeout>> timeouts = new HashMap<UUID, Map<class_1923, Timeout>>();
    protected final class_2487 metadata = new class_2487();
    protected int timeout = 600;
    protected int updateInterval = 40;
    protected int retainDistance;

    protected StructureDataProvider() {
        super("structure_bounding_boxes", StructureDataPacketHandler.CHANNEL, 1, "Structure Bounding Boxes data for structures such as Witch Huts, Ocean Monuments, Nether Fortresses etc.");
        this.metadata.method_10582("id", StructureDataPacketHandler.CHANNEL.toString());
        this.metadata.method_10569("timeout", this.timeout);
        this.metadata.method_10569("version", 1);
    }

    @Override
    public boolean shouldTick() {
        return true;
    }

    @Override
    public IPluginChannelHandler getPacketHandler() {
        return StructureDataPacketHandler.INSTANCE;
    }

    @Override
    public void tick(MinecraftServer server, int tickCounter) {
        if (tickCounter % this.updateInterval == 0 && !this.registeredPlayers.isEmpty()) {
            this.retainDistance = server.method_3760().method_14568() + 2;
            Iterator<UUID> uuidIter = this.registeredPlayers.keySet().iterator();
            while (uuidIter.hasNext()) {
                UUID uuid = uuidIter.next();
                class_3222 player = server.method_3760().method_14602(uuid);
                if (player != null) {
                    this.checkForDimensionChange(player);
                    this.refreshTrackedChunks(player, tickCounter);
                    continue;
                }
                this.timeouts.remove(uuid);
                uuidIter.remove();
            }
        }
    }

    public void onStartedWatchingChunk(class_3222 player, class_2818 chunk) {
        UUID uuid = player.method_5667();
        if (this.registeredPlayers.containsKey(uuid)) {
            this.addChunkTimeoutIfHasReferences(uuid, chunk, player.method_5682().method_3780());
        }
    }

    public boolean register(class_3222 player) {
        boolean registered = false;
        UUID uuid = player.method_5667();
        if (!this.registeredPlayers.containsKey(uuid)) {
            PacketSplitter.sendPacketTypeAndCompound(StructureDataPacketHandler.CHANNEL, 1, this.metadata, player);
            this.registeredPlayers.put(uuid, new PlayerDimensionPosition((class_1657)player));
            int tickCounter = player.method_5682().method_3780();
            this.initialSyncStructuresToPlayerWithinRange(player, player.method_5682().method_3760().method_14568(), tickCounter);
            registered = true;
        }
        return registered;
    }

    public boolean unregister(class_3222 player) {
        return this.registeredPlayers.remove(player.method_5667()) != null;
    }

    protected void initialSyncStructuresToPlayerWithinRange(class_3222 player, int chunkRadius, int tickCounter) {
        UUID uuid = player.method_5667();
        class_1923 center = player.method_14232().method_18692();
        Map<class_3195, LongSet> references = this.getStructureReferencesWithinRange(player.method_51469(), center, chunkRadius);
        this.timeouts.remove(uuid);
        this.registeredPlayers.computeIfAbsent(uuid, u -> new PlayerDimensionPosition((class_1657)player)).setPosition((class_1657)player);
        this.sendStructures(player, references, tickCounter);
    }

    protected void addChunkTimeoutIfHasReferences(UUID uuid, class_2818 chunk, int tickCounter) {
        class_1923 pos = chunk.method_12004();
        if (this.chunkHasStructureReferences(pos.field_9181, pos.field_9180, chunk.method_12200())) {
            Map map = this.timeouts.computeIfAbsent(uuid, u -> new HashMap());
            int timeout = this.timeout;
            map.computeIfAbsent(pos, p -> new Timeout(tickCounter - timeout));
        }
    }

    protected void checkForDimensionChange(class_3222 player) {
        UUID uuid = player.method_5667();
        PlayerDimensionPosition playerPos = this.registeredPlayers.get(uuid);
        if (playerPos == null || playerPos.dimensionChanged((class_1657)player)) {
            this.timeouts.remove(uuid);
            this.registeredPlayers.computeIfAbsent(uuid, u -> new PlayerDimensionPosition((class_1657)player)).setPosition((class_1657)player);
        }
    }

    protected void addOrRefreshTimeouts(UUID uuid, Map<class_3195, LongSet> references, int tickCounter) {
        Map map = this.timeouts.computeIfAbsent(uuid, u -> new HashMap());
        for (LongSet chunks : references.values()) {
            for (Long chunkPosLong : chunks) {
                class_1923 pos = new class_1923(chunkPosLong.longValue());
                map.computeIfAbsent(pos, p -> new Timeout(tickCounter)).setLastSync(tickCounter);
            }
        }
    }

    protected void refreshTrackedChunks(class_3222 player, int tickCounter) {
        UUID uuid = player.method_5667();
        Map<class_1923, Timeout> map = this.timeouts.get(uuid);
        if (map != null) {
            this.sendAndRefreshExpiredStructures(player, map, tickCounter);
        }
    }

    protected boolean isOutOfRange(class_1923 pos, class_1923 center) {
        int chunkRadius = this.retainDistance;
        return Math.abs(pos.field_9181 - center.field_9181) > chunkRadius || Math.abs(pos.field_9180 - center.field_9180) > chunkRadius;
    }

    protected void sendAndRefreshExpiredStructures(class_3222 player, Map<class_1923, Timeout> map, int tickCounter) {
        HashSet<class_1923> positionsToUpdate = new HashSet<class_1923>();
        for (Map.Entry<class_1923, Timeout> entry : map.entrySet()) {
            Timeout timeout = entry.getValue();
            if (!timeout.needsUpdate(tickCounter, this.timeout)) continue;
            positionsToUpdate.add(entry.getKey());
        }
        if (!positionsToUpdate.isEmpty()) {
            class_3218 world = player.method_51469();
            class_1923 center = player.method_14232().method_18692();
            HashMap<class_3195, LongSet> references = new HashMap<class_3195, LongSet>();
            for (class_1923 pos : positionsToUpdate) {
                if (this.isOutOfRange(pos, center)) {
                    map.remove(pos);
                    continue;
                }
                this.getStructureReferencesFromChunk(pos.field_9181, pos.field_9180, (class_1937)world, references);
                Timeout timeout = map.get(pos);
                if (timeout == null) continue;
                timeout.setLastSync(tickCounter);
            }
            if (!references.isEmpty()) {
                this.sendStructures(player, references, tickCounter);
            }
        }
    }

    protected void getStructureReferencesFromChunk(int chunkX, int chunkZ, class_1937 world, Map<class_3195, LongSet> references) {
        if (!world.method_8393(chunkX, chunkZ)) {
            return;
        }
        class_2791 chunk = world.method_8402(chunkX, chunkZ, class_2806.field_16423, false);
        if (chunk == null) {
            return;
        }
        for (Map.Entry entry : chunk.method_12179().entrySet()) {
            class_3195 feature = (class_3195)entry.getKey();
            LongSet startChunks = (LongSet)entry.getValue();
            if (startChunks.isEmpty()) continue;
            references.merge(feature, startChunks, (oldSet, entrySet) -> {
                LongOpenHashSet newSet = new LongOpenHashSet((LongCollection)oldSet);
                newSet.addAll((LongCollection)entrySet);
                return newSet;
            });
        }
    }

    protected boolean chunkHasStructureReferences(int chunkX, int chunkZ, class_1937 world) {
        if (!world.method_8393(chunkX, chunkZ)) {
            return false;
        }
        class_2791 chunk = world.method_8402(chunkX, chunkZ, class_2806.field_16423, false);
        if (chunk == null) {
            return false;
        }
        for (Map.Entry entry : chunk.method_12179().entrySet()) {
            if (((LongSet)entry.getValue()).isEmpty()) continue;
            return true;
        }
        return false;
    }

    protected Map<class_1923, class_3449> getStructureStartsFromReferences(class_3218 world, Map<class_3195, LongSet> references) {
        HashMap<class_1923, class_3449> starts = new HashMap<class_1923, class_3449>();
        for (Map.Entry<class_3195, LongSet> entry : references.entrySet()) {
            class_3195 structure = entry.getKey();
            LongSet startChunks = entry.getValue();
            LongIterator iter = startChunks.iterator();
            while (iter.hasNext()) {
                class_3449 start;
                class_2791 chunk;
                class_1923 pos = new class_1923(iter.nextLong());
                if (!world.method_8393(pos.field_9181, pos.field_9180) || (chunk = world.method_8402(pos.field_9181, pos.field_9180, class_2806.field_16423, false)) == null || (start = chunk.method_12181(structure)) == null) continue;
                starts.put(pos, start);
            }
        }
        return starts;
    }

    protected Map<class_3195, LongSet> getStructureReferencesWithinRange(class_3218 world, class_1923 center, int chunkRadius) {
        HashMap<class_3195, LongSet> references = new HashMap<class_3195, LongSet>();
        for (int cx = center.field_9181 - chunkRadius; cx <= center.field_9181 + chunkRadius; ++cx) {
            for (int cz = center.field_9180 - chunkRadius; cz <= center.field_9180 + chunkRadius; ++cz) {
                this.getStructureReferencesFromChunk(cx, cz, (class_1937)world, references);
            }
        }
        return references;
    }

    protected void sendStructures(class_3222 player, Map<class_3195, LongSet> references, int tickCounter) {
        class_3218 world = player.method_51469();
        Map<class_1923, class_3449> starts = this.getStructureStartsFromReferences(world, references);
        if (!starts.isEmpty()) {
            this.addOrRefreshTimeouts(player.method_5667(), references, tickCounter);
            class_2499 structureList = this.getStructureList(starts, world);
            class_2487 tag = new class_2487();
            tag.method_10566("Structures", (class_2520)structureList);
            PacketSplitter.sendPacketTypeAndCompound(StructureDataPacketHandler.CHANNEL, 2, tag, player);
        }
    }

    protected class_2499 getStructureList(Map<class_1923, class_3449> structures, class_3218 world) {
        class_2499 list = new class_2499();
        class_6625 ctx = class_6625.method_38713((class_3218)world);
        for (Map.Entry<class_1923, class_3449> entry : structures.entrySet()) {
            class_1923 pos = entry.getKey();
            list.add((Object)entry.getValue().method_14972(ctx, pos));
        }
        return list;
    }
}

