/*
 * Decompiled with CFR 0.152.
 */
package fuzs.echochest.world.level.block.entity;

import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import fuzs.echochest.EchoChest;
import fuzs.echochest.init.ModRegistry;
import fuzs.echochest.world.inventory.EchoChestMenu;
import fuzs.echochest.world.level.block.entity.EchoChestListener;
import fuzs.echochest.world.level.block.entity.EchoChestOpenersCounter;
import fuzs.echochest.world.level.block.entity.EchoChestVibrationUser;
import java.util.stream.IntStream;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1278;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2336;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_2595;
import net.minecraft.class_2614;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3481;
import net.minecraft.class_3532;
import net.minecraft.class_3913;
import net.minecraft.class_5250;
import net.minecraft.class_5702;
import net.minecraft.class_5714;
import net.minecraft.class_8514;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class EchoChestBlockEntity
extends class_2595
implements class_1278,
class_5714.class_8513<EchoChestListener>,
class_8514 {
    public static final String TAG_EXPERIENCE = "Experience";
    public static final class_5250 CONTAINER_TITLE = class_2561.method_43471((String)"container.echo_chest");
    public static final int CONTAINER_SIZE = 25;
    public static final int MAX_EXPERIENCE = 3000;
    public static final int EXPERIENCE_PER_BOTTLE = 7;
    private final class_3913 dataAccess = new class_3913(){

        public int method_17390(int index) {
            return index == 0 ? EchoChestBlockEntity.this.experience : 0;
        }

        public void method_17391(int index, int value) {
            if (index == 0) {
                EchoChestBlockEntity.this.experience = value;
            }
        }

        public int method_17389() {
            return 1;
        }
    };
    final EchoChestOpenersCounter openersCounter;
    private final int[] allSlots;
    private final int[] inventorySlots;
    private final EchoChestListener listener;
    private final class_8514.class_5719 user;
    private class_8514.class_8515 vibrationData;
    private int experience;

    public EchoChestBlockEntity(class_2338 blockPos, class_2680 blockState) {
        super((class_2591)ModRegistry.ECHO_CHEST_BLOCK_ENTITY_TYPE.get(), blockPos, blockState);
        this.method_11281(class_2371.method_10213((int)this.method_5439(), (Object)class_1799.field_8037));
        this.allSlots = IntStream.range(0, this.method_5439()).toArray();
        this.inventorySlots = IntStream.range(1, this.method_5439()).toArray();
        this.openersCounter = new EchoChestOpenersCounter((class_1263)this);
        this.listener = new EchoChestListener(this);
        this.user = new EchoChestVibrationUser(this);
        this.vibrationData = new class_8514.class_8515();
    }

    public static void serverTick(class_1937 level, class_2338 pos, class_2680 state, EchoChestBlockEntity blockEntity) {
        if (blockEntity.experience >= 7 && EchoChestMenu.validBottleItem(blockEntity.method_5438(0)) && class_2614.method_11260(null, (class_1263)blockEntity, (class_1799)new class_1799((class_1935)class_1802.field_8287), null).method_7960()) {
            blockEntity.extractExperienceBottle();
            class_1799 stack = blockEntity.method_5438(0).method_7972();
            stack.method_7934(1);
            blockEntity.method_5447(0, stack);
        }
    }

    static void animate(class_1937 level, class_2338 pos, class_2680 state, EchoChestOpenersCounter openersCounter) {
        openersCounter.incrementOpeners(null, level, pos, state);
        if (!((Boolean)state.method_11654((class_2769)class_2336.field_10968)).booleanValue()) {
            level.method_43128(null, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, class_3417.field_28968, class_3419.field_15245, 1.0f, level.field_9229.method_43057() * 0.2f + 0.8f);
        }
    }

    static boolean isOccluded(class_1937 level, class_243 from, class_243 to) {
        from = new class_243((double)class_3532.method_15357((double)from.field_1352) + 0.5, (double)class_3532.method_15357((double)from.field_1351) + 0.5, (double)class_3532.method_15357((double)from.field_1350) + 0.5);
        to = new class_243((double)class_3532.method_15357((double)to.field_1352) + 0.5, (double)class_3532.method_15357((double)to.field_1351) + 0.5, (double)class_3532.method_15357((double)to.field_1350) + 0.5);
        for (class_2350 direction : class_2350.values()) {
            class_243 vec3 = from.method_43206(direction, (double)1.0E-5f);
            if (level.method_32880(new class_5702(vec3, to, blockState -> blockState.method_26164(class_3481.field_28088))).method_17783() == class_239.class_240.field_1332) continue;
            return false;
        }
        return true;
    }

    public int method_5439() {
        return 25;
    }

    protected class_2561 method_17823() {
        return CONTAINER_TITLE;
    }

    public boolean canAcceptExperience() {
        return this.experience < 3000;
    }

    public void acceptExperience(int amount) {
        int lastExperience = this.experience;
        this.experience = class_3532.method_15340((int)(this.experience + amount), (int)0, (int)3000);
        if (this.experience != lastExperience) {
            this.method_5431();
        }
    }

    public void extractExperienceBottle() {
        this.acceptExperience(-7);
    }

    public void method_11014(class_2487 tag) {
        super.method_11014(tag);
        this.method_11281(class_2371.method_10213((int)this.method_5439(), (Object)class_1799.field_8037));
        if (!this.method_11283(tag)) {
            class_1262.method_5429((class_2487)tag, (class_2371)this.method_11282());
        }
        this.experience = tag.method_10550(TAG_EXPERIENCE);
        if (tag.method_10573("listener", 10)) {
            class_8514.class_8515.field_44640.parse(new Dynamic((DynamicOps)class_2509.field_11560, (Object)tag.method_10562("listener"))).resultOrPartial(arg_0 -> ((Logger)EchoChest.LOGGER).error(arg_0)).ifPresent(data -> {
                this.vibrationData = data;
            });
        }
    }

    protected void method_11007(class_2487 tag) {
        super.method_11007(tag);
        tag.method_10551("Items");
        if (!this.method_11286(tag)) {
            class_1262.method_5427((class_2487)tag, (class_2371)this.method_11282(), (boolean)true);
        }
        tag.method_10569(TAG_EXPERIENCE, this.experience);
        class_8514.class_8515.field_44640.encodeStart((DynamicOps)class_2509.field_11560, (Object)this.vibrationData).resultOrPartial(arg_0 -> ((Logger)EchoChest.LOGGER).error(arg_0)).ifPresent(data -> tag.method_10566("listener", data));
    }

    protected class_1703 method_5465(int containerId, class_1661 inventory) {
        return new EchoChestMenu(containerId, inventory, (class_1263)this, this.dataAccess);
    }

    public void method_5435(class_1657 player) {
        if (!this.field_11865 && !player.method_7325()) {
            this.openersCounter.incrementOpeners(player, this.method_10997(), this.method_11016(), this.method_11010());
        }
    }

    public void method_5432(class_1657 player) {
        if (!this.field_11865 && !player.method_7325()) {
            this.openersCounter.decrementOpeners(player, this.method_10997(), this.method_11016(), this.method_11010());
        }
    }

    public void method_31671() {
        if (!this.field_11865) {
            this.openersCounter.recheckOpeners(this.method_10997(), this.method_11016(), this.method_11010());
        }
    }

    public boolean method_5437(int index, class_1799 stack) {
        return index != 0 || EchoChestMenu.validBottleItem(stack);
    }

    public int[] method_5494(class_2350 side) {
        return side.method_10166().method_10180() == class_2350.class_2353.field_11062 ? this.allSlots : this.inventorySlots;
    }

    public boolean method_5492(int index, class_1799 itemStack, @Nullable class_2350 direction) {
        return (index != 0 || direction != null) && this.method_5437(index, itemStack);
    }

    public boolean method_5493(int index, class_1799 stack, class_2350 direction) {
        return index != 0;
    }

    public EchoChestListener getListener() {
        return this.listener;
    }

    public class_8514.class_5719 method_51299() {
        return this.user;
    }

    public class_8514.class_8515 method_51298() {
        return this.vibrationData;
    }
}

