/*
 * Decompiled with CFR 0.152.
 */
package io.github.lieonlion.quad.enchantment;

import io.github.lieonlion.quad.tags.QuadEnchantmentTags;
import java.util.Map;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_6862;
import net.minecraft.class_7923;

public class QuadEnchantmentHelper {
    public static int getLevelFromTag(class_6862<class_1887> enchantmentTagKey, class_1799 stack) {
        class_1887 enchantment = QuadEnchantmentHelper.getEnchantmentFromTag(enchantmentTagKey, stack);
        return QuadEnchantmentHelper.getLevel(enchantment, stack);
    }

    public static int getEquipmentLevelFromTag(class_6862<class_1887> enchantmentTagKey, class_1309 living) {
        class_1799 stack = QuadEnchantmentHelper.getEquipmentFromTag(enchantmentTagKey, living);
        class_1887 enchantment = QuadEnchantmentHelper.getEnchantmentFromTag(enchantmentTagKey, stack);
        if (enchantment == null || stack == null) {
            return 0;
        }
        return QuadEnchantmentHelper.getLevel(enchantment, stack);
    }

    public static class_1887 getEnchantmentFromTag(class_6862<class_1887> enchantmentTagKey, class_1799 stack) {
        if (stack == null) {
            return null;
        }
        for (Map.Entry entry : class_1890.method_8222((class_1799)stack).entrySet()) {
            class_1887 enchantment = (class_1887)entry.getKey();
            if (!QuadEnchantmentHelper.isIn(enchantmentTagKey, enchantment)) continue;
            return enchantment;
        }
        return null;
    }

    public static class_1799 getEquipmentFromTag(class_6862<class_1887> enchantmentTagKey, class_1309 living) {
        for (class_1799 stack : living.method_5661()) {
            if (!QuadEnchantmentHelper.hasEnchantmentFromTag(enchantmentTagKey, stack)) continue;
            return stack;
        }
        return null;
    }

    public static int getLevel(class_1887 enchantment, class_1799 stack) {
        for (Map.Entry entry : class_1890.method_8222((class_1799)stack).entrySet()) {
            if (enchantment != entry.getKey()) continue;
            return (Integer)entry.getValue();
        }
        return 0;
    }

    public static boolean hasEnchantmentFromTag(class_6862<class_1887> enchantmentTagKey, class_1799 stack) {
        return QuadEnchantmentHelper.getLevelFromTag(enchantmentTagKey, stack) > 0;
    }

    public static boolean hasEnchantmentEquipmentFromTag(class_6862<class_1887> enchantmentTagKey, class_1309 living) {
        return QuadEnchantmentHelper.getEquipmentLevelFromTag(enchantmentTagKey, living) > 0;
    }

    public static boolean hasFireLighter(class_1799 stack) {
        return QuadEnchantmentHelper.getLevelFromTag(QuadEnchantmentTags.FIRE_LIGHTER, stack) > 0;
    }

    public static boolean hasSnowBoots(class_1799 stack) {
        return QuadEnchantmentHelper.getLevelFromTag(QuadEnchantmentTags.SNOW_BOOTS, stack) > 0;
    }

    public static boolean isIn(class_6862<class_1887> enchantmentTagKey, class_1887 enchantment) {
        return class_7923.field_41176.method_47983((Object)enchantment).method_40220(enchantmentTagKey);
    }
}

