/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.block;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.stevekung.fishofthieves.api.block.FishPlaqueRegistry;
import com.stevekung.fishofthieves.blockentity.FishPlaqueBlockEntity;
import com.stevekung.fishofthieves.entity.BucketableEntityType;
import com.stevekung.fishofthieves.registry.FOTSoundEvents;
import com.stevekung.fishofthieves.registry.FOTTags;
import com.stevekung.fishofthieves.utils.FOTPlatform;
import java.util.Map;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_174;
import net.minecraft.class_1743;
import net.minecraft.class_1750;
import net.minecraft.class_1785;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2383;
import net.minecraft.class_2415;
import net.minecraft.class_2464;
import net.minecraft.class_247;
import net.minecraft.class_2470;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2753;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_3468;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_3730;
import net.minecraft.class_3737;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5328;
import net.minecraft.class_5712;
import net.minecraft.class_5761;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class FishPlaqueBlock
extends class_2237
implements class_3737 {
    private final Map<class_2350, class_265> aabb;
    public static final class_2746 WATERLOGGED = class_2741.field_12508;
    public static final class_2753 FACING = class_2383.field_11177;
    public static final class_2758 ROTATION = class_2758.method_11867((String)"rotation", (int)1, (int)8);

    public FishPlaqueBlock(class_4970.class_2251 properties, Type type) {
        super(properties);
        this.aabb = type.aabb;
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)this.field_10647.method_11664()).method_11657((class_2769)FACING, (Comparable)class_2350.field_11043)).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)ROTATION, (Comparable)Integer.valueOf(1)));
    }

    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new FishPlaqueBlockEntity(pos, state);
    }

    public class_265 method_9530(class_2680 state, class_1922 level, class_2338 pos, class_3726 context) {
        return this.aabb.get(state.method_11654((class_2769)FACING));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public class_1269 method_9534(class_2680 state, class_1937 level, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        class_1799 itemStack = player.method_5998(hand);
        class_1792 item = itemStack.method_7909();
        class_2586 blockEntity = level.method_8321(pos);
        if (!(blockEntity instanceof FishPlaqueBlockEntity)) return class_1269.field_5811;
        FishPlaqueBlockEntity fishPlaque = (FishPlaqueBlockEntity)blockEntity;
        if (itemStack.method_31573(FOTTags.Items.FISH_PLAQUE_BUCKET_BLACKLIST)) {
            return class_1269.field_5811;
        }
        if (fishPlaque.hasPlaqueData()) {
            class_1297 entity = FishPlaqueBlockEntity.createEntity(fishPlaque, level);
            class_1792 interactItem = FishPlaqueRegistry.getInteractionItem().getOrDefault(fishPlaque.getEntityKeyFromPlaqueData(), class_1802.field_8705);
            if (itemStack.method_31574(interactItem)) {
                if (!(entity instanceof class_5761)) return class_1269.field_5811;
                class_5761 bucketable = (class_5761)entity;
                class_1799 itemStack2 = bucketable.method_6452();
                bucketable.method_6455(itemStack2);
                level.method_8396(player, pos, bucketable.method_35171(), class_3419.field_15245, 1.0f, 1.0f);
                class_1799 itemStack3 = class_5328.method_30270((class_1799)itemStack, (class_1657)player, (class_1799)itemStack2, (boolean)false);
                player.method_6122(hand, itemStack3);
                fishPlaque.clearDisplayEntity();
                blockEntity.method_5431();
                level.method_8413(pos, state, state, 3);
                level.method_33596((class_1297)player, class_5712.field_28733, pos);
                return class_1269.method_29236((boolean)level.method_8608());
            }
            if (fishPlaque.isWaxed()) {
                if (!(item instanceof class_1743)) return class_1269.field_5811;
                fishPlaque.setWaxed(false);
                blockEntity.method_5431();
                if (player instanceof class_3222) {
                    class_3222 serverPlayer = (class_3222)player;
                    class_174.field_24478.method_23889(serverPlayer, pos, itemStack);
                }
                level.method_8396(player, pos, FOTSoundEvents.FISH_PLAQUE_WAX_OFF, class_3419.field_15245, 1.0f, 1.0f);
                level.method_8444(player, 3004, pos, 0);
                level.method_43276(class_5712.field_28733, pos, class_5712.class_7397.method_43286((class_1297)player, (class_2680)state));
                itemStack.method_7956(1, (class_1309)player, playerx -> playerx.method_20236(hand));
                return class_1269.method_29236((boolean)level.method_8608());
            }
            if (item == class_1802.field_20414) {
                fishPlaque.setWaxed(true);
                blockEntity.method_5431();
                if (player instanceof class_3222) {
                    class_3222 serverPlayer = (class_3222)player;
                    class_174.field_24478.method_23889(serverPlayer, pos, itemStack);
                }
                if (!player.method_31549().field_7477) {
                    itemStack.method_7934(1);
                }
                level.method_43276(class_5712.field_28733, pos, class_5712.class_7397.method_43286((class_1297)player, (class_2680)state));
                level.method_8444(player, 3003, pos, 0);
            }
            level.method_8396(player, pos, FOTSoundEvents.FISH_PLAQUE_ROTATE, class_3419.field_15245, 1.0f, 1.0f);
            level.method_8413(pos, state, state, 3);
            level.method_33596((class_1297)player, class_5712.field_28733, pos);
            level.method_8652(pos, FishPlaqueBlock.cycleRotation(state, player.method_21823()), 3);
            return class_1269.method_29236((boolean)level.method_8608());
        }
        if (!(item instanceof class_1785)) return class_1269.field_5811;
        class_1785 bucket = (class_1785)item;
        class_2487 tag = itemStack.method_7972().method_7948();
        class_1299<?> entityType = FOTPlatform.getMobInBucketItem(bucket);
        String entityKey = class_7923.field_41177.method_10221(entityType).toString();
        class_1792 interactItem = FishPlaqueRegistry.getInteractionItem().getOrDefault(entityKey, class_1802.field_8705);
        tag.method_10582("id", entityKey);
        if (level instanceof class_3218) {
            class_3218 serverLevel = (class_3218)level;
            class_1297 entityToSave = ((BucketableEntityType)entityType).spawnByBucket(serverLevel, itemStack, player, class_3730.field_16473);
            entityToSave.method_5647(tag);
            tag.method_10551("UUID");
        }
        level.method_8396(player, pos, FOTPlatform.getEmptySoundInBucketItem(bucket), class_3419.field_15245, 1.0f, 1.0f);
        fishPlaque.setPlaqueData(tag);
        blockEntity.method_5431();
        level.method_8413(pos, state, state, 3);
        level.method_33596((class_1297)player, class_5712.field_28733, pos);
        if (!player.method_31549().field_7477) {
            player.method_6122(hand, new class_1799((class_1935)interactItem));
        }
        if (level.method_8608()) return class_1269.method_29236((boolean)level.method_8608());
        player.method_7259(class_3468.field_15372.method_14956((Object)item));
        return class_1269.method_29236((boolean)level.method_8608());
    }

    @Nullable
    public class_2680 method_9605(class_1750 context) {
        class_2350[] directions;
        class_2680 blockState = this.method_9564();
        class_3610 fluidState = context.method_8045().method_8316(context.method_8037());
        class_1937 levelReader = context.method_8045();
        class_2338 blockPos = context.method_8037();
        for (class_2350 direction : directions = context.method_7718()) {
            class_2350 direction2;
            if (!direction.method_10166().method_10179() || !(blockState = (class_2680)blockState.method_11657((class_2769)FACING, (Comparable)(direction2 = direction.method_10153()))).method_26184((class_4538)levelReader, blockPos)) continue;
            return (class_2680)blockState.method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.method_15772() == class_3612.field_15910));
        }
        return null;
    }

    public boolean method_9558(class_2680 state, class_4538 level, class_2338 pos) {
        class_2350 direction = (class_2350)state.method_11654((class_2769)FACING);
        class_2338 blockPos = pos.method_10093(direction.method_10153());
        class_2680 blockState = level.method_8320(blockPos);
        return blockState.method_26206((class_1922)level, blockPos, direction);
    }

    public void method_9536(class_2680 state, class_1937 level, class_2338 pos, class_2680 newState, boolean isMoving) {
        if (!state.method_27852(newState.method_26204())) {
            class_2586 blockEntity = level.method_8321(pos);
            if (blockEntity instanceof FishPlaqueBlockEntity) {
                level.method_8455(pos, state.method_26204());
            }
            super.method_9536(state, level, pos, newState, isMoving);
        }
    }

    public void method_9565(class_2680 state, class_3218 level, class_2338 pos, class_1799 stack, boolean dropExperience) {
        super.method_9565(state, level, pos, stack, dropExperience);
        this.spawnFish(state, (class_1937)level, pos, level.method_8321(pos));
    }

    public void method_9556(class_1937 level, class_1657 player, class_2338 pos, class_2680 state, @Nullable class_2586 blockEntity, class_1799 tool) {
        super.method_9556(level, player, pos, state, blockEntity, tool);
        if (!level.method_8608()) {
            this.spawnFish(state, level, pos, blockEntity);
        }
    }

    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 level, class_2338 currentPos, class_2338 neighborPos) {
        if (((Boolean)state.method_11654((class_2769)WATERLOGGED)).booleanValue()) {
            level.method_39281(currentPos, (class_3611)class_3612.field_15910, class_3612.field_15910.method_15789((class_4538)level));
        }
        return direction.method_10153() == state.method_11654((class_2769)FACING) && !state.method_26184((class_4538)level, currentPos) ? class_2246.field_10124.method_9564() : super.method_9559(state, direction, neighborState, level, currentPos, neighborPos);
    }

    public class_3610 method_9545(class_2680 state) {
        return (Boolean)state.method_11654((class_2769)WATERLOGGED) != false ? class_3612.field_15910.method_15729(false) : super.method_9545(state);
    }

    public boolean method_9538(class_2680 blockState) {
        return true;
    }

    public boolean method_9498(class_2680 state) {
        return true;
    }

    public int method_9572(class_2680 state, class_1937 level, class_2338 pos) {
        FishPlaqueBlockEntity fishPlaque;
        class_2586 blockEntity = level.method_8321(pos);
        if (blockEntity instanceof FishPlaqueBlockEntity && (fishPlaque = (FishPlaqueBlockEntity)blockEntity).hasPlaqueData()) {
            return (Integer)state.method_11654((class_2769)ROTATION);
        }
        return 0;
    }

    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11458;
    }

    public class_2680 method_9598(class_2680 state, class_2470 rotation) {
        return (class_2680)state.method_11657((class_2769)FACING, (Comparable)rotation.method_10503((class_2350)state.method_11654((class_2769)FACING)));
    }

    public class_2680 method_9569(class_2680 state, class_2415 mirror) {
        return state.method_26186(mirror.method_10345((class_2350)state.method_11654((class_2769)FACING)));
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{FACING, WATERLOGGED, ROTATION});
    }

    private void spawnFish(class_2680 state, class_1937 level, class_2338 pos, class_2586 blockEntity) {
        FishPlaqueBlockEntity fishPlaque;
        if (blockEntity instanceof FishPlaqueBlockEntity && (fishPlaque = (FishPlaqueBlockEntity)blockEntity).hasPlaqueData()) {
            class_1297 entity = FishPlaqueBlockEntity.createEntity(fishPlaque, level);
            class_2350 direction = (class_2350)state.method_11654((class_2769)FACING);
            double random = level.field_9229.method_43058() * 0.1 + 0.2;
            if (!((Boolean)state.method_11654((class_2769)WATERLOGGED)).booleanValue()) {
                entity.method_5855(100);
            }
            entity.method_5808((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, direction.method_10144(), 0.0f);
            entity.method_18800(level.field_9229.method_43385((double)direction.method_10148() * random, 0.0172275), 0.4, level.field_9229.method_43385((double)direction.method_10165() * random, 0.0172275));
            level.method_8649(entity);
        }
    }

    private static class_2680 cycleRotation(class_2680 state, boolean backwards) {
        return (class_2680)state.method_11657((class_2769)ROTATION, (Comparable)FishPlaqueBlock.getRelative(ROTATION.method_11898(), (Integer)state.method_11654((class_2769)ROTATION), backwards));
    }

    private static <T> T getRelative(Iterable<T> allowedValues, @Nullable T currentValue, boolean backwards) {
        return (T)(backwards ? class_156.method_645(allowedValues, currentValue) : class_156.method_660(allowedValues, currentValue));
    }

    public static enum Type {
        WOODEN(Maps.newEnumMap((Map)ImmutableMap.of((Object)class_2350.field_11043, (Object)class_2248.method_9541((double)0.0, (double)4.0, (double)14.0, (double)16.0, (double)12.0, (double)16.0), (Object)class_2350.field_11035, (Object)class_2248.method_9541((double)0.0, (double)4.0, (double)0.0, (double)16.0, (double)12.0, (double)2.0), (Object)class_2350.field_11034, (Object)class_2248.method_9541((double)0.0, (double)4.0, (double)0.0, (double)2.0, (double)12.0, (double)16.0), (Object)class_2350.field_11039, (Object)class_2248.method_9541((double)14.0, (double)4.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0)))),
        IRON(Maps.newEnumMap((Map)ImmutableMap.of((Object)class_2350.field_11043, (Object)class_2248.method_9541((double)0.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0, (double)16.0), (Object)class_2350.field_11035, (Object)class_2248.method_9541((double)0.0, (double)3.0, (double)0.0, (double)16.0, (double)13.0, (double)3.0), (Object)class_2350.field_11034, (Object)class_2248.method_9541((double)0.0, (double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)16.0), (Object)class_2350.field_11039, (Object)class_2248.method_9541((double)13.0, (double)3.0, (double)0.0, (double)16.0, (double)13.0, (double)16.0)))),
        GOLDEN(Maps.newEnumMap((Map)ImmutableMap.of((Object)class_2350.field_11043, (Object)class_2248.method_9541((double)0.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0, (double)16.0), (Object)class_2350.field_11035, (Object)class_2248.method_9541((double)0.0, (double)3.0, (double)0.0, (double)16.0, (double)13.0, (double)3.0), (Object)class_2350.field_11034, (Object)class_2248.method_9541((double)0.0, (double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)16.0), (Object)class_2350.field_11039, (Object)class_2248.method_9541((double)13.0, (double)3.0, (double)0.0, (double)16.0, (double)13.0, (double)16.0)))),
        GILDED(Maps.newEnumMap((Map)ImmutableMap.of((Object)class_2350.field_11043, (Object)class_259.method_1072((class_265)class_2248.method_9541((double)0.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0, (double)16.0), (class_265)class_2248.method_9541((double)1.0, (double)13.0, (double)14.0, (double)15.0, (double)15.0, (double)16.0), (class_247)class_247.field_1366), (Object)class_2350.field_11035, (Object)class_259.method_1072((class_265)class_2248.method_9541((double)0.0, (double)3.0, (double)0.0, (double)16.0, (double)13.0, (double)3.0), (class_265)class_2248.method_9541((double)1.0, (double)13.0, (double)0.0, (double)15.0, (double)15.0, (double)2.0), (class_247)class_247.field_1366), (Object)class_2350.field_11034, (Object)class_259.method_1072((class_265)class_2248.method_9541((double)0.0, (double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)16.0), (class_265)class_2248.method_9541((double)0.0, (double)13.0, (double)1.0, (double)2.0, (double)15.0, (double)15.0), (class_247)class_247.field_1366), (Object)class_2350.field_11039, (Object)class_259.method_1072((class_265)class_2248.method_9541((double)13.0, (double)3.0, (double)0.0, (double)16.0, (double)13.0, (double)16.0), (class_265)class_2248.method_9541((double)14.0, (double)13.0, (double)1.0, (double)16.0, (double)15.0, (double)15.0), (class_247)class_247.field_1366))));

        private final Map<class_2350, class_265> aabb;

        private Type(Map<class_2350, class_265> aabb) {
            this.aabb = aabb;
        }
    }
}

