/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.common;

import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.fabricmc.fabric.api.object.builder.v1.block.type.BlockSetTypeRegistry;
import net.fabricmc.fabric.api.object.builder.v1.block.type.WoodTypeRegistry;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerType;
import net.minecraft.class_1291;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1311;
import net.minecraft.class_1320;
import net.minecraft.class_1703;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1842;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_1866;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2498;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3545;
import net.minecraft.class_3852;
import net.minecraft.class_3917;
import net.minecraft.class_3955;
import net.minecraft.class_4158;
import net.minecraft.class_4719;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_8110;
import net.minecraft.class_8177;
import org.jetbrains.annotations.Nullable;
import shetiphian.core.internal.ShetiPhianCore;
import shetiphian.core.mixins.SPC_PoiType_Accessor;

public class RegistryHelper {
    private final String modId;

    public RegistryHelper(String modId) {
        this.modId = modId;
    }

    public <T extends class_2248> T addBlock(String id, T block, ItemSupplier<? extends class_1792, T> supplier) {
        this.addBlock(id, block);
        if (supplier != null) {
            this.addItem(id, supplier.getItem(block));
        }
        return block;
    }

    public <T extends class_2248> T addBlock(String id, T block) {
        this.register((class_2378)class_7923.field_41175, id, block);
        return block;
    }

    public <T extends class_1792> T addItem(String id, T item) {
        this.register((class_2378)class_7923.field_41178, id, item);
        return item;
    }

    public <T extends class_2586> class_2591<T> add(String id, class_2591.class_5559<? extends T> supplier, class_2248 ... validBlocks) {
        class_2591 tile = class_2591.class_2592.method_20528(supplier, (class_2248[])validBlocks).method_11034(null);
        this.register(class_7923.field_41181, id, tile);
        return tile;
    }

    public class_1761 addCreativeTab(String id, class_1761 tab) {
        this.register(class_7923.field_44687, id, tab);
        return tab;
    }

    public <T extends class_1320> T addAttribute(String id, T attribute) {
        this.register(class_7923.field_41190, id, attribute);
        return attribute;
    }

    public class_5321<class_8110> addDamageType(String id) {
        return class_5321.method_29179((class_5321)class_7924.field_42534, (class_2960)new class_2960(this.modId, id));
    }

    public <T extends class_1291> T addEffect(String id, T effect) {
        this.register(class_7923.field_41174, id, effect);
        return effect;
    }

    public <T extends class_1297> class_1299<T> add(String id, class_1299.class_4049<T> factory, class_1311 group, float width, float height, boolean summonable) {
        return this.addEntity(id, factory, group, builder -> {
            builder.method_17687(width, height);
            if (!summonable) {
                builder.method_5901();
            }
        });
    }

    public <T extends class_1297> class_1299<T> addEntity(String id, class_1299.class_4049<T> factory, class_1311 group) {
        return this.addEntity(id, factory, group, builder -> {});
    }

    public <T extends class_1297> class_1299<T> addEntity(String id, class_1299.class_4049<T> factory, class_1311 group, Consumer<class_1299.class_1300<T>> properties) {
        class_1299.class_1300 builder = class_1299.class_1300.method_5903(factory, (class_1311)group);
        properties.accept(builder);
        class_1299 entity = builder.method_5905(this.modId + ":" + id);
        this.register((class_2378)class_7923.field_41177, id, (T)entity);
        return entity;
    }

    public class_3545<class_5321<class_4158>, class_4158> addPOI(String id, int ticketCount, int searchDistance, class_2680 ... states) {
        class_4158 pointOfInterestType = new class_4158((Set)ImmutableSet.copyOf((Object[])states), ticketCount, searchDistance);
        class_5321 registryKey = class_5321.method_29179((class_5321)class_7924.field_41212, (class_2960)new class_2960(this.modId, id));
        this.register(class_7923.field_41128, id, pointOfInterestType);
        this.addStatesToPOI((class_5321<class_4158>)registryKey, (Set<class_2680>)ImmutableSet.copyOf((Object[])states), false);
        return new class_3545((Object)registryKey, (Object)pointOfInterestType);
    }

    public void addStatesToPOI(class_5321<class_4158> poiTypeKey, Set<class_2680> states, boolean overwrite) {
        try {
            Map<class_2680, class_6880<class_4158>> poimap = SPC_PoiType_Accessor.getPoiMap();
            class_6880.class_6883 poiTypeEntry = class_7923.field_41128.method_40290(poiTypeKey);
            states.forEach(arg_0 -> this.lambda$addStatesToPOI$2(poimap, (class_6880)poiTypeEntry, overwrite, poiTypeKey, arg_0));
        }
        catch (AssertionError ignored) {
            ShetiPhianCore.LOGGER.error(String.format("RegistryHelper.addStatesToPOI: Could not add blockstates from '%s' into PoI '%s' as the 'SPC_PoiType_Accessor' mixin failed to load", this.modId, poiTypeKey));
        }
    }

    public <T extends class_1842> T addPotion(String id, T potion) {
        this.register((class_2378)class_7923.field_41179, id, potion);
        return potion;
    }

    public class_3852 addProfession(String id, Predicate<class_6880<class_4158>> heldWorkstation, Predicate<class_6880<class_4158>> acquirableWorkstation, ImmutableSet<class_1792> gatherableItems, ImmutableSet<class_2248> secondaryJobSites, @Nullable class_3414 workSound) {
        class_3852 profession = new class_3852(this.modId + ":" + id, heldWorkstation, acquirableWorkstation, gatherableItems, secondaryJobSites, workSound);
        this.register((class_2378)class_7923.field_41195, id, (Object)profession);
        return profession;
    }

    public <T extends class_3955> class_1865<T> add(String id, class_1866.class_7711<T> function) {
        return this.add(id, (class_1865<T>)new class_1866(function));
    }

    public <T extends class_1860<?>> class_1865<T> add(String id, class_1865<T> serializer) {
        this.register(class_7923.field_41189, id, serializer);
        return serializer;
    }

    public <T extends class_1703> class_3917<T> add(String id, ExtendedScreenHandlerType.ExtendedFactory<T> factory) {
        ExtendedScreenHandlerType type = new ExtendedScreenHandlerType(factory);
        this.register(class_7923.field_41187, id, type);
        return type;
    }

    public <T extends class_3414> T addSound(String id) {
        return (T)this.addSound(id, class_3414.method_47908((class_2960)new class_2960(this.modId, id)));
    }

    public <T extends class_3414> T addSound(String id, T sound) {
        this.register(class_7923.field_41172, id, sound);
        return sound;
    }

    public <V, T extends V> T register(class_2378<V> registry, String id, T entry) {
        return (T)class_2378.method_39197(registry, (class_5321)class_5321.method_29179((class_5321)registry.method_30517(), (class_2960)new class_2960(this.modId, id)), entry);
    }

    public class_8177 addSetType(String id, boolean canOpenByHand, class_2498 blockSound, boolean metalInteractSounds) {
        if (metalInteractSounds) {
            return BlockSetTypeRegistry.register((class_2960)new class_2960(this.modId, id), (boolean)canOpenByHand, (class_2498)blockSound, (class_3414)class_3417.field_14819, (class_3414)class_3417.field_14567, (class_3414)class_3417.field_15131, (class_3414)class_3417.field_15082, (class_3414)class_3417.field_15116, (class_3414)class_3417.field_15217, (class_3414)class_3417.field_14954, (class_3414)class_3417.field_14791);
        }
        return BlockSetTypeRegistry.register((class_2960)new class_2960(this.modId, id), (boolean)canOpenByHand, (class_2498)blockSound, (class_3414)class_3417.field_14541, (class_3414)class_3417.field_14664, (class_3414)class_3417.field_15080, (class_3414)class_3417.field_14932, (class_3414)class_3417.field_15002, (class_3414)class_3417.field_14961, (class_3414)class_3417.field_15105, (class_3414)class_3417.field_14699);
    }

    public class_4719 addWoodType(String id, class_8177 type) {
        return WoodTypeRegistry.register((class_2960)new class_2960(this.modId, id), (class_8177)type);
    }

    private /* synthetic */ void lambda$addStatesToPOI$2(Map poimap, class_6880 poiTypeEntry, boolean overwrite, class_5321 poiTypeKey, class_2680 state) {
        if (!poimap.containsKey(state)) {
            poimap.put(state, poiTypeEntry);
        } else if (overwrite) {
            ShetiPhianCore.LOGGER.info(String.format("RegistryHelper.addStatesToPOI: '%s' has changed the PoI of '%s' from '%s' to '%s'", this.modId, state, poimap.get(state), poiTypeEntry));
            poimap.put(state, poiTypeEntry);
        } else {
            ShetiPhianCore.LOGGER.info(String.format("RegistryHelper.addStatesToPOI: Skipping '%s' from '%s' as its already in the PoI '%s'", state, this.modId, poiTypeKey));
        }
    }

    @FunctionalInterface
    public static interface ItemSupplier<I extends class_1792, B extends class_2248> {
        public I getItem(B var1);
    }
}

