/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.client;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.blockrenderlayer.v1.BlockRenderLayerMap;
import net.fabricmc.fabric.api.client.rendering.v1.ColorProviderRegistry;
import net.minecraft.class_1792;
import net.minecraft.class_1921;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_322;
import net.minecraft.class_326;
import net.minecraft.class_3611;
import net.minecraft.class_5272;
import net.minecraft.class_6395;
import org.apache.commons.lang3.tuple.Triple;
import shetiphian.core.client.ColorHandler;
import shetiphian.core.client.ItemModelPredicateProvider;
import shetiphian.core.common.IColored;

@Environment(value=EnvType.CLIENT)
public class RegistryHelperClient {
    private final String modId;
    public static Map<class_2248, class_322> COLOR_PROVIDERS_BLOCK = new HashMap<class_2248, class_322>();
    public static Map<class_1792, class_326> COLOR_PROVIDERS_ITEM = new HashMap<class_1792, class_326>();
    public static List<Triple<class_1792, String, ItemModelPredicateProvider>> ITEM_PREDICATE_PROVIDERS = new ArrayList<Triple<class_1792, String, ItemModelPredicateProvider>>();

    public RegistryHelperClient(String modId) {
        this.modId = modId;
    }

    public <T extends IColored> void colorize(T object) {
        if (object instanceof class_2248) {
            this.colorize((class_2248)object, ColorHandler.BlockColor.INSTANCE);
        }
        if (object instanceof class_1792) {
            this.colorize((class_1792)object, ColorHandler.ItemColor.INSTANCE);
        }
    }

    public void colorize(class_2248 block, class_322 provider) {
        COLOR_PROVIDERS_BLOCK.put(block, provider);
    }

    public void colorize(class_1792 item, class_326 provider) {
        COLOR_PROVIDERS_ITEM.put(item, provider);
    }

    public void add(class_1792 item, String id, ItemModelPredicateProvider provider) {
        ITEM_PREDICATE_PROVIDERS.add((Triple<class_1792, String, ItemModelPredicateProvider>)Triple.of((Object)item, (Object)id, (Object)provider));
    }

    public void add(class_2248 block, class_1921 layer) {
        BlockRenderLayerMap.INSTANCE.putBlock(block, layer);
    }

    public void add(class_3611 fluid, class_1921 layer) {
        BlockRenderLayerMap.INSTANCE.putFluid(fluid, layer);
    }

    public void doRegistration() {
        COLOR_PROVIDERS_BLOCK.forEach((block, provider) -> ColorProviderRegistry.BLOCK.register(provider, (Object[])new class_2248[]{block}));
        COLOR_PROVIDERS_BLOCK.clear();
        COLOR_PROVIDERS_ITEM.forEach((item, provider) -> ColorProviderRegistry.ITEM.register(provider, (Object[])new class_1935[]{item}));
        COLOR_PROVIDERS_ITEM.clear();
        ITEM_PREDICATE_PROVIDERS.forEach(data -> class_5272.method_27879((class_1792)((class_1792)data.getLeft()), (class_2960)new class_2960((String)data.getMiddle()), (class_6395)((class_6395)data.getRight())));
        ITEM_PREDICATE_PROVIDERS.clear();
    }
}

