/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.core.map;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import net.mehvahdjukaar.moonlight.api.map.CustomMapData;
import net.mehvahdjukaar.moonlight.api.map.CustomMapDecoration;
import net.mehvahdjukaar.moonlight.api.map.markers.MapBlockMarker;
import net.mehvahdjukaar.moonlight.api.map.type.CustomDecorationType;
import net.mehvahdjukaar.moonlight.api.map.type.JsonDecorationType;
import net.mehvahdjukaar.moonlight.api.map.type.MapDecorationType;
import net.mehvahdjukaar.moonlight.api.misc.TriFunction;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.mehvahdjukaar.moonlight.core.map.fabric.MapDataInternalImpl;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_22;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class MapDataInternal {
    public static final Codec<MapDecorationType<?, ?>> CODEC = Codec.either(CustomDecorationType.CODEC, JsonDecorationType.CODEC).xmap(either -> (MapDecorationType)either.map(s -> s, c -> c), type -> {
        if (type == null) {
            Moonlight.LOGGER.error("map decoration type cant be null. how did this happen?");
        }
        if (type instanceof CustomDecorationType) {
            CustomDecorationType c = (CustomDecorationType)type;
            return Either.left((Object)c);
        }
        return Either.right((Object)((JsonDecorationType)type));
    });
    public static final Codec<MapDecorationType<?, ?>> NETWORK_CODEC = Codec.either(CustomDecorationType.CODEC, JsonDecorationType.NETWORK_CODEC).xmap(either -> (MapDecorationType)either.map(s -> s, c -> c), type -> {
        if (type == null) {
            Moonlight.LOGGER.error("map decoration type cant be null. how did this happen?");
        }
        if (type instanceof CustomDecorationType) {
            CustomDecorationType c = (CustomDecorationType)type;
            return Either.left((Object)c);
        }
        return Either.right((Object)((JsonDecorationType)type));
    });
    @ApiStatus.Internal
    public static final Map<class_2960, CustomMapData.Type<?>> CUSTOM_MAP_DATA_TYPES = new LinkedHashMap();
    public static final class_5321<class_2378<MapDecorationType<?, ?>>> KEY = class_5321.method_29180((class_2960)Moonlight.res("map_markers"));
    public static final class_2960 GENERIC_STRUCTURE_ID = Moonlight.res("generic_structure");
    private static final BiMap<class_2960, Supplier<CustomDecorationType<?, ?>>> CODE_TYPES_FACTORIES = HashBiMap.create();
    private static final List<TriFunction<class_1657, Integer, class_22, Set<MapBlockMarker<?>>>> DYNAMIC_SERVER = new ArrayList();
    private static final List<BiFunction<Integer, class_22, Set<MapBlockMarker<?>>>> DYNAMIC_CLIENT = new ArrayList();

    public static <T extends CustomMapData<?>> CustomMapData.Type<T> registerCustomMapSavedData(CustomMapData.Type<T> type) {
        if (CUSTOM_MAP_DATA_TYPES.containsKey(type.id())) {
            throw new IllegalArgumentException("Duplicate custom map data registration " + type.id());
        }
        CUSTOM_MAP_DATA_TYPES.put(type.id(), type);
        return type;
    }

    public static MapDecorationType<?, ?> getGenericStructure() {
        return MapDataInternal.get(GENERIC_STRUCTURE_ID);
    }

    public static void registerCustomType(class_2960 id, Supplier<CustomDecorationType<?, ?>> decorationType) {
        CODE_TYPES_FACTORIES.put((Object)id, decorationType);
    }

    public static CustomDecorationType<?, ?> getCustomType(class_2960 resourceLocation) {
        Supplier o = Objects.requireNonNull((Supplier)CODE_TYPES_FACTORIES.get((Object)resourceLocation), "No map decoration type with id: " + resourceLocation);
        CustomDecorationType t = (CustomDecorationType)o.get();
        t.factoryId = resourceLocation;
        return t;
    }

    public static MapDecorationType<?, ?> getAssociatedType(class_6880<class_3195> structure) {
        for (MapDecorationType<?, ?> v : MapDataInternal.getValues()) {
            Optional<class_6885<class_3195>> associatedStructure = v.getAssociatedStructure();
            if (!associatedStructure.isPresent() || !associatedStructure.get().method_40241(structure)) continue;
            return v;
        }
        return MapDataInternal.getGenericStructure();
    }

    @ApiStatus.Internal
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void init() {
        MapDataInternalImpl.init();
    }

    public static class_2378<MapDecorationType<?, ?>> hackyGetRegistry() {
        return Utils.hackyGetRegistryAccess().method_30530(KEY);
    }

    public static class_2378<MapDecorationType<?, ?>> getRegistry(class_5455 registryAccess) {
        return registryAccess.method_30530(KEY);
    }

    public static Collection<MapDecorationType<?, ?>> getValues() {
        return MapDataInternal.hackyGetRegistry().method_10220().toList();
    }

    public static Set<Map.Entry<class_5321<MapDecorationType<?, ?>>, MapDecorationType<?, ?>>> getEntries() {
        return MapDataInternal.hackyGetRegistry().method_29722();
    }

    @Nullable
    public static MapDecorationType<? extends CustomMapDecoration, ?> get(String id) {
        return MapDataInternal.get(new class_2960(id));
    }

    public static MapDecorationType<?, ?> get(class_2960 id) {
        class_2378<MapDecorationType<?, ?>> reg = MapDataInternal.hackyGetRegistry();
        MapDecorationType r = (MapDecorationType)reg.method_10223(id);
        if (r == null) {
            return (MapDecorationType)reg.method_10223(GENERIC_STRUCTURE_ID);
        }
        return r;
    }

    public static Optional<MapDecorationType<?, ?>> getOptional(class_2960 id) {
        return MapDataInternal.hackyGetRegistry().method_17966(id);
    }

    public static Set<MapBlockMarker<?>> getDynamicServer(class_1657 player, int mapId, class_22 data) {
        HashSet dynamic = new HashSet();
        for (TriFunction<class_1657, Integer, class_22, Set<MapBlockMarker<?>>> v : DYNAMIC_SERVER) {
            dynamic.addAll((Collection)v.apply(player, mapId, data));
        }
        return dynamic;
    }

    public static Set<MapBlockMarker<?>> getDynamicClient(int mapId, class_22 data) {
        HashSet dynamic = new HashSet();
        for (BiFunction<Integer, class_22, Set<MapBlockMarker<?>>> v : DYNAMIC_CLIENT) {
            dynamic.addAll((Collection)v.apply(mapId, data));
        }
        return dynamic;
    }

    @Nullable
    public static MapBlockMarker<?> readWorldMarker(class_2487 compound) {
        Iterator iterator = compound.method_10541().iterator();
        if (iterator.hasNext()) {
            String id = (String)iterator.next();
            return MapDataInternal.get(new class_2960(id)).loadMarkerFromNBT(compound.method_10562(id));
        }
        return null;
    }

    public static List<MapBlockMarker<?>> getMarkersFromWorld(class_1922 reader, class_2338 pos) {
        ArrayList list = new ArrayList();
        for (MapDecorationType<?, ?> type : MapDataInternal.getValues()) {
            Object c = type.getWorldMarkerFromWorld(reader, pos);
            if (c == null) continue;
            list.add((MapBlockMarker<?>)c);
        }
        return list;
    }

    public static void addDynamicClientMarkersEvent(BiFunction<Integer, class_22, Set<MapBlockMarker<?>>> event) {
        DYNAMIC_CLIENT.add(event);
    }

    public static void addDynamicServerMarkersEvent(TriFunction<class_1657, Integer, class_22, Set<MapBlockMarker<?>>> event) {
        DYNAMIC_SERVER.add(event);
    }
}

