/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.audioplayer;

import de.maxhenkel.audioplayer.PlayerType;
import de.maxhenkel.audioplayer.configbuilder.entry.ConfigEntry;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.class_124;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2484;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2561;

public class CustomSound {
    public static final String CUSTOM_SOUND = "CustomSound";
    public static final String CUSTOM_SOUND_RANGE = "CustomSoundRange";
    public static final String CUSTOM_SOUND_STATIC = "IsStaticCustomSound";
    public static final String DEFAULT_HEAD_LORE = "Has custom audio";
    protected UUID soundId;
    @Nullable
    protected Float range;
    protected boolean staticSound;

    public CustomSound(UUID soundId, @Nullable Float range, boolean staticSound) {
        this.soundId = soundId;
        this.range = range;
        this.staticSound = staticSound;
    }

    @Nullable
    public static CustomSound of(class_1799 item) {
        class_2487 tag = item.method_7969();
        if (tag == null) {
            return null;
        }
        return CustomSound.of(tag);
    }

    @Nullable
    public static CustomSound of(class_2487 tag) {
        if (!tag.method_10545(CUSTOM_SOUND)) {
            return null;
        }
        UUID soundId = tag.method_25926(CUSTOM_SOUND);
        Float range = null;
        if (tag.method_10545(CUSTOM_SOUND_RANGE)) {
            range = Float.valueOf(tag.method_10583(CUSTOM_SOUND_RANGE));
        }
        boolean staticSound = false;
        if (tag.method_10545(CUSTOM_SOUND_STATIC)) {
            staticSound = tag.method_10577(CUSTOM_SOUND_STATIC);
        }
        return new CustomSound(soundId, range, staticSound);
    }

    public UUID getSoundId() {
        return this.soundId;
    }

    public Optional<Float> getRange() {
        return Optional.ofNullable(this.range);
    }

    public float getRange(PlayerType playerType) {
        return this.getRangeOrDefault(playerType.getDefaultRange(), playerType.getMaxRange());
    }

    public float getRangeOrDefault(ConfigEntry<Float> defaultRange, ConfigEntry<Float> maxRange) {
        if (this.range == null) {
            return defaultRange.get().floatValue();
        }
        if (this.range.floatValue() > maxRange.get().floatValue()) {
            return maxRange.get().floatValue();
        }
        return this.range.floatValue();
    }

    public boolean isStaticSound() {
        return this.staticSound;
    }

    public void saveToNbt(class_2487 tag) {
        if (this.soundId != null) {
            tag.method_25927(CUSTOM_SOUND, this.soundId);
        } else {
            tag.method_10551(CUSTOM_SOUND);
        }
        if (this.range != null) {
            tag.method_10548(CUSTOM_SOUND_RANGE, this.range.floatValue());
        } else {
            tag.method_10551(CUSTOM_SOUND_RANGE);
        }
        if (this.staticSound) {
            tag.method_10556(CUSTOM_SOUND_STATIC, true);
        } else {
            tag.method_10551(CUSTOM_SOUND_STATIC);
        }
    }

    public void saveToItemIgnoreLore(class_1799 stack) {
        this.saveToItem(stack, null, false);
    }

    public void saveToItem(class_1799 stack) {
        this.saveToItem(stack, null);
    }

    public void saveToItem(class_1799 stack, @Nullable String loreString) {
        this.saveToItem(stack, loreString, true);
    }

    private void saveToItem(class_1799 stack, @Nullable String loreString, boolean applyLore) {
        class_1747 blockItem;
        class_2487 tag = stack.method_7948();
        this.saveToNbt(tag);
        class_2499 lore = new class_2499();
        class_1792 class_17922 = stack.method_7909();
        if (class_17922 instanceof class_1747 && (blockItem = (class_1747)class_17922).method_7711() instanceof class_2484) {
            class_2487 blockEntityTag = stack.method_7911("BlockEntityTag");
            this.saveToNbt(blockEntityTag);
            if (loreString == null) {
                lore.method_10531(0, (class_2520)class_2519.method_23256((String)class_2561.class_2562.method_10867((class_2561)class_2561.method_43470((String)DEFAULT_HEAD_LORE).method_27694(style -> style.method_10978(Boolean.valueOf(false))).method_27692(class_124.field_1080))));
            }
        }
        if (loreString != null) {
            lore.method_10531(0, (class_2520)class_2519.method_23256((String)class_2561.class_2562.method_10867((class_2561)class_2561.method_43470((String)loreString).method_27694(style -> style.method_10978(Boolean.valueOf(false))).method_27692(class_124.field_1080))));
        }
        class_2487 display = new class_2487();
        display.method_10566("Lore", (class_2520)lore);
        if (applyLore) {
            tag.method_10566("display", (class_2520)display);
        }
        tag.method_10569("HideFlags", class_1799.class_5422.field_25773.method_30269());
    }

    public CustomSound asStatic(boolean staticSound) {
        return new CustomSound(this.soundId, this.range, staticSound);
    }

    public static boolean clearItem(class_1799 stack) {
        class_2487 tag = stack.method_7969();
        if (tag == null) {
            return false;
        }
        if (!tag.method_10545(CUSTOM_SOUND)) {
            return false;
        }
        tag.method_10551(CUSTOM_SOUND);
        tag.method_10551(CUSTOM_SOUND_RANGE);
        tag.method_10551(CUSTOM_SOUND_STATIC);
        if (stack.method_7909() instanceof class_1747) {
            class_2487 blockEntityTag = stack.method_7911("BlockEntityTag");
            blockEntityTag.method_10551(CUSTOM_SOUND);
            blockEntityTag.method_10551(CUSTOM_SOUND_RANGE);
            blockEntityTag.method_10551(CUSTOM_SOUND_STATIC);
        }
        return true;
    }
}

