/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.blocks;

import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_1831;
import net.minecraft.class_1834;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2431;
import net.minecraft.class_2498;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3481;
import net.minecraft.class_3532;
import net.minecraft.class_3620;
import net.minecraft.class_4970;
import net.minecraft.class_6017;
import net.minecraft.class_6019;
import net.minecraft.class_6862;
import net.minecraft.class_793;
import net.minecraft.class_8567;
import org.betterx.bclib.behaviours.BehaviourBuilders;
import org.betterx.bclib.behaviours.interfaces.BehaviourOre;
import org.betterx.bclib.interfaces.BlockModelProvider;
import org.betterx.bclib.interfaces.TagProvider;
import org.betterx.bclib.util.LootUtil;
import org.betterx.bclib.util.MHelper;
import org.betterx.worlds.together.tag.v3.MineableTags;

public class BaseOreBlock
extends class_2431
implements BlockModelProvider,
TagProvider,
BehaviourOre {
    private final Supplier<class_1792> dropItem;
    private final int minCount;
    private final int maxCount;
    private final int miningLevel;

    public BaseOreBlock(Supplier<class_1792> drop, int minCount, int maxCount, int experience) {
        this(drop, minCount, maxCount, experience, 0);
    }

    public BaseOreBlock(Supplier<class_1792> drop, int minCount, int maxCount, int experience, int miningLevel) {
        this(BehaviourBuilders.createStone(class_3620.field_15986).method_29292().method_36557(3.0f).method_36558(9.0f).method_9626(class_2498.field_11544), drop, minCount, maxCount, experience, miningLevel);
    }

    public BaseOreBlock(class_4970.class_2251 properties, Supplier<class_1792> drop, int minCount, int maxCount, int experience) {
        this(properties, drop, minCount, maxCount, experience, 0);
    }

    public BaseOreBlock(class_4970.class_2251 properties, Supplier<class_1792> drop, int minCount, int maxCount, int experience, int miningLevel) {
        super(properties, (class_6017)class_6019.method_35017((int)(experience > 0 ? 1 : 0), (int)experience));
        this.dropItem = drop;
        this.minCount = minCount;
        this.maxCount = maxCount;
        this.miningLevel = miningLevel;
    }

    public List<class_1799> method_9560(class_2680 state, class_8567.class_8568 builder) {
        return LootUtil.getDrops((class_4970)this, state, builder).orElseGet(() -> BaseOreBlock.getDroppedItems((class_1935)this, this.dropItem.get(), this.maxCount, this.minCount, this.miningLevel, state, builder));
    }

    public static List<class_1799> getDroppedItems(class_1935 block, class_1792 dropItem, int maxCount, int minCount, int miningLevel, class_2680 state, class_8567.class_8568 builder) {
        class_1799 tool = (class_1799)builder.method_51873(class_181.field_1229);
        if (tool != null && tool.method_7951(state) && dropItem != null) {
            boolean canMine = miningLevel == 0;
            class_1792 class_17922 = tool.method_7909();
            if (class_17922 instanceof class_1831) {
                class_1831 tired = (class_1831)class_17922;
                boolean bl = canMine = tired.method_8022().method_8024() >= miningLevel;
            }
            if (canMine) {
                int count;
                if (class_1890.method_8225((class_1887)class_1893.field_9099, (class_1799)tool) > 0) {
                    return Collections.singletonList(new class_1799(block));
                }
                int enchantment = class_1890.method_8225((class_1887)class_1893.field_9130, (class_1799)tool);
                if (enchantment > 0) {
                    int max;
                    int min = class_3532.method_15340((int)(minCount + enchantment), (int)minCount, (int)maxCount);
                    if (min == (max = maxCount + enchantment / class_1893.field_9130.method_8183())) {
                        return Collections.singletonList(new class_1799((class_1935)dropItem, max));
                    }
                    count = MHelper.randRange(min, max, MHelper.RANDOM_SOURCE);
                } else {
                    count = MHelper.randRange(minCount, maxCount, MHelper.RANDOM_SOURCE);
                }
                return Collections.singletonList(new class_1799((class_1935)dropItem, count));
            }
        }
        return Collections.emptyList();
    }

    @Override
    public class_793 getItemModel(class_2960 resourceLocation) {
        return this.getBlockModel(resourceLocation, this.method_9564());
    }

    @Override
    public void addTags(List<class_6862<class_2248>> blockTags, List<class_6862<class_1792>> itemTags) {
        if (this.miningLevel == class_1834.field_8927.method_8024()) {
            blockTags.add((class_6862<class_2248>)class_3481.field_33719);
        } else if (this.miningLevel == class_1834.field_8923.method_8024()) {
            blockTags.add((class_6862<class_2248>)class_3481.field_33718);
        } else if (this.miningLevel == class_1834.field_8930.method_8024()) {
            blockTags.add((class_6862<class_2248>)class_3481.field_33717);
        } else if (this.miningLevel == class_1834.field_22033.method_8024()) {
            blockTags.add(MineableTags.NEEDS_NETHERITE_TOOL);
        }
    }
}

