/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.api.v3.levelgen.features;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Consumer;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_2975;
import net.minecraft.class_3031;
import net.minecraft.class_3037;
import net.minecraft.class_3111;
import net.minecraft.class_3122;
import net.minecraft.class_3124;
import net.minecraft.class_3141;
import net.minecraft.class_3150;
import net.minecraft.class_3173;
import net.minecraft.class_3175;
import net.minecraft.class_3226;
import net.minecraft.class_3819;
import net.minecraft.class_3825;
import net.minecraft.class_4628;
import net.minecraft.class_4638;
import net.minecraft.class_4651;
import net.minecraft.class_4656;
import net.minecraft.class_4657;
import net.minecraft.class_4782;
import net.minecraft.class_5321;
import net.minecraft.class_6005;
import net.minecraft.class_6016;
import net.minecraft.class_6017;
import net.minecraft.class_6646;
import net.minecraft.class_6654;
import net.minecraft.class_6655;
import net.minecraft.class_6789;
import net.minecraft.class_6796;
import net.minecraft.class_6880;
import net.minecraft.class_7891;
import net.minecraft.class_7924;
import org.betterx.bclib.BCLib;
import org.betterx.bclib.api.v2.levelgen.structures.StructurePlacementType;
import org.betterx.bclib.api.v2.levelgen.structures.StructureWorldNBT;
import org.betterx.bclib.api.v2.poi.BCLPoiType;
import org.betterx.bclib.api.v3.levelgen.features.BCLConfigureFeature;
import org.betterx.bclib.api.v3.levelgen.features.BCLFeature;
import org.betterx.bclib.api.v3.levelgen.features.BCLInlinePlacedBuilder;
import org.betterx.bclib.api.v3.levelgen.features.config.PillarFeatureConfig;
import org.betterx.bclib.api.v3.levelgen.features.config.PlaceFacingBlockConfig;
import org.betterx.bclib.api.v3.levelgen.features.config.SequenceFeatureConfig;
import org.betterx.bclib.api.v3.levelgen.features.config.TemplateFeatureConfig;
import org.betterx.bclib.api.v3.levelgen.features.features.PillarFeature;
import org.betterx.bclib.api.v3.levelgen.features.features.PlaceBlockFeature;
import org.betterx.bclib.api.v3.levelgen.features.features.SequenceFeature;
import org.betterx.bclib.api.v3.levelgen.features.features.TemplateFeature;
import org.betterx.bclib.blocks.BlockProperties;
import org.betterx.bclib.util.FullReferenceHolder;
import org.betterx.bclib.util.Triple;
import org.jetbrains.annotations.NotNull;

public abstract class BCLFeatureBuilder<F extends class_3031<FC>, FC extends class_3037> {
    static ConcurrentLinkedQueue<BCLConfigureFeature.Unregistered<?, ?>> UNBOUND_FEATURES = new ConcurrentLinkedQueue();
    protected final class_2960 featureID;
    private final F feature;

    public static <F extends class_3031<FC>, FC extends class_3037> WithConfiguration<F, FC> start(class_2960 featureID, F feature) {
        return new WithConfiguration(featureID, feature);
    }

    public static ForSimpleBlock start(class_2960 featureID, class_2248 block) {
        return BCLFeatureBuilder.start(featureID, (class_4651)class_4651.method_38432((class_2248)block));
    }

    public static ForSimpleBlock start(class_2960 featureID, class_2680 state) {
        return BCLFeatureBuilder.start(featureID, (class_4651)class_4651.method_38433((class_2680)state));
    }

    public static ForSimpleBlock start(class_2960 featureID, class_4651 provider) {
        return new ForSimpleBlock(featureID, (class_3173)class_3031.field_13518, provider);
    }

    public static WeightedBlock startWeighted(class_2960 featureID) {
        return new WeightedBlock(featureID, (class_3173)class_3031.field_13518);
    }

    public static WeightedBlockPatch startWeightedRandomPatch(class_2960 featureID) {
        return new WeightedBlockPatch(featureID, (class_4628)class_3031.field_21220);
    }

    public static WeightedBlockPatch startBonemealPatch(class_2960 featureID) {
        return BCLFeatureBuilder.startWeightedRandomPatch(featureID).likeDefaultBonemeal();
    }

    public static RandomPatch startRandomPatch(class_2960 featureID, class_6880<class_6796> featureToPlace) {
        return new RandomPatch(featureID, (class_4628)class_3031.field_21220, featureToPlace);
    }

    public static AsRandomSelect startRandomSelect(class_2960 featureID) {
        return new AsRandomSelect(featureID, (class_3150)class_3031.field_13593);
    }

    public static AsMultiPlaceRandomSelect startRandomSelect(class_2960 featureID, AsMultiPlaceRandomSelect.Placer placementModFunction) {
        return new AsMultiPlaceRandomSelect(featureID, (class_3150)class_3031.field_13593, placementModFunction);
    }

    public static NetherForrestVegetation startNetherVegetation(class_2960 featureID) {
        return new NetherForrestVegetation(featureID, (class_4782)class_3031.field_22186);
    }

    public static NetherForrestVegetation startBonemealNetherVegetation(class_2960 featureID) {
        return new NetherForrestVegetation(featureID, (class_4782)class_3031.field_22186).spreadHeight(1).spreadWidth(3);
    }

    public static WithTemplates startWithTemplates(class_2960 featureID) {
        return new WithTemplates(featureID, (TemplateFeature)BCLFeature.TEMPLATE);
    }

    public static AsBlockColumn<class_6654> startColumn(class_2960 featureID) {
        return new AsBlockColumn<class_6654>(featureID, (class_6654)class_3031.field_35072);
    }

    public static AsPillar startPillar(class_2960 featureID, PillarFeatureConfig.KnownTransformers transformer) {
        return new AsPillar(featureID, (PillarFeature)BCLFeature.PILLAR, transformer);
    }

    public static AsSequence startSequence(class_2960 featureID) {
        return new AsSequence(featureID, (SequenceFeature)BCLFeature.SEQUENCE);
    }

    public static AsOre startOre(class_2960 featureID) {
        return new AsOre(featureID, (class_3122)class_3031.field_13517);
    }

    public static FacingBlock startFacing(class_2960 featureID) {
        return new FacingBlock(featureID, (PlaceBlockFeature)BCLFeature.PLACE_BLOCK);
    }

    private BCLFeatureBuilder(class_2960 featureID, F feature) {
        this.featureID = featureID;
        this.feature = feature;
    }

    public static <F extends class_3031<FC>, FC extends class_3037> class_6880<class_2975<FC, F>> register(class_7891<class_2975<?, ?>> ctx, class_2960 id, class_2975<FC, F> cFeature) {
        class_5321 key = class_5321.method_29179((class_5321)class_7924.field_41239, (class_2960)id);
        return (class_6880)ctx.method_46838(key, cFeature);
    }

    public abstract FC createConfiguration();

    protected BCLConfigureFeature<F, FC> buildAndCreateHolder(HolderBuilder<F, FC> holderBuilder) {
        return this.buildAndCreateHolder((featureID, holder) -> new BCLConfigureFeature(featureID, holder, true), holderBuilder);
    }

    protected <B extends BCLConfigureFeature<F, FC>> B buildAndCreateHolder(FeatureBuilder<F, FC, B> featureBuilder, HolderBuilder<F, FC> holderBuilder) {
        FC config = this.createConfiguration();
        if (config == null) {
            throw new IllegalStateException("Feature configuration for " + this.featureID + " can not be null!");
        }
        class_2975 cFeature = new class_2975(this.feature, config);
        class_6880<class_2975<FC, F>> holder = holderBuilder.apply(this.featureID, cFeature);
        return featureBuilder.create(this.featureID, holder);
    }

    public BCLConfigureFeature<F, FC> buildAndRegister(class_7891<class_2975<?, ?>> bootstrapCtx) {
        return this.buildAndCreateHolder((featureID, cFeature) -> BCLFeatureBuilder.register(bootstrapCtx, featureID, cFeature));
    }

    public BCLConfigureFeature<F, FC> buildInline() {
        return this.buildAndCreateHolder((featureID, cFeature) -> class_6880.method_40223((Object)cFeature));
    }

    public BCLConfigureFeature.Unregistered<F, FC> build() {
        BCLConfigureFeature.Unregistered res = this.buildAndCreateHolder((featureID, holder) -> new BCLConfigureFeature.Unregistered(featureID, holder), (featureID, cFeature) -> FullReferenceHolder.create(class_7924.field_41239, featureID, cFeature));
        UNBOUND_FEATURES.add(res);
        return res;
    }

    public static void registerUnbound(class_7891<class_2975<?, ?>> bootstapContext) {
        UNBOUND_FEATURES.forEach((Consumer<BCLConfigureFeature.Unregistered<?, ?>>)((Consumer<BCLConfigureFeature.Unregistered>)u -> u.register(bootstapContext)));
        UNBOUND_FEATURES.clear();
    }

    public BCLInlinePlacedBuilder<F, FC> inlinePlace() {
        BCLConfigureFeature<F, FC> f = this.buildInline();
        return BCLInlinePlacedBuilder.place(f);
    }

    public class_6880<class_6796> inlinePlace(BCLInlinePlacedBuilder<F, FC> placer) {
        BCLConfigureFeature<F, FC> f = this.buildInline();
        return placer.build(f).getPlacedFeature();
    }

    public static class WithConfiguration<F extends class_3031<FC>, FC extends class_3037>
    extends BCLFeatureBuilder<F, FC> {
        private FC configuration;

        private WithConfiguration(@NotNull class_2960 featureID, @NotNull F feature) {
            super(featureID, feature);
        }

        public WithConfiguration<F, FC> configuration(FC config) {
            this.configuration = config;
            return this;
        }

        @Override
        public FC createConfiguration() {
            if (this.configuration == null) {
                if (class_3111.field_13603 != null) {
                    return (FC)class_3111.field_13603;
                }
                return (FC)class_3111.field_24894;
            }
            return this.configuration;
        }
    }

    public static class ForSimpleBlock
    extends BCLFeatureBuilder<class_3173, class_3175> {
        private final class_4651 provider;

        private ForSimpleBlock(@NotNull class_2960 featureID, @NotNull class_3173 feature, @NotNull class_4651 provider) {
            super(featureID, feature);
            this.provider = provider;
        }

        @Override
        public class_3175 createConfiguration() {
            return new class_3175(this.provider);
        }
    }

    public static class WeightedBlock
    extends WeightedBaseBlock<class_3173, class_3175, WeightedBlock> {
        private WeightedBlock(@NotNull class_2960 featureID, @NotNull class_3173 feature) {
            super(featureID, feature);
        }

        @Override
        public class_3175 createConfiguration() {
            return new class_3175((class_4651)new class_4657(this.stateBuilder.method_34974()));
        }
    }

    public static class WeightedBlockPatch
    extends WeightedBaseBlock<class_4628, class_4638, WeightedBlockPatch> {
        private class_6646 groundType = null;
        private boolean isEmpty = true;
        private int tries = 96;
        private int xzSpread = 7;
        private int ySpread = 3;

        protected WeightedBlockPatch(@NotNull class_2960 featureID, @NotNull class_4628 feature) {
            super(featureID, feature);
        }

        public WeightedBlockPatch isEmpty() {
            return this.isEmpty(true);
        }

        public WeightedBlockPatch isEmpty(boolean value) {
            this.isEmpty = value;
            return this;
        }

        public WeightedBlockPatch isOn(class_6646 predicate) {
            this.groundType = predicate;
            return this;
        }

        public WeightedBlockPatch isEmptyAndOn(class_6646 predicate) {
            return this.isEmpty().isOn(predicate);
        }

        public WeightedBlockPatch likeDefaultNetherVegetation() {
            return this.likeDefaultNetherVegetation(8, 4);
        }

        public WeightedBlockPatch likeDefaultNetherVegetation(int xzSpread, int ySpread) {
            this.xzSpread = xzSpread;
            this.ySpread = ySpread;
            this.tries = xzSpread * xzSpread;
            return this;
        }

        public WeightedBlockPatch likeDefaultBonemeal() {
            return this.tries(9).spreadXZ(3).spreadY(1);
        }

        public WeightedBlockPatch tries(int v) {
            this.tries = v;
            return this;
        }

        public WeightedBlockPatch spreadXZ(int v) {
            this.xzSpread = v;
            return this;
        }

        public WeightedBlockPatch spreadY(int v) {
            this.ySpread = v;
            return this;
        }

        @Override
        public class_4638 createConfiguration() {
            BCLInlinePlacedBuilder blockFeature = BCLFeatureBuilder.start(new class_2960(this.featureID.method_12836(), "tmp_" + this.featureID.method_12832()), class_3031.field_13518).configuration(new class_3175((class_4651)new class_4657(this.stateBuilder.method_34974()))).inlinePlace();
            if (this.isEmpty) {
                blockFeature.isEmpty();
            }
            if (this.groundType != null) {
                blockFeature.isOn(this.groundType);
            }
            return new class_4638(this.tries, this.xzSpread, this.ySpread, blockFeature.build().getPlacedFeature());
        }
    }

    public static class RandomPatch
    extends BCLFeatureBuilder<class_4628, class_4638> {
        private final class_6880<class_6796> featureToPlace;
        private int tries = 96;
        private int xzSpread = 7;
        private int ySpread = 3;

        private RandomPatch(@NotNull class_2960 featureID, @NotNull class_4628 feature, @NotNull class_6880<class_6796> featureToPlace) {
            super(featureID, feature);
            this.featureToPlace = featureToPlace;
        }

        public RandomPatch likeDefaultNetherVegetation() {
            return this.likeDefaultNetherVegetation(8, 4);
        }

        public RandomPatch likeDefaultNetherVegetation(int xzSpread, int ySpread) {
            this.xzSpread = xzSpread;
            this.ySpread = ySpread;
            this.tries = xzSpread * xzSpread;
            return this;
        }

        public RandomPatch tries(int v) {
            this.tries = v;
            return this;
        }

        public RandomPatch spreadXZ(int v) {
            this.xzSpread = v;
            return this;
        }

        public RandomPatch spreadY(int v) {
            this.ySpread = v;
            return this;
        }

        @Override
        public class_4638 createConfiguration() {
            return new class_4638(this.tries, this.xzSpread, this.ySpread, this.featureToPlace);
        }
    }

    public static class AsRandomSelect
    extends BCLFeatureBuilder<class_3150, class_3141> {
        private final List<class_3226> features = new LinkedList<class_3226>();
        private class_6880<class_6796> defaultFeature;

        private AsRandomSelect(@NotNull class_2960 featureID, @NotNull class_3150 feature) {
            super(featureID, feature);
        }

        public AsRandomSelect add(class_6880<class_6796> feature, float weight) {
            this.features.add(new class_3226(feature, weight));
            return this;
        }

        public AsRandomSelect defaultFeature(class_6880<class_6796> feature) {
            this.defaultFeature = feature;
            return this;
        }

        @Override
        public class_3141 createConfiguration() {
            return new class_3141(this.features, this.defaultFeature);
        }
    }

    public static class AsMultiPlaceRandomSelect
    extends BCLFeatureBuilder<class_3150, class_3141> {
        private final List<Triple<class_4651, Float, Integer>> features = new LinkedList<Triple<class_4651, Float, Integer>>();
        private final Placer modFunction;
        private static int featureCounter = 0;
        private static int lastID = 0;

        private AsMultiPlaceRandomSelect(@NotNull class_2960 featureID, @NotNull class_3150 feature, @NotNull Placer mod) {
            super(featureID, feature);
            this.modFunction = mod;
        }

        public AsMultiPlaceRandomSelect addAllStates(class_2248 block, int weight) {
            return this.addAllStates(block, weight, lastID + 1);
        }

        public AsMultiPlaceRandomSelect addAll(int weight, class_2248 ... blocks) {
            return this.addAll(weight, lastID + 1, blocks);
        }

        public AsMultiPlaceRandomSelect addAllStatesFor(class_2758 prop, class_2248 block, int weight) {
            return this.addAllStatesFor(prop, block, weight, lastID + 1);
        }

        public AsMultiPlaceRandomSelect add(class_2248 block, float weight) {
            return this.add((class_4651)class_4651.method_38432((class_2248)block), weight);
        }

        public AsMultiPlaceRandomSelect add(class_2680 state, float weight) {
            return this.add((class_4651)class_4651.method_38433((class_2680)state), weight);
        }

        public AsMultiPlaceRandomSelect add(class_4651 provider, float weight) {
            return this.add(provider, weight, lastID + 1);
        }

        public AsMultiPlaceRandomSelect addAllStates(class_2248 block, int weight, int id) {
            Set<class_2680> states = BCLPoiType.getBlockStates(block);
            class_6005.class_6006 builder = class_6005.method_34971();
            states.forEach(s -> builder.method_34975((Object)block.method_9564(), 1));
            this.add((class_4651)new class_4657(builder.method_34974()), (float)weight, id);
            return this;
        }

        public AsMultiPlaceRandomSelect addAll(int weight, int id, class_2248 ... blocks) {
            class_6005.class_6006 builder = class_6005.method_34971();
            for (class_2248 block : blocks) {
                builder.method_34975((Object)block.method_9564(), 1);
            }
            this.add((class_4651)new class_4657(builder.method_34974()), (float)weight, id);
            return this;
        }

        public AsMultiPlaceRandomSelect addAllStatesFor(class_2758 prop, class_2248 block, int weight, int id) {
            Collection values = prop.method_11898();
            class_6005.class_6006 builder = class_6005.method_34971();
            values.forEach(s -> builder.method_34975((Object)((class_2680)block.method_9564().method_11657((class_2769)prop, (Comparable)s)), 1));
            this.add((class_4651)new class_4657(builder.method_34974()), (float)weight, id);
            return this;
        }

        public AsMultiPlaceRandomSelect add(class_2248 block, float weight, int id) {
            return this.add((class_4651)class_4651.method_38432((class_2248)block), weight, id);
        }

        public AsMultiPlaceRandomSelect add(class_2680 state, float weight, int id) {
            return this.add((class_4651)class_4651.method_38433((class_2680)state), weight, id);
        }

        public AsMultiPlaceRandomSelect add(class_4651 provider, float weight, int id) {
            this.features.add(new Triple<class_4651, Float, Integer>(provider, Float.valueOf(weight), id));
            lastID = Math.max(lastID, id);
            return this;
        }

        private class_6880<class_6796> place(class_4651 p, int id) {
            BCLInlinePlacedBuilder<class_3173, class_3175> builder = BCLFeatureBuilder.start(BCLib.makeID("temp_select_feature" + featureCounter++), p).inlinePlace();
            return this.modFunction.place(builder, id);
        }

        @Override
        public class_3141 createConfiguration() {
            if (this.modFunction == null) {
                throw new IllegalStateException("AsMultiPlaceRandomSelect needs a placement.modification Function");
            }
            float sum = this.features.stream().map(p -> (Float)p.second).reduce(Float.valueOf(0.0f), Float::sum).floatValue();
            List<class_3226> features = this.features.stream().map(p -> new class_3226(this.place((class_4651)p.first, (Integer)p.third), ((Float)p.second).floatValue() / sum)).toList();
            return new class_3141(features.subList(0, features.size() - 1), features.get((int)(features.size() - 1)).field_14013);
        }

        public static interface Placer {
            public class_6880<class_6796> place(BCLInlinePlacedBuilder<class_3173, class_3175> var1, int var2);
        }
    }

    public static class NetherForrestVegetation
    extends BCLFeatureBuilder<class_4782, class_6789> {
        private class_6005.class_6006<class_2680> blocks;
        private class_4657 stateProvider;
        private int spreadWidth = 8;
        private int spreadHeight = 4;

        private NetherForrestVegetation(@NotNull class_2960 featureID, @NotNull class_4782 feature) {
            super(featureID, feature);
        }

        public NetherForrestVegetation spreadWidth(int v) {
            this.spreadWidth = v;
            return this;
        }

        public NetherForrestVegetation spreadHeight(int v) {
            this.spreadHeight = v;
            return this;
        }

        public NetherForrestVegetation addAllStates(class_2248 block, int weight) {
            Set<class_2680> states = BCLPoiType.getBlockStates(block);
            states.forEach(s -> this.add(block.method_9564(), Math.max(1, weight / states.size())));
            return this;
        }

        public NetherForrestVegetation addAllStatesFor(class_2758 prop, class_2248 block, int weight) {
            Collection values = prop.method_11898();
            values.forEach(s -> this.add((class_2680)block.method_9564().method_11657((class_2769)prop, (Comparable)s), Math.max(1, weight / values.size())));
            return this;
        }

        public NetherForrestVegetation add(class_2248 block, int weight) {
            return this.add(block.method_9564(), weight);
        }

        public NetherForrestVegetation add(class_2680 state, int weight) {
            if (this.stateProvider != null) {
                throw new IllegalStateException("You can not add new state once a WeightedStateProvider was built. (" + state + ", " + weight + ")");
            }
            if (this.blocks == null) {
                this.blocks = class_6005.method_34971();
            }
            this.blocks.method_34975((Object)state, weight);
            return this;
        }

        public NetherForrestVegetation provider(class_4657 provider) {
            if (this.blocks != null) {
                throw new IllegalStateException("You can not set a WeightedStateProvider after states were added manually.");
            }
            this.stateProvider = provider;
            return this;
        }

        @Override
        public class_6789 createConfiguration() {
            if (this.stateProvider == null && this.blocks == null) {
                throw new IllegalStateException("NetherForestVegetationConfig needs at least one BlockState");
            }
            if (this.stateProvider == null) {
                this.stateProvider = new class_4657(this.blocks.method_34974());
            }
            return new class_6789((class_4651)this.stateProvider, this.spreadWidth, this.spreadHeight);
        }
    }

    public static class WithTemplates
    extends BCLFeatureBuilder<TemplateFeature<TemplateFeatureConfig>, TemplateFeatureConfig> {
        private final List<StructureWorldNBT> templates = new LinkedList<StructureWorldNBT>();

        private WithTemplates(@NotNull class_2960 featureID, @NotNull TemplateFeature<TemplateFeatureConfig> feature) {
            super(featureID, feature);
        }

        public WithTemplates add(class_2960 location, int offsetY, StructurePlacementType type, float chance) {
            this.templates.add(TemplateFeatureConfig.cfg(location, offsetY, type, chance));
            return this;
        }

        @Override
        public TemplateFeatureConfig createConfiguration() {
            return new TemplateFeatureConfig(this.templates);
        }
    }

    public static class AsBlockColumn<FF extends class_3031<class_6655>>
    extends BCLFeatureBuilder<FF, class_6655> {
        private final List<class_6655.class_6656> layers = new LinkedList<class_6655.class_6656>();
        private class_2350 direction = class_2350.field_11036;
        private class_6646 allowedPlacement = class_6646.field_35696;
        private boolean prioritizeTip = false;

        private AsBlockColumn(@NotNull class_2960 featureID, @NotNull FF feature) {
            super(featureID, feature);
        }

        public AsBlockColumn<FF> add(int height, class_2248 block) {
            return this.add((class_6017)class_6016.method_34998((int)height), (class_4651)class_4651.method_38432((class_2248)block));
        }

        public AsBlockColumn<FF> add(int height, class_2680 state) {
            return this.add((class_6017)class_6016.method_34998((int)height), (class_4651)class_4651.method_38433((class_2680)state));
        }

        public AsBlockColumn<FF> add(int height, class_4651 state) {
            return this.add((class_6017)class_6016.method_34998((int)height), state);
        }

        protected static class_6005<class_2680> buildWeightedList(class_2680 state) {
            return class_6005.method_34971().method_34975((Object)state, 1).method_34974();
        }

        public final AsBlockColumn<FF> addRandom(int height, class_2680 ... states) {
            return this.addRandom((class_6017)class_6016.method_34998((int)height), states);
        }

        public final AsBlockColumn<FF> addRandom(class_6017 height, class_2680 ... states) {
            class_6005.class_6006 builder = class_6005.method_34971();
            for (class_2680 state : states) {
                builder.method_34975((Object)state, 1);
            }
            return this.add(height, (class_4651)new class_4657(builder.method_34974()));
        }

        public AsBlockColumn<FF> add(class_6017 height, class_2248 block) {
            return this.add(height, (class_4651)class_4651.method_38432((class_2248)block));
        }

        public AsBlockColumn<FF> add(class_6017 height, class_2680 state) {
            return this.add(height, (class_4651)class_4651.method_38433((class_2680)state));
        }

        public AsBlockColumn<FF> add(class_6017 height, class_4651 state) {
            this.layers.add(new class_6655.class_6656(height, state));
            return this;
        }

        public AsBlockColumn<FF> addTripleShape(class_2680 state, class_6017 midHeight) {
            return this.add(1, (class_2680)state.method_11657(BlockProperties.TRIPLE_SHAPE, (Comparable)((Object)BlockProperties.TripleShape.BOTTOM))).add(midHeight, (class_2680)state.method_11657(BlockProperties.TRIPLE_SHAPE, (Comparable)((Object)BlockProperties.TripleShape.MIDDLE))).add(1, (class_2680)state.method_11657(BlockProperties.TRIPLE_SHAPE, (Comparable)((Object)BlockProperties.TripleShape.TOP)));
        }

        public AsBlockColumn<FF> addTripleShapeUpsideDown(class_2680 state, class_6017 midHeight) {
            return this.add(1, (class_2680)state.method_11657(BlockProperties.TRIPLE_SHAPE, (Comparable)((Object)BlockProperties.TripleShape.TOP))).add(midHeight, (class_2680)state.method_11657(BlockProperties.TRIPLE_SHAPE, (Comparable)((Object)BlockProperties.TripleShape.MIDDLE))).add(1, (class_2680)state.method_11657(BlockProperties.TRIPLE_SHAPE, (Comparable)((Object)BlockProperties.TripleShape.BOTTOM)));
        }

        public AsBlockColumn<FF> addBottomShapeUpsideDown(class_2680 state, class_6017 midHeight) {
            return this.add(midHeight, (class_2680)state.method_11657((class_2769)BlockProperties.BOTTOM, (Comparable)Boolean.valueOf(false))).add(1, (class_2680)state.method_11657((class_2769)BlockProperties.BOTTOM, (Comparable)Boolean.valueOf(true)));
        }

        public AsBlockColumn<FF> addBottomShape(class_2680 state, class_6017 midHeight) {
            return this.add(1, (class_2680)state.method_11657((class_2769)BlockProperties.BOTTOM, (Comparable)Boolean.valueOf(true))).add(midHeight, (class_2680)state.method_11657((class_2769)BlockProperties.BOTTOM, (Comparable)Boolean.valueOf(false)));
        }

        public AsBlockColumn<FF> addTopShapeUpsideDown(class_2680 state, class_6017 midHeight) {
            return this.add(1, (class_2680)state.method_11657((class_2769)BlockProperties.TOP, (Comparable)Boolean.valueOf(true))).add(midHeight, (class_2680)state.method_11657((class_2769)BlockProperties.TOP, (Comparable)Boolean.valueOf(false)));
        }

        public AsBlockColumn<FF> addTopShape(class_2680 state, class_6017 midHeight) {
            return this.add(midHeight, (class_2680)state.method_11657((class_2769)BlockProperties.TOP, (Comparable)Boolean.valueOf(false))).add(1, (class_2680)state.method_11657((class_2769)BlockProperties.TOP, (Comparable)Boolean.valueOf(true)));
        }

        public AsBlockColumn<FF> direction(class_2350 dir) {
            this.direction = dir;
            return this;
        }

        public AsBlockColumn<FF> prioritizeTip() {
            return this.prioritizeTip(true);
        }

        public AsBlockColumn<FF> prioritizeTip(boolean v) {
            this.prioritizeTip = v;
            return this;
        }

        public AsBlockColumn<FF> allowedPlacement(class_6646 v) {
            this.allowedPlacement = v;
            return this;
        }

        @Override
        public class_6655 createConfiguration() {
            return new class_6655(this.layers, this.direction, this.allowedPlacement, this.prioritizeTip);
        }
    }

    public static class AsPillar
    extends BCLFeatureBuilder<PillarFeature, PillarFeatureConfig> {
        private class_6017 maxHeight;
        private class_6017 minHeight;
        private class_4651 stateProvider;
        private final PillarFeatureConfig.KnownTransformers transformer;
        private class_2350 direction = class_2350.field_11036;
        private class_6646 allowedPlacement = class_6646.field_35696;

        private AsPillar(@NotNull class_2960 featureID, @NotNull PillarFeature feature, @NotNull PillarFeatureConfig.KnownTransformers transformer) {
            super(featureID, feature);
            this.transformer = transformer;
        }

        public AsPillar allowedPlacement(class_6646 predicate) {
            this.allowedPlacement = predicate;
            return this;
        }

        public AsPillar direction(class_2350 v) {
            this.direction = v;
            return this;
        }

        public AsPillar blockState(class_2248 v) {
            return this.blockState((class_4651)class_4651.method_38433((class_2680)v.method_9564()));
        }

        public AsPillar blockState(class_2680 v) {
            return this.blockState((class_4651)class_4651.method_38433((class_2680)v));
        }

        public AsPillar blockState(class_4651 v) {
            this.stateProvider = v;
            return this;
        }

        public AsPillar maxHeight(int v) {
            this.maxHeight = class_6016.method_34998((int)v);
            return this;
        }

        public AsPillar maxHeight(class_6017 v) {
            this.maxHeight = v;
            return this;
        }

        public AsPillar minHeight(int v) {
            this.minHeight = class_6016.method_34998((int)v);
            return this;
        }

        public AsPillar minHeight(class_6017 v) {
            this.minHeight = v;
            return this;
        }

        @Override
        public PillarFeatureConfig createConfiguration() {
            if (this.stateProvider == null) {
                throw new IllegalStateException("A Pillar Features need a stateProvider");
            }
            if (this.maxHeight == null) {
                throw new IllegalStateException("A Pillar Features need a height");
            }
            if (this.minHeight == null) {
                this.minHeight = class_6016.method_34998((int)0);
            }
            return new PillarFeatureConfig(this.minHeight, this.maxHeight, this.direction, this.allowedPlacement, this.stateProvider, this.transformer);
        }
    }

    public static class AsSequence
    extends BCLFeatureBuilder<SequenceFeature, SequenceFeatureConfig> {
        private final List<class_6880<class_6796>> features = new LinkedList<class_6880<class_6796>>();

        private AsSequence(@NotNull class_2960 featureID, @NotNull SequenceFeature feature) {
            super(featureID, feature);
        }

        public AsSequence add(BCLFeature<?, ?> p) {
            return this.add(p.placedFeature);
        }

        public AsSequence add(class_6880<class_6796> p) {
            this.features.add(p);
            return this;
        }

        @Override
        public SequenceFeatureConfig createConfiguration() {
            return new SequenceFeatureConfig(this.features);
        }
    }

    public static class AsOre
    extends BCLFeatureBuilder<class_3122, class_3124> {
        private final List<class_3124.class_5876> targetStates = new LinkedList<class_3124.class_5876>();
        private int size = 6;
        private float discardChanceOnAirExposure = 0.0f;

        private AsOre(class_2960 featureID, class_3122 feature) {
            super(featureID, feature);
        }

        public AsOre add(class_2248 containedIn, class_2248 ore) {
            return this.add(containedIn, ore.method_9564());
        }

        public AsOre add(class_2248 containedIn, class_2680 ore) {
            return this.add((class_3825)new class_3819(containedIn), ore);
        }

        public AsOre add(class_3825 containedIn, class_2248 ore) {
            return this.add(containedIn, ore.method_9564());
        }

        public AsOre add(class_3825 containedIn, class_2680 ore) {
            this.targetStates.add(class_3124.method_33994((class_3825)containedIn, (class_2680)ore));
            return this;
        }

        public AsOre veinSize(int size) {
            this.size = size;
            return this;
        }

        public AsOre discardChanceOnAirExposure(float chance) {
            this.discardChanceOnAirExposure = chance;
            return this;
        }

        @Override
        public class_3124 createConfiguration() {
            return new class_3124(this.targetStates, this.size, this.discardChanceOnAirExposure);
        }
    }

    public static class FacingBlock
    extends BCLFeatureBuilder<PlaceBlockFeature<PlaceFacingBlockConfig>, PlaceFacingBlockConfig> {
        private final class_6005.class_6006<class_2680> stateBuilder = class_6005.method_34971();
        class_2680 firstState;
        private int count = 0;
        private List<class_2350> directions = PlaceFacingBlockConfig.HORIZONTAL;

        private FacingBlock(@NotNull class_2960 featureID, @NotNull PlaceBlockFeature<PlaceFacingBlockConfig> feature) {
            super(featureID, feature);
        }

        public FacingBlock allHorizontal() {
            this.directions = PlaceFacingBlockConfig.HORIZONTAL;
            return this;
        }

        public FacingBlock allVertical() {
            this.directions = PlaceFacingBlockConfig.VERTICAL;
            return this;
        }

        public FacingBlock allDirections() {
            this.directions = PlaceFacingBlockConfig.ALL;
            return this;
        }

        public FacingBlock add(class_2248 block) {
            return this.add(block, 1);
        }

        public FacingBlock add(class_2680 state) {
            return this.add(state, 1);
        }

        public FacingBlock add(class_2248 block, int weight) {
            return this.add(block.method_9564(), weight);
        }

        public FacingBlock add(class_2680 state, int weight) {
            if (this.firstState == null) {
                this.firstState = state;
            }
            ++this.count;
            this.stateBuilder.method_34975((Object)state, weight);
            return this;
        }

        public FacingBlock addAllStates(class_2248 block, int weight) {
            Set<class_2680> states = BCLPoiType.getBlockStates(block);
            states.forEach(s -> this.add(block.method_9564(), Math.max(1, weight / states.size())));
            return this;
        }

        public FacingBlock addAllStatesFor(class_2758 prop, class_2248 block, int weight) {
            Collection values = prop.method_11898();
            values.forEach(s -> this.add((class_2680)block.method_9564().method_11657((class_2769)prop, (Comparable)s), Math.max(1, weight / values.size())));
            return this;
        }

        @Override
        public PlaceFacingBlockConfig createConfiguration() {
            class_4656 provider = null;
            if (this.count == 1) {
                provider = class_4656.method_38433((class_2680)this.firstState);
            } else {
                class_6005 list = this.stateBuilder.method_34974();
                if (!list.method_34993()) {
                    provider = new class_4657(list);
                }
            }
            if (provider == null) {
                throw new IllegalStateException("Facing Blocks need a State Provider.");
            }
            return new PlaceFacingBlockConfig((class_4651)provider, this.directions);
        }
    }

    @FunctionalInterface
    public static interface FeatureBuilder<F extends class_3031<FC>, FC extends class_3037, B extends BCLConfigureFeature<F, FC>> {
        public B create(class_2960 var1, class_6880<class_2975<FC, F>> var2);
    }

    @FunctionalInterface
    public static interface HolderBuilder<F extends class_3031<FC>, FC extends class_3037> {
        public class_6880<class_2975<FC, F>> apply(class_2960 var1, class_2975<FC, F> var2);
    }

    private static abstract class WeightedBaseBlock<F extends class_3031<FC>, FC extends class_3037, W extends WeightedBaseBlock>
    extends BCLFeatureBuilder<F, FC> {
        class_6005.class_6006<class_2680> stateBuilder = class_6005.method_34971();

        protected WeightedBaseBlock(@NotNull class_2960 featureID, @NotNull F feature) {
            super(featureID, feature);
        }

        public W add(class_2248 block, int weight) {
            return this.add(block.method_9564(), weight);
        }

        public W add(class_2680 state, int weight) {
            this.stateBuilder.method_34975((Object)state, weight);
            return (W)this;
        }

        public W addAllStates(class_2248 block, int weight) {
            Set<class_2680> states = BCLPoiType.getBlockStates(block);
            states.forEach(s -> this.add(block.method_9564(), Math.max(1, weight / states.size())));
            return (W)this;
        }

        public W addAllStatesFor(class_2758 prop, class_2248 block, int weight) {
            Collection values = prop.method_11898();
            values.forEach(s -> this.add((class_2680)block.method_9564().method_11657((class_2769)prop, (Comparable)s), Math.max(1, weight / values.size())));
            return (W)this;
        }
    }
}

