/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.api.v3.datagen;

import com.google.gson.JsonElement;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Encoder;
import com.mojang.serialization.JsonOps;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.minecraft.class_2405;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_6903;
import net.minecraft.class_7225;
import net.minecraft.class_7403;
import net.minecraft.class_7784;
import net.minecraft.class_7877;
import org.betterx.bclib.api.v3.datagen.RegistrySupplier;
import org.betterx.worlds.together.util.Logger;

public abstract class RegistriesDataProvider
implements class_2405 {
    protected final RegistrySupplier registries;
    protected final class_7784 output;
    protected final Logger LOGGER;
    protected final CompletableFuture<class_7225.class_7874> registriesFuture;

    protected RegistriesDataProvider(Logger logger, RegistrySupplier registries, FabricDataOutput generator, CompletableFuture<class_7225.class_7874> registriesFuture) {
        this.LOGGER = logger;
        this.output = generator;
        this.registriesFuture = registriesFuture;
        this.registries = registries;
    }

    public CompletableFuture<?> method_10319(class_7403 cachedOutput) {
        this.LOGGER.info("Serialize Registries " + this.registries.defaultModIDs);
        return this.registriesFuture.thenCompose(registriesProvider -> CompletableFuture.supplyAsync(() -> this.registries).thenCompose(entries -> {
            this.registries.acquireLock();
            class_6903 dynamicOps = class_6903.method_46632((DynamicOps)JsonOps.INSTANCE, (class_7225.class_7874)registriesProvider);
            CompletableFuture[] futures = (CompletableFuture[])entries.allRegistries.stream().map(registryData -> this.serializeRegistry(cachedOutput, (class_7225.class_7874)registriesProvider, (DynamicOps<JsonElement>)dynamicOps, (RegistrySupplier.RegistryInfo)registryData, this.registries)).toArray(CompletableFuture[]::new);
            this.registries.releaseLock();
            return CompletableFuture.allOf(futures);
        }));
    }

    private <T> CompletableFuture<?> serializeRegistry(class_7403 cachedOutput, class_7225.class_7874 registryAccess, DynamicOps<JsonElement> dynamicOps, RegistrySupplier.RegistryInfo<T> registryData, RegistrySupplier registries) {
        try {
            registries.MAIN_LOCK.acquire();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        List<class_6880<T>> elements = registryData.allElements(registryAccess);
        class_7225.class_7226 registry = registryAccess.method_46762(registryData.key());
        this.LOGGER.info("Serializing " + elements.size() + "/" + registry.method_42017().count() + " elements from " + registryData.data.comp_985());
        registries.MAIN_LOCK.release();
        if (!elements.isEmpty()) {
            class_7784.class_7489 pathProvider = this.output.method_45973(class_7784.class_7490.field_39367, registryData.key().method_29177().method_12832());
            return CompletableFuture.allOf((CompletableFuture[])elements.stream().map(entry -> this.serializeElements(pathProvider.method_44107(((class_5321)entry.method_40230().orElseThrow()).method_29177()), cachedOutput, dynamicOps, (Encoder)registryData.elementCodec(), (Object)entry.comp_349())).toArray(CompletableFuture[]::new));
        }
        return CompletableFuture.completedFuture(null);
    }

    private <E> CompletableFuture<?> serializeElements(Path path, class_7403 cachedOutput, DynamicOps<JsonElement> dynamicOps, Encoder<E> encoder, E object) {
        Optional optional = encoder.encodeStart(dynamicOps, object).resultOrPartial(string -> this.LOGGER.error("Couldn't serialize element {}: {}", path, string));
        if (optional.isPresent()) {
            return class_2405.method_10320((class_7403)cachedOutput, (JsonElement)((JsonElement)optional.get()), (Path)path);
        }
        return CompletableFuture.completedFuture(null);
    }

    public void buildRegistry(class_7877 registryBuilder) {
        this.registries.allRegistries.stream().filter(nfo -> nfo.registryBootstrap != null).forEach(nfo -> {});
    }

    public String method_10321() {
        return "Registries";
    }
}

