/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.api.v2.generator;

import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.class_1959;
import net.minecraft.class_1966;
import net.minecraft.class_2378;
import net.minecraft.class_5284;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import org.betterx.bclib.BCLib;
import org.betterx.bclib.api.v2.generator.BiomePicker;
import org.betterx.bclib.api.v2.levelgen.biomes.BCLBiome;
import org.betterx.bclib.api.v2.levelgen.biomes.BCLBiomeRegistry;
import org.betterx.bclib.api.v2.levelgen.biomes.BiomeAPI;
import org.betterx.bclib.config.Configs;
import org.betterx.worlds.together.biomesource.BiomeSourceHelper;
import org.betterx.worlds.together.biomesource.MergeableBiomeSource;
import org.betterx.worlds.together.biomesource.ReloadableBiomeSource;
import org.betterx.worlds.together.world.BiomeSourceWithNoiseRelatedSettings;
import org.betterx.worlds.together.world.BiomeSourceWithSeed;
import org.betterx.worlds.together.world.event.WorldBootstrap;
import org.jetbrains.annotations.NotNull;

public abstract class BCLBiomeSource
extends class_1966
implements BiomeSourceWithSeed,
MergeableBiomeSource<BCLBiomeSource>,
BiomeSourceWithNoiseRelatedSettings,
ReloadableBiomeSource {
    protected long currentSeed;
    protected int maxHeight;
    private boolean didCreatePickers;
    Set<class_6880<class_1959>> dynamicPossibleBiomes = Set.of();

    protected BCLBiomeSource(long seed) {
        this.currentSeed = seed;
        this.didCreatePickers = false;
    }

    protected Stream<class_6880<class_1959>> method_49494() {
        this.reloadBiomes();
        return this.dynamicPossibleBiomes.stream();
    }

    public Set<class_6880<class_1959>> method_28443() {
        return this.dynamicPossibleBiomes;
    }

    protected boolean wasBound() {
        return this.didCreatePickers;
    }

    @Override
    public final void setSeed(long seed) {
        if (seed != this.currentSeed) {
            BCLib.LOGGER.debug(this + "\n    --> new seed = " + seed);
            this.currentSeed = seed;
            this.initMap(seed);
        }
    }

    public final void setMaxHeight(int maxHeight) {
        if (this.maxHeight != maxHeight) {
            BCLib.LOGGER.debug(this + "\n    --> new height = " + maxHeight);
            this.maxHeight = maxHeight;
            this.onHeightChange(maxHeight);
        }
    }

    protected final void initMap(long seed) {
        BCLib.LOGGER.debug(this + "\n    --> Map Update");
        this.onInitMap(seed);
    }

    protected abstract void onInitMap(long var1);

    protected abstract void onHeightChange(int var1);

    @NotNull
    protected String getNamespaces() {
        return BiomeSourceHelper.getNamespaces(this.method_28443());
    }

    protected boolean addToPicker(BCLBiome bclBiome, BiomeAPI.BiomeType type, BiomePicker picker) {
        picker.addBiome(bclBiome);
        return true;
    }

    protected BiomeAPI.BiomeType typeForUnknownBiome(class_5321<class_1959> biomeKey, BiomeAPI.BiomeType defaultType) {
        return defaultType;
    }

    protected static Set<class_6880<class_1959>> populateBiomePickers(Map<BiomeAPI.BiomeType, BiomePicker> acceptedBiomeTypes, BiomeAPI.BiomeType exclusionListType, PickerAdder pickerAdder, CustomTypeFinder typeFinder) {
        class_5455 access = WorldBootstrap.getLastRegistryAccess();
        if (access == null) {
            if (Configs.MAIN_CONFIG.verboseLogging() && !BCLib.isDatagen()) {
                BCLib.LOGGER.info("Unable to build Biome List yet");
            }
            return null;
        }
        HashSet<class_6880<class_1959>> allBiomes = new HashSet<class_6880<class_1959>>();
        Map<BiomeAPI.BiomeType, List<String>> includeMap = Configs.BIOMES_CONFIG.getBiomeIncludeMap();
        List<String> excludeList = Configs.BIOMES_CONFIG.getExcludeMatching(exclusionListType);
        class_2378 biomes = access.method_30530(class_7924.field_41236);
        class_2378 bclBiomes = access.method_30530(BCLBiomeRegistry.BCL_BIOMES_REGISTRY);
        List<Map.Entry> sortedList = biomes.method_29722().stream().sorted(Comparator.comparing(a -> ((class_5321)a.getKey()).method_29177().toString())).toList();
        for (Map.Entry biomeEntry : sortedList) {
            if (excludeList.contains(((class_5321)biomeEntry.getKey()).method_29177())) continue;
            BiomeAPI.BiomeType type = BiomeAPI.BiomeType.NONE;
            boolean foundBCLBiome = false;
            if (BCLBiomeRegistry.hasBiome((class_5321<class_1959>)((class_5321)biomeEntry.getKey()), (class_2378<BCLBiome>)bclBiomes)) {
                foundBCLBiome = true;
                type = BCLBiomeRegistry.getBiome((class_5321<class_1959>)((class_5321)biomeEntry.getKey()), (class_2378<BCLBiome>)bclBiomes).getIntendedType();
            } else {
                type = typeFinder.find((class_5321<class_1959>)((class_5321)biomeEntry.getKey()), type);
            }
            type = BCLBiomeSource.getBiomeType(includeMap, (class_5321<class_1959>)((class_5321)biomeEntry.getKey()), type);
            for (Map.Entry<BiomeAPI.BiomeType, BiomePicker> pickerEntry : acceptedBiomeTypes.entrySet()) {
                boolean isPossible;
                BCLBiome bclBiome;
                if (!type.is(pickerEntry.getKey())) continue;
                if (foundBCLBiome) {
                    bclBiome = BCLBiomeRegistry.getBiome((class_5321<class_1959>)((class_5321)biomeEntry.getKey()), (class_2378<BCLBiome>)bclBiomes);
                } else {
                    bclBiome = new BCLBiome(((class_5321)biomeEntry.getKey()).method_29177(), type);
                    BCLBiomeRegistry.register(bclBiome);
                    foundBCLBiome = true;
                }
                if (!(isPossible = !bclBiome.hasParentBiome() ? pickerAdder.add(bclBiome, pickerEntry.getKey(), pickerEntry.getValue()) : true)) continue;
                allBiomes.add((class_6880<class_1959>)biomes.method_40290((class_5321)biomeEntry.getKey()));
            }
        }
        return allBiomes;
    }

    protected abstract BiomeAPI.BiomeType defaultBiomeType();

    protected abstract Map<BiomeAPI.BiomeType, BiomePicker> createFreshPickerMap();

    public abstract String toShortString();

    protected void onFinishBiomeRebuild(Map<BiomeAPI.BiomeType, BiomePicker> pickerMap) {
        for (BiomePicker picker : pickerMap.values()) {
            picker.rebuild();
        }
    }

    protected final void rebuildBiomes(boolean force) {
        if (!force && this.didCreatePickers) {
            return;
        }
        if (Configs.MAIN_CONFIG.verboseLogging()) {
            BCLib.LOGGER.info("Updating Pickers for " + this.toShortString());
        }
        Map<BiomeAPI.BiomeType, BiomePicker> pickerMap = this.createFreshPickerMap();
        this.dynamicPossibleBiomes = BCLBiomeSource.populateBiomePickers(pickerMap, this.defaultBiomeType(), this::addToPicker, this::typeForUnknownBiome);
        if (this.dynamicPossibleBiomes == null) {
            this.dynamicPossibleBiomes = Set.of();
        } else {
            this.didCreatePickers = true;
        }
        this.onFinishBiomeRebuild(pickerMap);
    }

    @Override
    public BCLBiomeSource mergeWithBiomeSource(class_1966 inputBiomeSource) {
        class_5455 access = WorldBootstrap.getLastRegistryAccess();
        if (access == null) {
            BCLib.LOGGER.error("Unable to merge Biomesources!");
            return this;
        }
        Map<BiomeAPI.BiomeType, List<String>> includeMap = Configs.BIOMES_CONFIG.getBiomeIncludeMap();
        List<String> excludeList = Configs.BIOMES_CONFIG.getExcludeMatching(this.defaultBiomeType());
        class_2378 bclBiomes = access.method_30530(BCLBiomeRegistry.BCL_BIOMES_REGISTRY);
        try {
            for (class_6880 possibleBiome : inputBiomeSource.method_28443()) {
                class_5321 key = possibleBiome.method_40230().orElse(null);
                if (key == null || excludeList.contains(key.method_29177()) || BCLBiomeRegistry.hasBiome((class_5321<class_1959>)key, (class_2378<BCLBiome>)bclBiomes)) continue;
                BiomeAPI.BiomeType type = this.typeForUnknownBiome((class_5321<class_1959>)key, this.defaultBiomeType());
                type = BCLBiomeSource.getBiomeType(includeMap, (class_5321<class_1959>)key, type);
                BCLBiome bclBiome = new BCLBiome(key.method_29177(), type);
                BCLBiomeRegistry.register(bclBiome);
            }
        }
        catch (RuntimeException e) {
            BCLib.LOGGER.error("Error while rebuilding Biomesources!", e);
        }
        catch (Exception e) {
            BCLib.LOGGER.error("Error while rebuilding Biomesources!", e);
        }
        this.reloadBiomes();
        return this;
    }

    private static BiomeAPI.BiomeType getBiomeType(Map<BiomeAPI.BiomeType, List<String>> includeMap, class_5321<class_1959> biomeKey, BiomeAPI.BiomeType defaultType) {
        for (Map.Entry<BiomeAPI.BiomeType, List<String>> includeList : includeMap.entrySet()) {
            if (!includeList.getValue().contains(biomeKey.method_29177().toString())) continue;
            return includeList.getKey();
        }
        return defaultType;
    }

    @Override
    public void onLoadGeneratorSettings(class_5284 generator) {
        this.setMaxHeight(generator.comp_474().comp_174());
    }

    protected void reloadBiomes(boolean force) {
        this.rebuildBiomes(force);
        this.initMap(this.currentSeed);
    }

    @Override
    public void reloadBiomes() {
        this.reloadBiomes(true);
    }

    @FunctionalInterface
    public static interface CustomTypeFinder {
        public BiomeAPI.BiomeType find(class_5321<class_1959> var1, BiomeAPI.BiomeType var2);
    }

    @FunctionalInterface
    public static interface PickerAdder {
        public boolean add(BCLBiome var1, BiomeAPI.BiomeType var2, BiomePicker var3);
    }
}

