/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.api.v2.dataexchange.handler.autosync;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.betterx.bclib.BCLib;

public class FileContentWrapper {
    private byte[] rawContent;
    private ByteArrayOutputStream outputStream;

    FileContentWrapper(byte[] content) {
        this.rawContent = content;
        this.outputStream = null;
    }

    public byte[] getOriginalContent() {
        return this.rawContent;
    }

    public byte[] getRawContent() {
        if (this.outputStream != null) {
            return this.outputStream.toByteArray();
        }
        return this.rawContent;
    }

    private void invalidateOutputStream() {
        if (this.outputStream != null) {
            try {
                this.outputStream.close();
            }
            catch (IOException e) {
                BCLib.LOGGER.debug(e);
            }
        }
        this.outputStream = null;
    }

    public void setRawContent(byte[] rawContent) {
        this.rawContent = rawContent;
        this.invalidateOutputStream();
    }

    public void syncWithOutputStream() {
        if (this.outputStream != null) {
            try {
                this.outputStream.flush();
            }
            catch (IOException e) {
                BCLib.LOGGER.error(e.getMessage());
                e.printStackTrace();
            }
            this.setRawContent(this.getRawContent());
            this.invalidateOutputStream();
        }
    }

    public ByteArrayInputStream getInputStream() {
        if (this.rawContent == null) {
            return new ByteArrayInputStream(new byte[0]);
        }
        return new ByteArrayInputStream(this.rawContent);
    }

    public ByteArrayOutputStream getOrCreateOutputStream() {
        if (this.outputStream == null) {
            return this.getEmptyOutputStream();
        }
        return this.outputStream;
    }

    public ByteArrayOutputStream getEmptyOutputStream() {
        this.invalidateOutputStream();
        this.outputStream = new ByteArrayOutputStream(this.rawContent.length);
        return this.outputStream;
    }
}

