/*
 * Decompiled with CFR 0.152.
 */
package fr.hugman.dawn.registry;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.SimpleSynchronousResourceReloadListener;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class ReloadableResourceManager<R> {
    private final Logger LOGGER = LogUtils.getLogger();
    private final Codec<R> codec;
    private final Codec<R> entryCodec;
    private final class_3264 type;
    private final String folderPath;
    private class_2960 id;
    private Map<class_2960, R> map = ImmutableMap.of();

    private ReloadableResourceManager(Codec<R> codec, class_3264 type, String folderPath) {
        this.codec = codec;
        this.type = type;
        this.folderPath = folderPath;
        this.entryCodec = Codec.either(codec, (Codec)class_2960.field_25139).xmap(either -> either.map(r -> r, id -> this.map.get(id)), r -> this.map.containsValue(r) ? Either.right((Object)this.getId(r)) : Either.left((Object)r));
    }

    public static <R> ReloadableResourceManager<R> of(@NotNull Codec<R> codec, @NotNull class_3264 type, @NotNull String folderPath) {
        Objects.requireNonNull(codec);
        Objects.requireNonNull(type);
        Objects.requireNonNull(folderPath);
        if (folderPath.endsWith("/")) {
            throw new IllegalArgumentException("The folder path must not end with a slash.");
        }
        return new ReloadableResourceManager<R>(codec, type, folderPath);
    }

    @Nullable
    public R get(class_2960 id) {
        return this.map.get(id);
    }

    public R getOrThrow(class_2960 id) {
        R object = this.get(id);
        if (object == null) {
            throw new IllegalStateException("Missing key in " + this.id + ": " + id);
        }
        return object;
    }

    public class_2960 getId() {
        return this.id;
    }

    public Set<class_2960> getIds() {
        return this.map.keySet();
    }

    public boolean contains(R resource) {
        return this.map.containsValue(resource);
    }

    public boolean containsId(class_2960 id) {
        return this.map.containsKey(id);
    }

    public Codec<R> getEntryCodec() {
        return this.entryCodec;
    }

    public class_2960 getId(R value) {
        Optional<Map.Entry> opt = this.map.entrySet().stream().filter(entry -> Objects.equals(entry.getValue(), value)).findFirst();
        if (opt.isPresent()) {
            return (class_2960)opt.get().getKey();
        }
        throw new IllegalArgumentException("The given value does not have a key.");
    }

    public void register(final @NotNull class_2960 id) {
        this.id = id;
        ResourceManagerHelper.get((class_3264)this.type).registerReloadListener((IdentifiableResourceReloadListener)new SimpleSynchronousResourceReloadListener(){

            public class_2960 getFabricId() {
                return id;
            }

            public void method_14491(class_3300 manager) {
                Map resources = manager.method_14488(ReloadableResourceManager.this.folderPath, path -> path.method_12832().endsWith(".json"));
                ImmutableMap.Builder builder = ImmutableMap.builder();
                for (Map.Entry path2 : resources.entrySet()) {
                    try (BufferedReader reader = new BufferedReader(new InputStreamReader(((class_3298)path2.getValue()).method_14482()));){
                        JsonElement json = new JsonParser().parse((Reader)reader);
                        String idPath = ((class_2960)path2.getKey()).method_12832();
                        idPath = idPath.substring(ReloadableResourceManager.this.folderPath.length() + 1, idPath.length() - ".json".length());
                        class_2960 resourceId = new class_2960(((class_2960)path2.getKey()).method_12836(), idPath);
                        DataResult result = ReloadableResourceManager.this.codec.decode((DynamicOps)JsonOps.INSTANCE, (Object)json).map(Pair::getFirst);
                        result.resultOrPartial(error -> ReloadableResourceManager.this.LOGGER.error("Error while decoding resource of type {} at {}: {}", new Object[]{id, resourceId, error})).ifPresent(resource -> builder.put((Object)resourceId, resource));
                    }
                    catch (IOException e) {
                        ReloadableResourceManager.this.LOGGER.error("Failed to decode resource of type {} at {}: {}", new Object[]{id, path2, e});
                    }
                }
                ReloadableResourceManager.this.map = builder.build();
            }
        });
    }
}

