/*
 * Decompiled with CFR 0.152.
 */
package fuzs.overflowingbars.client.handler;

import com.mojang.blaze3d.systems.RenderSystem;
import fuzs.overflowingbars.OverflowingBars;
import fuzs.overflowingbars.client.handler.BarOverlayRenderer;
import fuzs.overflowingbars.config.ClientConfig;
import net.minecraft.class_1294;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_3695;
import net.minecraft.class_5134;
import net.minecraft.class_5819;

public class HealthBarRenderer {
    public static final HealthBarRenderer INSTANCE = new HealthBarRenderer();
    private final class_5819 random = class_5819.method_43047();
    private int tickCount;
    private int lastHealth;
    private int displayHealth;
    private long lastHealthTime;
    private long healthBlinkTime;

    public void onStartTick(class_310 minecraft) {
        ++this.tickCount;
    }

    public void renderPlayerHealth(class_332 guiGraphics, int posX, int posY, class_1657 player, class_3695 profiler) {
        profiler.method_15396("health");
        BarOverlayRenderer.resetRenderState();
        RenderSystem.enableBlend();
        int currentHealth = class_3532.method_15386((float)player.method_6032());
        boolean blink = this.healthBlinkTime > (long)this.tickCount && (this.healthBlinkTime - (long)this.tickCount) / 3L % 2L == 1L;
        long millis = class_156.method_658();
        if (currentHealth < this.lastHealth && player.field_6008 > 0) {
            this.lastHealthTime = millis;
            this.healthBlinkTime = this.tickCount + 20;
        } else if (currentHealth > this.lastHealth && player.field_6008 > 0) {
            this.lastHealthTime = millis;
            this.healthBlinkTime = this.tickCount + 10;
        }
        if (millis - this.lastHealthTime > 1000L) {
            this.displayHealth = currentHealth;
            this.lastHealthTime = millis;
        }
        this.lastHealth = currentHealth;
        int displayHealth = this.displayHealth;
        this.random.method_43052((long)(this.tickCount * 312871));
        float maxHealth = Math.max((float)player.method_26825(class_5134.field_23716), (float)Math.max(displayHealth, currentHealth));
        int currentAbsorption = class_3532.method_15386((float)player.method_6067());
        int heartOffsetByRegen = -1;
        if (player.method_6059(class_1294.field_5924)) {
            heartOffsetByRegen = this.tickCount % class_3532.method_15386((float)(Math.min(20.0f, maxHealth) + 5.0f));
        }
        this.renderHearts(guiGraphics, player, posX, posY, heartOffsetByRegen, maxHealth, currentHealth, displayHealth, currentAbsorption, blink);
        RenderSystem.disableBlend();
        profiler.method_15407();
    }

    private void renderHearts(class_332 guiGraphics, class_1657 player, int posX, int posY, int heartOffsetByRegen, float maxHealth, int currentHealth, int displayHealth, int currentAbsorptionHealth, boolean blink) {
        boolean hardcore = player.method_37908().method_8401().method_152();
        int normalHearts = Math.min(10, class_3532.method_15384((double)((double)maxHealth / 2.0)));
        int maxAbsorptionHearts = 20 - normalHearts;
        int absorptionHearts = Math.min(20 - normalHearts, class_3532.method_15384((double)((double)currentAbsorptionHealth / 2.0)));
        for (int currentHeart = 0; currentHeart < normalHearts + absorptionHearts; ++currentHeart) {
            boolean orange;
            boolean halfHeart;
            int currentAbsorption;
            int currentPosX = posX + currentHeart % 10 * 8;
            int currentPosY = posY - currentHeart / 10 * 10;
            if (currentHealth + currentAbsorptionHealth <= 4) {
                currentPosY += this.random.method_43048(2);
            }
            if (currentHeart < normalHearts && heartOffsetByRegen == currentHeart) {
                currentPosY -= 2;
            }
            this.renderHeart(guiGraphics, HeartType.CONTAINER, currentPosX, currentPosY, blink, false, hardcore);
            if (currentHeart >= normalHearts && (currentAbsorption = currentHeart * 2 - normalHearts * 2) < currentAbsorptionHealth) {
                boolean orange2;
                int maxAbsorptionHealth = maxAbsorptionHearts * 2;
                boolean halfHeart2 = currentAbsorption + 1 == currentAbsorptionHealth % maxAbsorptionHealth;
                boolean bl = orange2 = currentAbsorptionHealth > maxAbsorptionHealth && currentAbsorption + 1 <= (currentAbsorptionHealth - 1) % maxAbsorptionHealth + 1;
                if (halfHeart2 && orange2) {
                    this.renderHeart(guiGraphics, HeartType.forPlayer(player, true, false), currentPosX, currentPosY, false, false, hardcore);
                }
                this.renderHeart(guiGraphics, HeartType.forPlayer(player, true, orange2), currentPosX, currentPosY, false, halfHeart2, hardcore);
            }
            if (blink && currentHeart * 2 < Math.min(20, displayHealth)) {
                halfHeart = currentHeart * 2 + 1 == (displayHealth - 1) % 20 + 1;
                boolean bl = orange = displayHealth > 20 && currentHeart * 2 + 1 <= (displayHealth - 1) % 20 + 1;
                if (halfHeart && orange) {
                    this.renderHeart(guiGraphics, HeartType.forPlayer(player, false, false), currentPosX, currentPosY, true, false, hardcore);
                }
                this.renderHeart(guiGraphics, HeartType.forPlayer(player, false, orange || ((ClientConfig)OverflowingBars.CONFIG.get(ClientConfig.class)).health.colorizeFirstRow && currentHeart * 2 + 1 <= (displayHealth - 1) % 20 + 1), currentPosX, currentPosY, true, halfHeart, hardcore);
            }
            if (currentHeart * 2 >= Math.min(20, currentHealth)) continue;
            halfHeart = currentHeart * 2 + 1 == (currentHealth - 1) % 20 + 1;
            boolean bl = orange = currentHealth > 20 && currentHeart * 2 + 1 <= (currentHealth - 1) % 20 + 1;
            if (halfHeart && orange) {
                this.renderHeart(guiGraphics, HeartType.forPlayer(player, false, false), currentPosX, currentPosY, false, false, hardcore);
            }
            this.renderHeart(guiGraphics, HeartType.forPlayer(player, false, orange || ((ClientConfig)OverflowingBars.CONFIG.get(ClientConfig.class)).health.colorizeFirstRow && currentHeart * 2 + 1 <= (currentHealth - 1) % 20 + 1), currentPosX, currentPosY, false, halfHeart, hardcore);
        }
    }

    private void renderHeart(class_332 guiGraphics, HeartType heartType, int posX, int posY, boolean blink, boolean halfHeart, boolean hardcore) {
        guiGraphics.method_25302(heartType.textureSheet, posX, posY, heartType.getX(halfHeart, blink), heartType.getY(hardcore), 9, 9);
    }

    static enum HeartType {
        CONTAINER(0, false),
        NORMAL(2, true),
        POISONED(4, true),
        WITHERED(6, true),
        ABSORBING(8, false),
        FROZEN(9, false),
        ORANGE(0, 3, 4, BarOverlayRenderer.OVERFLOWING_ICONS_LOCATION, true);

        private final int textureIndexX;
        private final int textureIndexY;
        private final int hardcoreIndexY;
        public final class_2960 textureSheet;
        private final boolean canBlink;

        private HeartType(int textureIndexX, boolean blink) {
            this(textureIndexX, 0, 5, BarOverlayRenderer.GUI_ICONS_LOCATION, blink);
        }

        private HeartType(int textureIndexX, int textureIndexY, int hardcoreIndexY, class_2960 textureSheet, boolean blink) {
            this.textureIndexX = textureIndexX;
            this.textureIndexY = textureIndexY;
            this.hardcoreIndexY = hardcoreIndexY;
            this.textureSheet = textureSheet;
            this.canBlink = blink;
        }

        public int getX(boolean halfHeart, boolean blink) {
            int i;
            if (this == CONTAINER) {
                i = blink ? 1 : 0;
            } else {
                int j = halfHeart ? 1 : 0;
                int k = this.canBlink && blink ? 2 : 0;
                i = j + k;
            }
            return (this == ORANGE ? 0 : 16) + (this.textureIndexX * 2 + i) * 9;
        }

        public int getY(boolean hardcore) {
            return (hardcore ? this.hardcoreIndexY : this.textureIndexY) * 9;
        }

        public static HeartType forPlayer(class_1657 player, boolean absorbing, boolean orange) {
            if (player.method_6059(class_1294.field_5920)) {
                return WITHERED;
            }
            if (player.method_6059(class_1294.field_5899)) {
                return POISONED;
            }
            if (player.method_32314()) {
                return FROZEN;
            }
            boolean inverse = ((ClientConfig)OverflowingBars.CONFIG.get(ClientConfig.class)).health.inverseColoring;
            if (orange) {
                return absorbing || !inverse ? ORANGE : NORMAL;
            }
            return absorbing ? ABSORBING : (inverse ? ORANGE : NORMAL);
        }
    }
}

