/*
 * Decompiled with CFR 0.152.
 */
package com.probejs.specials;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.probejs.ProbeCommands;
import com.probejs.ProbeConfig;
import com.probejs.ProbeJS;
import com.probejs.ProbePaths;
import com.probejs.jdoc.jsgen.DocGenerationEventJS;
import com.probejs.specials.special.FormatterLang;
import com.probejs.specials.special.FormatterLootTable;
import com.probejs.specials.special.FormatterRecipeId;
import com.probejs.specials.special.FormatterTag;
import com.probejs.util.json.JArray;
import com.probejs.util.json.JObject;
import com.probejs.util.json.JPrimitive;
import dev.architectury.platform.Platform;
import dev.latvian.mods.kubejs.bindings.ItemWrapper;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.class_161;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;

public class SnippetCompiler {
    public static void compile(DocGenerationEventJS event) throws IOException {
        Path codeFile = ProbePaths.WORKSPACE_SETTINGS.resolve("probe.code-snippets");
        KubeDump kubeDump = KubeDump.fetch();
        BufferedWriter writer = Files.newBufferedWriter(codeFile, new OpenOption[0]);
        writer.write(ProbeJS.GSON.toJson((JsonElement)kubeDump.toSnippet(event)));
        writer.close();
    }

    public static class KubeDump {
        public Map<String, Map<String, List<String>>> tags;
        public Map<String, List<String>> registries;

        public KubeDump(Map<String, Map<String, List<String>>> tags, Map<String, List<String>> registries) {
            this.tags = tags;
            this.registries = registries;
        }

        private static void putTag(Map<String, Map<String, List<String>>> tags, String type, class_2378<?> registry) {
            tags.put(type, FormatterTag.getTagsFromRegistry(registry).stream().collect(Collectors.toMap(s -> s, s -> new ArrayList())));
        }

        private static <T> void putRegistry(Map<String, List<String>> registries, String type, class_5321<class_2378<T>> registry) {
            registries.put(type, ProbeCommands.getRegistry(registry).method_10235().stream().map(class_2960::toString).toList());
        }

        public static <T> KubeDump fetch() {
            HashMap<String, Map<String, List<String>>> tags = new HashMap<String, Map<String, List<String>>>();
            HashMap<String, List<String>> registries = new HashMap<String, List<String>>();
            ProbeCommands.COMMAND_LEVEL.method_30349().method_40311().forEach(registry -> {
                class_5321 key = registry.comp_350();
                String[] paths = key.method_29177().method_12832().split("/");
                String name = paths[paths.length - 1];
                KubeDump.putTag(tags, name, registry.comp_351());
                KubeDump.putRegistry(registries, name, key);
            });
            return new KubeDump(tags, registries);
        }

        public String toString() {
            return "KubeDump{tags=" + this.tags + ", registries=" + this.registries + "}";
        }

        private static void addSnippets(JsonObject resultJson, String type, Collection<String> members) {
            if (!members.isEmpty()) {
                resultJson.add(type, (JsonElement)JObject.create().add("prefix", JArray.create().add(new JPrimitive("@" + type))).add("body", new JPrimitive("\"${1|%s|}\"".formatted(String.join((CharSequence)",", members)))).serialize());
            }
        }

        private static void addRecipeSnippets(JsonObject resultJson) {
            FormatterRecipeId.ORIGINAL_RECIPES.forEach((rl, json) -> {
                if (json instanceof JsonObject) {
                    resultJson.add(rl.toString(), (JsonElement)JObject.create().add("prefix", JArray.create().add(new JPrimitive("#" + rl))).add("body", new JPrimitive(ProbeJS.GSON_WRITER.toJson((JsonElement)json))).serialize());
                }
            });
        }

        public JsonObject toSnippet(DocGenerationEventJS event) {
            List<String> members;
            String type;
            JsonObject resultJson = new JsonObject();
            for (Map.Entry<String, List<String>> entry : this.registries.entrySet()) {
                type = entry.getKey();
                members = entry.getValue();
                KubeDump.addSnippets(resultJson, type, members);
            }
            for (Map.Entry<String, Object> entry : this.tags.entrySet()) {
                type = entry.getKey();
                members = ((Map)entry.getValue()).keySet().stream().toList();
                KubeDump.addSnippets(resultJson, type + "_tag", members);
            }
            KubeDump.addSnippets(resultJson, "loot_table", FormatterLootTable.LOOT_TABLES.stream().map(class_2960::toString).collect(Collectors.toList()));
            KubeDump.addSnippets(resultJson, "advancements", ProbeCommands.COMMAND_LEVEL.method_8503().method_3851().method_12893().stream().map(class_161::method_688).map(class_2960::toString).collect(Collectors.toList()));
            KubeDump.addSnippets(resultJson, "mod", Platform.getModIds());
            KubeDump.addSnippets(resultJson, "lang_key", FormatterLang.getLangKeys("en_us").map(Map.Entry::getKey).toList());
            resultJson.add("itemstack", (JsonElement)JObject.create().add("prefix", JArray.create().add(new JPrimitive("@itemstack"))).add("body", new JPrimitive("\"${1}x ${2|%s|}\"".formatted(String.join((CharSequence)",", ItemWrapper.getTypeList())))).serialize());
            if (!ProbeConfig.INSTANCE.disableRecipeJsonDump) {
                KubeDump.addRecipeSnippets(resultJson);
            }
            event.getSnippets().forEach(consumer -> consumer.accept(resultJson));
            return resultJson;
        }
    }
}

