/*
 * Decompiled with CFR 0.152.
 */
package com.probejs.recipe.component;

import com.probejs.docs.formatter.formatter.FormatterNamespace;
import com.probejs.docs.formatter.formatter.IFormatter;
import com.probejs.recipe.component.FormatterRecipeKey;
import com.probejs.util.Util;
import dev.latvian.mods.kubejs.recipe.RecipeKey;
import dev.latvian.mods.kubejs.recipe.schema.RecipeNamespace;
import dev.latvian.mods.kubejs.recipe.schema.RecipeSchema;
import dev.latvian.mods.kubejs.recipe.schema.RecipeSchemaType;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class FormatterRecipeSchema
implements IFormatter {
    private final String className;
    private final String mod;
    private final RecipeSchema schema;

    public FormatterRecipeSchema(String mod, String loc, RecipeSchema schema) {
        this.schema = schema;
        this.mod = Util.snakeToTitle(mod);
        this.className = Util.pathToTitle(loc);
    }

    @Override
    public List<String> format(Integer indent, Integer stepIndent) {
        ArrayList<String> lines = new ArrayList<String>();
        lines.add("class %s extends %s {".formatted(this.className + this.mod, Util.formatMaybeParameterized(this.schema.recipeType)));
        for (RecipeKey key : this.schema.keys) {
            FormatterRecipeKey keyFormatter = new FormatterRecipeKey(key);
            lines.addAll(keyFormatter.getBuilder().format(indent + stepIndent, stepIndent));
        }
        lines.add("}");
        return lines;
    }

    public static IFormatter formatRecipeClasses() {
        ArrayList<FormatterRecipeSchema> recipeFormatters = new ArrayList<FormatterRecipeSchema>();
        for (Map.Entry entry : RecipeNamespace.getAll().entrySet()) {
            String key = (String)entry.getKey();
            RecipeNamespace namespace = (RecipeNamespace)entry.getValue();
            for (Map.Entry e : namespace.entrySet()) {
                String loc = (String)e.getKey();
                RecipeSchemaType value = (RecipeSchemaType)e.getValue();
                recipeFormatters.add(new FormatterRecipeSchema(key, loc, value.schema));
            }
        }
        return new FormatterNamespace("Recipes", recipeFormatters);
    }
}

