/*
 * Decompiled with CFR 0.152.
 */
package com.probejs.jdoc.property;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mojang.datafixers.util.Pair;
import com.probejs.docs.formatter.NameResolver;
import com.probejs.jdoc.Serde;
import com.probejs.jdoc.java.type.ITypeInfo;
import com.probejs.jdoc.java.type.TypeInfoArray;
import com.probejs.jdoc.java.type.TypeInfoClass;
import com.probejs.jdoc.java.type.TypeInfoParameterized;
import com.probejs.jdoc.java.type.TypeInfoVariable;
import com.probejs.jdoc.java.type.TypeInfoWildcard;
import com.probejs.jdoc.property.AbstractProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.Nullable;

public abstract class PropertyType<T extends PropertyType<T>>
extends AbstractProperty<T> {
    public static PropertyType<?> wrapNonNull(PropertyType<?> inner) {
        return new Parameterized(new Native("NonNullable"), List.of(inner));
    }

    public static Optional<String> getClazzName(PropertyType<?> type) {
        if (type == null) {
            return Optional.empty();
        }
        if (type instanceof Clazz) {
            Clazz clazz = (Clazz)type;
            return Optional.ofNullable(clazz.getClassName());
        }
        if (type instanceof Parameterized) {
            Parameterized parameterized = (Parameterized)type;
            return PropertyType.getClazzName(parameterized.getBase());
        }
        return Optional.empty();
    }

    public abstract String getTypeName();

    public abstract void fromJava(ITypeInfo var1);

    public abstract boolean equalsToJavaType(ITypeInfo var1);

    public abstract boolean typeEquals(T var1);

    public final boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        return this.getClass() == obj.getClass() && this.typeEquals((PropertyType)obj);
    }

    public String toString() {
        return this.getTypeName();
    }

    public static class Parameterized
    extends PropertyType<Parameterized> {
        protected List<PropertyType<?>> params = new ArrayList();
        protected PropertyType<?> base;

        public Parameterized(PropertyType<?> base, List<PropertyType<?>> params) {
            this.base = base;
            this.params = params;
        }

        public Parameterized() {
        }

        @Override
        public JsonObject serialize() {
            JsonObject object = super.serialize();
            Serde.serializeCollection(object, "params", this.params);
            object.add("base", (JsonElement)this.base.serialize());
            return object;
        }

        @Override
        public void deserialize(JsonObject object) {
            super.deserialize(object);
            Serde.deserializeDocuments(this.params, object.get("params"));
            this.base = (PropertyType)Serde.deserializeProperty(object.get("base").getAsJsonObject());
        }

        public List<PropertyType<?>> getParams() {
            return this.params;
        }

        public PropertyType<?> getBase() {
            return this.base;
        }

        @Override
        public String getTypeName() {
            return this.base.getTypeName() + "<%s>".formatted(this.params.stream().map(PropertyType::getTypeName).collect(Collectors.joining(", ")));
        }

        @Override
        public void fromJava(ITypeInfo type) {
            if (type instanceof TypeInfoParameterized) {
                TypeInfoParameterized paramType = (TypeInfoParameterized)type;
                this.base = Serde.deserializeFromJavaType(paramType.getBaseType(), true);
                paramType.getParamTypes().forEach(t -> this.params.add(Serde.deserializeFromJavaType(t)));
            }
            if (type instanceof TypeInfoClass) {
                TypeInfoClass classType = (TypeInfoClass)type;
                this.base = Serde.deserializeFromJavaType(classType, true);
                classType.getTypeVariables().forEach(t -> this.params.add(new Clazz("java.lang.Object")));
            }
        }

        @Override
        public boolean equalsToJavaType(ITypeInfo type) {
            if (type instanceof TypeInfoParameterized) {
                TypeInfoParameterized paramType = (TypeInfoParameterized)type;
                if (!this.base.equalsToJavaType(paramType.getBaseType())) {
                    return false;
                }
                List<ITypeInfo> args = paramType.getParamTypes();
                if (this.params.size() != args.size()) {
                    return false;
                }
                for (int i = 0; i < args.size(); ++i) {
                    if (this.params.get(i).equalsToJavaType(args.get(i))) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        @Override
        public boolean typeEquals(Parameterized type) {
            return this.base.equals(type.base) && this.params.equals(type.params);
        }

        public int hashCode() {
            return Objects.hash(this.params, this.base);
        }

        @Override
        public Parameterized copy() {
            return new Parameterized(this.base, this.params);
        }
    }

    public static class Native
    extends Named<Native> {
        public Native(String name) {
            super(name);
        }

        public Native() {
        }

        @Override
        public boolean equalsToJavaType(ITypeInfo type) {
            return false;
        }

        @Override
        public void fromJava(ITypeInfo type) {
        }

        @Override
        public Native copy() {
            return new Native(this.name);
        }
    }

    public static class Clazz
    extends Named<Clazz> {
        public Clazz(String name) {
            super(name);
        }

        public Clazz(Class<?> clazz) {
            this(clazz.getName());
        }

        public Clazz() {
        }

        public String getClassName() {
            return this.name;
        }

        @Nullable
        public Class<?> getDocumentClass() {
            try {
                return Class.forName(this.name);
            }
            catch (ClassNotFoundException e) {
                return null;
            }
        }

        @Override
        public String getTypeName() {
            return NameResolver.getResolvedName(this.getClassName()).getFullName();
        }

        @Override
        public boolean equalsToJavaType(ITypeInfo type) {
            TypeInfoClass clazz;
            if (type instanceof TypeInfoWildcard && this.name.equals("java.lang.Object")) {
                return true;
            }
            return type instanceof TypeInfoClass && (clazz = (TypeInfoClass)type).getTypeName().equals(this.getClassName());
        }

        @Override
        public void fromJava(ITypeInfo type) {
            if (type instanceof TypeInfoClass) {
                TypeInfoClass clazz = (TypeInfoClass)type;
                this.name = clazz.getTypeName();
            }
        }

        @Override
        public Clazz copy() {
            return new Clazz(this.name);
        }
    }

    public static class JSLambda
    extends PropertyType<JSLambda> {
        private final List<Pair<String, PropertyType<?>>> params = new ArrayList();
        private PropertyType<?> returns = new Native("any");

        public JSLambda() {
        }

        public JSLambda(List<Pair<String, PropertyType<?>>> params, PropertyType<?> returns) {
            this.params.addAll(params);
            this.returns = returns;
        }

        @Override
        public JSLambda copy() {
            return new JSLambda(this.params, this.returns);
        }

        @Override
        public String getTypeName() {
            return "(%s) => %s".formatted(this.params.stream().map(pair -> "%s: %s".formatted(pair.getFirst(), ((PropertyType)pair.getSecond()).getTypeName())).collect(Collectors.joining(", ")), this.returns.getTypeName());
        }

        @Override
        public void fromJava(ITypeInfo type) {
        }

        @Override
        public boolean equalsToJavaType(ITypeInfo type) {
            return false;
        }

        @Override
        public boolean typeEquals(JSLambda type) {
            return this.params.equals(type.params) && this.returns.equals(type.returns);
        }

        public List<Pair<String, PropertyType<?>>> getParams() {
            return this.params;
        }

        public PropertyType<?> getReturns() {
            return this.returns;
        }
    }

    public static class TypeOf
    extends PropertyType<TypeOf> {
        private PropertyType<?> component;

        public TypeOf(PropertyType<?> component) {
            this.component = component;
        }

        public TypeOf() {
        }

        @Override
        public TypeOf copy() {
            return new TypeOf(this.component);
        }

        @Override
        public String getTypeName() {
            return "typeof %s".formatted(this.component.getTypeName());
        }

        @Override
        public void fromJava(ITypeInfo type) {
        }

        @Override
        public boolean equalsToJavaType(ITypeInfo type) {
            return false;
        }

        @Override
        public boolean typeEquals(TypeOf type) {
            return type.component.equals(this.component);
        }

        @Override
        public JsonObject serialize() {
            JsonObject object = super.serialize();
            object.add("component", (JsonElement)this.component.serialize());
            return object;
        }

        @Override
        public void deserialize(JsonObject object) {
            super.deserialize(object);
            this.component = (PropertyType)Serde.deserializeProperty(object.get("component").getAsJsonObject());
        }

        public PropertyType<?> getComponent() {
            return this.component;
        }
    }

    public static class JSArray
    extends PropertyType<JSArray> {
        private final List<PropertyType<?>> types = new ArrayList();

        public JSArray() {
        }

        public JSArray(List<PropertyType<?>> types) {
            this.types.addAll(types.stream().flatMap(type -> {
                Stream<PropertyType<Object>> stream;
                if (type instanceof JSArray) {
                    JSArray array = (JSArray)type;
                    stream = array.getTypes().stream();
                } else {
                    stream = Stream.of(type);
                }
                return stream;
            }).toList());
        }

        @Override
        public JSArray copy() {
            return new JSArray(this.types);
        }

        @Override
        public JsonObject serialize() {
            JsonObject object = super.serialize();
            Serde.serializeCollection(object, "types", this.types);
            return object;
        }

        @Override
        public void deserialize(JsonObject object) {
            super.deserialize(object);
            Serde.deserializeDocuments(this.types, object.get("types"));
        }

        @Override
        public String getTypeName() {
            return "[%s]".formatted(this.types.stream().map(PropertyType::getTypeName).collect(Collectors.joining(", ")));
        }

        @Override
        public void fromJava(ITypeInfo type) {
        }

        @Override
        public boolean equalsToJavaType(ITypeInfo type) {
            return false;
        }

        @Override
        public boolean typeEquals(JSArray type) {
            return this.types.equals(type.types);
        }

        public int hashCode() {
            return Objects.hash(this.types);
        }

        public List<PropertyType<?>> getTypes() {
            return this.types;
        }
    }

    public static class JSObject
    extends PropertyType<JSObject> {
        private final Map<JSObjectKey, PropertyType<?>> keyValues = new HashMap();

        public JSObject() {
        }

        public JSObject(Map<JSObjectKey, PropertyType<?>> keyValues) {
            this.keyValues.putAll(keyValues);
        }

        @Override
        public JSObject copy() {
            return new JSObject(this.keyValues);
        }

        public JSObject add(JSObjectKey key, PropertyType<?> value) {
            this.keyValues.put(key, value);
            return this;
        }

        @Override
        public JsonObject serialize() {
            JsonObject object = super.serialize();
            JsonArray keyValuePairs = new JsonArray();
            for (Map.Entry<JSObjectKey, PropertyType<?>> entry : this.keyValues.entrySet()) {
                JSObjectKey key = entry.getKey();
                PropertyType<?> value = entry.getValue();
                JsonObject pair = new JsonObject();
                pair.add("key", key.serialize());
                pair.add("value", (JsonElement)value.serialize());
                keyValuePairs.add((JsonElement)pair);
            }
            object.add("members", (JsonElement)keyValuePairs);
            return object;
        }

        @Override
        public void deserialize(JsonObject object) {
            super.deserialize(object);
            for (JsonElement element : object.get("members").getAsJsonArray()) {
                JsonObject keyValuePair = element.getAsJsonObject();
                JSObjectKey key = new JSObjectKey();
                key.deserialize(keyValuePair.get("key"));
                this.keyValues.put(key, (PropertyType)Serde.deserializeProperty(keyValuePair.get("value").getAsJsonObject()));
            }
        }

        @Override
        public String getTypeName() {
            return "{%s}".formatted(this.keyValues.entrySet().stream().map(entry -> {
                JSObjectKey key = (JSObjectKey)entry.getKey();
                PropertyType value = (PropertyType)entry.getValue();
                return "%s: %s".formatted(key.serialize(), value.getTypeName());
            }).collect(Collectors.joining(", ")));
        }

        @Override
        public void fromJava(ITypeInfo type) {
        }

        @Override
        public boolean equalsToJavaType(ITypeInfo type) {
            return false;
        }

        @Override
        public boolean typeEquals(JSObject type) {
            return this.keyValues.equals(type.keyValues);
        }

        public int hashCode() {
            return Objects.hash(this.keyValues);
        }

        public Map<JSObjectKey, PropertyType<?>> getKeyValues() {
            return this.keyValues;
        }
    }

    public static class JSObjectKey {
        private String nameKey;
        private PropertyType<?> typeKey;
        private boolean isOptional;

        public JSObjectKey withName(String name) {
            this.nameKey = name;
            return this;
        }

        public JSObjectKey withType(PropertyType<?> type) {
            this.typeKey = type;
            return this;
        }

        public JSObjectKey optional(boolean optional) {
            this.isOptional = optional;
            return this;
        }

        public void deserialize(JsonElement element) {
            if (element.isJsonPrimitive()) {
                this.nameKey = element.getAsString();
            } else {
                JsonObject object = element.getAsJsonObject();
                if (object.has("optional")) {
                    this.isOptional = object.get("optional").getAsBoolean();
                    this.deserialize(object.get("key"));
                    return;
                }
                this.typeKey = (PropertyType)Serde.deserializeProperty(object);
            }
        }

        public JsonElement serialize() {
            JsonPrimitive element = new JsonPrimitive("unknown");
            if (this.nameKey != null) {
                element = new JsonPrimitive(this.nameKey);
            } else if (this.typeKey != null) {
                element = this.typeKey.serialize();
            }
            if (this.isOptional) {
                JsonObject optionalWrapper = new JsonObject();
                optionalWrapper.addProperty("optional", Boolean.valueOf(true));
                optionalWrapper.add("key", (JsonElement)element);
                element = optionalWrapper;
            }
            return element;
        }

        public String format() {
            if (this.nameKey != null) {
                return this.nameKey + (this.isOptional ? "?" : "");
            }
            if (this.typeKey != null) {
                return "[key in %s]".formatted(Serde.getTypeFormatter(this.typeKey).formatFirst());
            }
            return "any";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            JSObjectKey that = (JSObjectKey)o;
            return Objects.equals(this.nameKey, that.nameKey) && Objects.equals(this.typeKey, that.typeKey);
        }

        public int hashCode() {
            return Objects.hash(this.nameKey, this.typeKey);
        }
    }

    public static class Array
    extends PropertyType<Array> {
        private PropertyType<?> component;

        public Array(PropertyType<?> component) {
            this.component = component;
        }

        public Array() {
        }

        @Override
        public String getTypeName() {
            return this.component.getTypeName() + "[]";
        }

        @Override
        public JsonObject serialize() {
            JsonObject object = super.serialize();
            object.add("component", (JsonElement)this.component.serialize());
            return object;
        }

        @Override
        public void deserialize(JsonObject object) {
            super.deserialize(object);
            this.component = (PropertyType)Serde.deserializeProperty(object.get("component").getAsJsonObject());
        }

        @Override
        public void fromJava(ITypeInfo type) {
            if (type instanceof TypeInfoArray) {
                TypeInfoArray array = (TypeInfoArray)type;
                this.component = Serde.deserializeFromJavaType(array.getBaseType());
            }
        }

        @Override
        public boolean equalsToJavaType(ITypeInfo type) {
            TypeInfoArray array;
            return type instanceof TypeInfoArray && this.component.equalsToJavaType((array = (TypeInfoArray)type).getBaseType());
        }

        @Override
        public boolean typeEquals(Array type) {
            return this.component.equals(type.component);
        }

        public int hashCode() {
            return Objects.hash(this.component);
        }

        @Override
        public Array copy() {
            return new Array(this.component);
        }

        public PropertyType<?> getComponent() {
            return this.component;
        }
    }

    public static class Union
    extends Joint<Union> {
        public Union() {
        }

        public Union(List<PropertyType<?>> types) {
            super(types.stream().flatMap(prop -> {
                Stream<PropertyType<Object>> stream;
                if (prop instanceof Union) {
                    Union union = (Union)prop;
                    stream = union.types.stream();
                } else {
                    stream = Stream.of(prop);
                }
                return stream;
            }).collect(Collectors.toList()));
            if (types.stream().anyMatch(prop -> {
                if (!(prop instanceof Native)) return false;
                Native n = (Native)prop;
                if (n.name.startsWith("Special.")) return true;
                if (!n.name.startsWith("`")) return false;
                return true;
            })) {
                this.types.removeIf(prop -> {
                    if (prop instanceof Clazz) {
                        Clazz clazz = (Clazz)prop;
                        if (clazz.getName().equals("java.lang.String")) return true;
                    }
                    if (!(prop instanceof Native)) return false;
                    Native nat = (Native)prop;
                    if (!nat.name.equals("string")) return false;
                    return true;
                });
            }
        }

        @Override
        public String getDelimiter() {
            return "|";
        }

        @Override
        public Union copy() {
            return new Union(this.types);
        }
    }

    public static class Intersection
    extends Joint<Intersection> {
        public Intersection() {
        }

        public Intersection(List<PropertyType<?>> types) {
            super(types.stream().flatMap(prop -> {
                Stream<PropertyType<Object>> stream;
                if (prop instanceof Intersection) {
                    Intersection intersection = (Intersection)prop;
                    stream = intersection.types.stream();
                } else {
                    stream = Stream.of(prop);
                }
                return stream;
            }).collect(Collectors.toList()));
        }

        @Override
        public String getDelimiter() {
            return "&";
        }

        @Override
        public Intersection copy() {
            return new Intersection(this.types);
        }
    }

    public static abstract class Joint<T extends Joint<T>>
    extends PropertyType<T> {
        protected List<PropertyType<?>> types = new ArrayList();

        public Joint() {
        }

        public Joint(List<PropertyType<?>> types) {
            this.types = types;
        }

        @Override
        public void deserialize(JsonObject object) {
            super.deserialize(object);
            Serde.deserializeDocuments(this.types, object.get("types"));
        }

        @Override
        public JsonObject serialize() {
            JsonObject object = super.serialize();
            Serde.serializeCollection(object, "types", this.types);
            return object;
        }

        public abstract String getDelimiter();

        @Override
        public String getTypeName() {
            return this.types.stream().map(prop -> (prop instanceof Joint ? "(%s)" : "%s").formatted(prop.getTypeName())).map(arg_0 -> Joint.lambda$getTypeName$1("(%s)", arg_0)).collect(Collectors.joining(this.getDelimiter()));
        }

        @Override
        public boolean equalsToJavaType(ITypeInfo type) {
            return false;
        }

        @Override
        public void fromJava(ITypeInfo type) {
        }

        @Override
        public boolean typeEquals(T type) {
            return this.types.equals(((Joint)type).types);
        }

        public int hashCode() {
            return Objects.hash(this.types);
        }

        public List<PropertyType<?>> getTypes() {
            return this.types;
        }

        private static /* synthetic */ String lambda$getTypeName$1(String rec$, Object xva$0) {
            return "(%s)".formatted(xva$0);
        }
    }

    public static class Variable
    extends Named<Variable> {
        private final List<PropertyType<?>> bounds = new ArrayList();

        public Variable(String name) {
            super(name);
        }

        public Variable() {
        }

        @Override
        public boolean equalsToJavaType(ITypeInfo type) {
            TypeInfoVariable variable;
            return type instanceof TypeInfoVariable && (variable = (TypeInfoVariable)type).getTypeName().equals(this.getName());
        }

        @Override
        public void fromJava(ITypeInfo type) {
            if (type instanceof TypeInfoVariable) {
                TypeInfoVariable variable = (TypeInfoVariable)type;
                this.name = variable.getTypeName();
                for (ITypeInfo bound : variable.getBounds()) {
                    this.bounds.add(Serde.deserializeFromJavaType(bound, false));
                }
            }
        }

        @Override
        public Variable copy() {
            return new Variable(this.name);
        }

        @Override
        public JsonObject serialize() {
            JsonObject serialize = super.serialize();
            Serde.serializeCollection(serialize, "bounds", this.bounds);
            return serialize;
        }

        @Override
        public void deserialize(JsonObject object) {
            super.deserialize(object);
            if (object.has("bounds")) {
                Serde.deserializeDocuments(this.bounds, object.get("bounds"));
            }
        }

        public List<PropertyType<?>> getBounds() {
            return this.bounds;
        }
    }

    public static abstract class Named<T extends Named<T>>
    extends PropertyType<T> {
        protected String name;

        public Named(String name) {
            this.name = name;
        }

        public Named() {
        }

        @Override
        public JsonObject serialize() {
            JsonObject object = super.serialize();
            object.addProperty("name", this.name);
            return object;
        }

        @Override
        public void deserialize(JsonObject object) {
            super.deserialize(object);
            this.name = object.get("name").getAsString();
        }

        public String getName() {
            return this.name;
        }

        @Override
        public String getTypeName() {
            return this.getName();
        }

        @Override
        public boolean typeEquals(T type) {
            return this.name.equals(((Named)type).name);
        }

        public int hashCode() {
            return Objects.hash(this.name);
        }
    }
}

