/*
 * Decompiled with CFR 0.152.
 */
package com.probejs.jdoc.java.type;

import com.probejs.jdoc.java.type.ITypeInfo;
import com.probejs.jdoc.java.type.InfoTypeResolver;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Type;
import java.util.List;
import java.util.function.Function;

public class TypeInfoArray
implements ITypeInfo {
    private ITypeInfo type;

    public static boolean test1(Type type) {
        return type instanceof GenericArrayType;
    }

    public static boolean test2(Type type) {
        Class clazz;
        return type instanceof Class && (clazz = (Class)type).isArray();
    }

    public static boolean test(Type type) {
        return TypeInfoArray.test1(type) || TypeInfoArray.test2(type);
    }

    public TypeInfoArray(Type type, Function<Type, Type> typeTransformer) {
        if (TypeInfoArray.test1(type)) {
            this.type = InfoTypeResolver.resolveType(((GenericArrayType)type).getGenericComponentType(), typeTransformer);
        }
        if (TypeInfoArray.test2(type)) {
            assert (type instanceof Class);
            this.type = InfoTypeResolver.resolveType(((Class)type).getComponentType(), typeTransformer);
        }
    }

    private TypeInfoArray(ITypeInfo inner) {
        this.type = inner;
    }

    @Override
    public ITypeInfo getBaseType() {
        return this.type;
    }

    @Override
    public Class<?> getResolvedClass() {
        return List.class;
    }

    @Override
    public String getTypeName() {
        return this.type.getTypeName() + "[]";
    }

    public void setType(ITypeInfo type) {
        this.type = type;
    }

    @Override
    public ITypeInfo copy() {
        return new TypeInfoArray(this.type.copy());
    }

    @Override
    public boolean assignableFrom(ITypeInfo info) {
        return info instanceof TypeInfoArray && info.getBaseType().assignableFrom(this.type);
    }

    @Override
    public boolean equalsTo(ITypeInfo info) {
        return info instanceof TypeInfoArray && info.getBaseType().equalsTo(this.type);
    }
}

