/*
 * Decompiled with CFR 0.152.
 */
package com.probejs.docs.formatter;

import com.google.gson.Gson;
import com.probejs.ProbeCommands;
import com.probejs.ProbeJS;
import com.probejs.docs.formatter.NameResolver;
import com.probejs.specials.SpecialCompiler;
import com.probejs.specials.special.FormatterRegistry;
import com.probejs.util.RLHelper;
import dev.latvian.mods.rhino.util.EnumTypeWrapper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.class_2378;
import net.minecraft.class_5321;

public class SpecialTypes {
    public static Map<Class<?>, class_5321<?>> registryAssignments = new HashMap();

    public static void processEnums(Set<Class<?>> globalClasses) {
        for (Class<?> clazz : globalClasses) {
            if (!clazz.isEnum()) continue;
            try {
                EnumTypeWrapper wrapper = EnumTypeWrapper.get(clazz);
                NameResolver.putSpecialAssignments(clazz, () -> wrapper.nameValues.keySet().stream().map(arg_0 -> ((Gson)ProbeJS.GSON).toJson(arg_0)).collect(Collectors.toList()));
            }
            catch (Throwable e) {
                ProbeJS.LOGGER.warn("Failed to process enum: %s".formatted(clazz.getName()));
            }
        }
    }

    public static <T> void assignRegistry(Class<T> clazz, class_5321<class_2378<T>> resourceKey) {
        SpecialCompiler.specialCompilers.add(new FormatterRegistry<T>(resourceKey));
        NameResolver.putSpecialAssignments(clazz, () -> List.of("Special.%s".formatted(RLHelper.finalComponentToTitle(resourceKey.method_29177().method_12832()))));
        registryAssignments.put(clazz, resourceKey);
    }

    public static String getRegistryTagName(Class<?> clazz) {
        class_5321<?> key = registryAssignments.get(clazz);
        if (key == null) {
            return null;
        }
        return "`#${Special.%sTag}`".formatted(RLHelper.finalComponentToTitle(key.method_29177().method_12832()));
    }

    private static List<Class<?>> getParentInterfaces(List<Class<?>> putative, Class<?> o) {
        ArrayList result = new ArrayList();
        for (Class<?> clazz : putative) {
            if (!clazz.isAssignableFrom(o)) {
                result.addAll(SpecialTypes.getParentInterfaces(List.of(clazz.getInterfaces()), o));
                continue;
            }
            result.add(clazz);
        }
        return result;
    }

    public static <T> void assignRegistries() {
        ProbeCommands.COMMAND_LEVEL.method_30349().method_40311().forEach(entry -> {
            class_5321 key = entry.comp_350();
            class_2378 registry = entry.comp_351();
            Class<Object> putativeParent = null;
            for (Object o : registry) {
                if (putativeParent == null) {
                    putativeParent = o.getClass();
                    continue;
                }
                while (!putativeParent.isAssignableFrom(o.getClass())) {
                    putativeParent = putativeParent.getSuperclass();
                }
            }
            if (putativeParent == null) {
                return;
            }
            while (putativeParent.isSynthetic()) {
                putativeParent = putativeParent.getSuperclass();
            }
            if (putativeParent == Object.class) {
                List<Class<?>> putativeInterfaces = new ArrayList();
                for (Object o : registry) {
                    if (putativeInterfaces.isEmpty()) {
                        putativeInterfaces.addAll(List.of(o.getClass().getInterfaces()));
                        continue;
                    }
                    putativeInterfaces = SpecialTypes.getParentInterfaces(putativeInterfaces, o.getClass());
                }
                if (!putativeInterfaces.isEmpty()) {
                    putativeParent = (Class)putativeInterfaces.get(0);
                }
            }
            SpecialTypes.assignRegistry(putativeParent, key);
        });
    }

    public static List<Class<?>> collectRegistryClasses() {
        ArrayList classes = new ArrayList();
        ProbeCommands.COMMAND_LEVEL.method_30349().method_40311().forEach(entry -> {
            class_2378 registry = entry.comp_351();
            for (Object o : registry) {
                Class<?> clazz = o.getClass();
                if (clazz.isSynthetic()) continue;
                classes.add(o.getClass());
            }
        });
        return classes.stream().limit(32768L).collect(Collectors.toList());
    }
}

