/*
 * Decompiled with CFR 0.152.
 */
package io.github.blanketmc.blanket.utils;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import io.github.blanketmc.blanket.ClientFixes;
import io.github.blanketmc.blanket.config.ConfigEntry;
import io.github.blanketmc.blanket.config.ConfigHelper;
import io.github.blanketmc.blanket.config.EntryListener;
import io.github.blanketmc.blanket.utils.EnumArgumentType;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_124;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_5250;

public class ClientCommands {
    private static final class_310 mc = class_310.method_1551();
    public static final String PREFIX = "client-fixes";

    public static void registerCommands(CommandDispatcher<FabricClientCommandSource> dispatcher) {
        LiteralArgumentBuilder builder = ClientCommandManager.literal((String)PREFIX);
        builder.executes(c -> {
            ClientCommands.sendToPlayer("/client-fixes [list/<entry>]");
            return 1;
        });
        ConfigHelper.iterateOnConfig((field, configEntry) -> builder.then(((LiteralArgumentBuilder)ClientCommandManager.literal((String)field.getName()).then(ClientCommandManager.argument((String)"value", (ArgumentType)StringArgumentType.word()).executes(c -> ClientCommands.modifyEntry((CommandContext<FabricClientCommandSource>)c, field, configEntry)))).executes(c -> ClientCommands.getEntryInfo(field, configEntry))));
        builder.then(((LiteralArgumentBuilder)ClientCommandManager.literal((String)"list").then(ClientCommandManager.argument((String)"category", new EnumArgumentType<ConfigEntry.Category>(ConfigEntry.Category.class)).executes(ClientCommands::listCategoryEntries))).executes(ClientCommands::listCategories));
        dispatcher.register(builder);
    }

    private static int listCategories(CommandContext<FabricClientCommandSource> context) {
        class_5250 description = class_2561.method_43470((String)"\n\u00a7f\u00a7lCategories:\n");
        for (ConfigEntry.Category category : ConfigEntry.Category.values()) {
            description.method_10852((class_2561)class_2561.method_43470((String)(category.name().toLowerCase() + "\n")).method_27694(style -> style.method_10958(new class_2558(class_2558.class_2559.field_11750, "/client-fixes list " + category.name()))));
        }
        ClientCommands.sendToPlayer((class_2561)description);
        return 1;
    }

    private static int listCategoryEntries(CommandContext<FabricClientCommandSource> context) {
        ConfigEntry.Category category = (ConfigEntry.Category)((Object)context.getArgument("category", ConfigEntry.Category.class));
        List<Field> entries = ConfigHelper.getConfigFieldsForCategory(category);
        class_5250 description = class_2561.method_43470((String)("\n\u00a7f\u00a7l" + category.name() + ":\n"));
        for (Field field : entries) {
            description.method_10852((class_2561)class_2561.method_43470((String)(field.getName() + "\n")).method_27694(style -> style.method_10958(new class_2558(class_2558.class_2559.field_11750, "/client-fixes " + field.getName()))));
        }
        ClientCommands.sendToPlayer((class_2561)description);
        return 1;
    }

    private static int modifyEntry(CommandContext<FabricClientCommandSource> context, Field field, ConfigEntry configEntry) {
        try {
            String value = StringArgumentType.getString(context, (String)"value");
            if (field.getType().equals(Boolean.TYPE)) {
                boolean aBoolean = Boolean.parseBoolean(value);
                if (configEntry.listeners().length > 0) {
                    Boolean currentValue = field.getBoolean(ClientFixes.config);
                    for (Class<? extends EntryListener> listener : configEntry.listeners()) {
                        aBoolean = ConfigHelper.callClassConstructor(listener).onEntryChange(currentValue, aBoolean);
                    }
                }
                field.setBoolean(ClientFixes.config, aBoolean);
            } else if (field.getType().equals(Integer.TYPE)) {
                int aInt = Integer.parseInt(value);
                if (configEntry.listeners().length > 0) {
                    Integer currentValue = field.getInt(ClientFixes.config);
                    for (Class<? extends EntryListener> listener : configEntry.listeners()) {
                        aInt = ConfigHelper.callClassConstructor(listener).onEntryChange(currentValue, aInt);
                    }
                }
                field.setInt(ClientFixes.config, aInt);
            } else if (field.getType().equals(Double.TYPE)) {
                double aDouble = Double.parseDouble(value);
                if (configEntry.listeners().length > 0) {
                    Double currentValue = field.getDouble(ClientFixes.config);
                    for (Class<? extends EntryListener> listener : configEntry.listeners()) {
                        aDouble = ConfigHelper.callClassConstructor(listener).onEntryChange(currentValue, aDouble);
                    }
                }
                field.setDouble(ClientFixes.config, aDouble);
            } else if (field.getType().equals(Float.TYPE)) {
                float aFloat = Float.parseFloat(value);
                if (configEntry.listeners().length > 0) {
                    Float currentValue = Float.valueOf(field.getFloat(ClientFixes.config));
                    for (Class<? extends EntryListener> listener : configEntry.listeners()) {
                        aFloat = ConfigHelper.callClassConstructor(listener).onEntryChange(currentValue, Float.valueOf(aFloat)).floatValue();
                    }
                }
                field.setFloat(ClientFixes.config, aFloat);
            } else if (field.getType().equals(Long.class)) {
                Long aLong = Long.parseLong(value);
                if (configEntry.listeners().length > 0) {
                    Long currentValue = field.getLong(ClientFixes.config);
                    for (Class<? extends EntryListener> listener : configEntry.listeners()) {
                        aLong = ConfigHelper.callClassConstructor(listener).onEntryChange(currentValue, aLong);
                    }
                }
                field.setLong(ClientFixes.config, aLong);
            } else if (field.getType().equals(String.class)) {
                if (configEntry.listeners().length > 0) {
                    String currentValue = (String)field.get(ClientFixes.config);
                    for (Class<? extends EntryListener> listener : configEntry.listeners()) {
                        value = ConfigHelper.callClassConstructor(listener).onEntryChange(currentValue, value);
                    }
                }
                field.set(ClientFixes.config, value);
            } else if (field.getType().isAssignableFrom(String.class)) {
                Object aObject = field.getType().cast(value);
                if (configEntry.listeners().length > 0) {
                    Object currentValue = field.get(ClientFixes.config);
                    for (Class<? extends EntryListener> listener : configEntry.listeners()) {
                        aObject = ConfigHelper.callClassConstructor(listener).onEntryChange(currentValue, aObject);
                    }
                }
                field.set(ClientFixes.config, aObject);
            } else {
                ClientCommands.sendToPlayer("Well then, that type does not have a conversion yet. Nice");
            }
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return 1;
    }

    private static int getEntryInfo(Field field, ConfigEntry configEntry) {
        try {
            ClientCommands.sendToPlayer(ClientCommands.fancyCommandInfo(field, configEntry));
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return 1;
    }

    public static void sendToPlayer(String str) {
        if (ClientCommands.mc.field_1724 != null) {
            ClientCommands.mc.field_1724.method_7353((class_2561)class_2561.method_43470((String)str), false);
        }
    }

    public static void sendToPlayer(class_2561 text) {
        if (ClientCommands.mc.field_1724 != null) {
            ClientCommands.mc.field_1724.method_7353(text, false);
        }
    }

    private static class_2561 fancyCommandInfo(Field field, ConfigEntry entry) throws IllegalAccessException {
        class_5250 description = class_2561.method_43470((String)("\n\u00a7f\u00a7l" + field.getName() + "\n"));
        if (!entry.description().equals("")) {
            description = description.method_10852((class_2561)class_2561.method_43470((String)("\u00a7r" + entry.description() + "\n")).method_27692(class_124.field_1070));
        }
        if (entry.issues().length > 0) {
            description.method_10852((class_2561)class_2561.method_43470((String)"Fixes: "));
            for (String issue : entry.issues()) {
                description.method_10852((class_2561)class_2561.method_43470((String)("\u00a76[" + issue + "]")).method_27694(style -> style.method_10958(new class_2558(class_2558.class_2559.field_11749, "https://bugs.mojang.com/projects/MC/issues/" + issue))));
            }
            description.method_10852((class_2561)class_2561.method_43470((String)"\u00a7r\n"));
        }
        description.method_10852((class_2561)class_2561.method_43470((String)"Tags: "));
        Iterator iterator = Arrays.stream(entry.categories()).iterator();
        while (iterator.hasNext()) {
            ConfigEntry.Category category = (ConfigEntry.Category)((Object)iterator.next());
            description.method_10852((class_2561)class_2561.method_43470((String)("\u00a7b" + category.name())).method_27694(style -> style.method_10958(new class_2558(class_2558.class_2559.field_11750, "/client-fixes list " + category.name()))));
            if (!iterator.hasNext()) continue;
            description.method_10852((class_2561)class_2561.method_43470((String)","));
        }
        description.method_10852((class_2561)class_2561.method_43470((String)"\u00a7r\n"));
        description.method_10852((class_2561)class_2561.method_43470((String)"Current Value: "));
        if (field.getType().equals(Boolean.TYPE)) {
            boolean value = field.getBoolean(ClientFixes.config);
            description.method_10852((class_2561)class_2561.method_43470((String)(value ? "\u00a72True" : "\u00a74False")));
        } else {
            boolean isDefault = field.get(ClientFixes.config).equals(ConfigHelper.getDefaultValue(field));
            description.method_10852((class_2561)class_2561.method_43470((String)((isDefault ? "\u00a72" : "\u00a7b") + field.get(ClientFixes.config).toString())));
        }
        return description;
    }
}

