/*
 * Decompiled with CFR 0.152.
 */
package io.github.blanketmc.blanket.config.screen;

import com.google.common.collect.Lists;
import io.github.blanketmc.blanket.config.ConfigEntry;
import io.github.blanketmc.blanket.config.ConfigHelper;
import io.github.blanketmc.blanket.config.screen.BulkActionScreen;
import io.github.blanketmc.blanket.config.screen.FilterScreen;
import io.github.blanketmc.blanket.config.screen.util.ScreenHelper;
import io.github.blanketmc.blanket.config.screen.widget.BlanketConfigEntryList;
import io.github.blanketmc.blanket.config.screen.widget.FirstElementAlwaysDisplaySubCategoryEntry;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import me.shedaniel.clothconfig2.api.AbstractConfigEntry;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.gui.AbstractConfigScreen;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_333;
import net.minecraft.class_342;
import net.minecraft.class_3545;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_4185;
import net.minecraft.class_437;

public class BlanketConfigScreen
extends AbstractConfigScreen {
    private class_342 inputWidget;
    private BlanketConfigEntryList entryList;
    private final List<class_3545<Field, AbstractConfigListEntry>> configList;
    private String searchString = "";
    public Function<ConfigEntry.Category[], Boolean> categoryFilter = field -> true;
    private int sortOrder = 0;
    private List<class_4068> drawables = new ArrayList<class_4068>();
    private class_4185 saveButton;
    private class_4185 quitButton;
    private final FilterScreen categorySelectorScreen;

    public BlanketConfigScreen(class_437 parent) {
        super(parent, (class_2561)class_2561.method_43471((String)"blanket-client-tweaks.config.title"), field_44669);
        this.configList = this.fillConfigList();
        this.categorySelectorScreen = new FilterScreen(this);
    }

    public void method_25419() {
        assert (this.field_22787 != null);
        this.field_22787.method_1507(this.parent);
    }

    protected void method_25426() {
        this.drawables = new ArrayList<class_4068>();
        super.method_25426();
        this.entryList = new BlanketConfigEntryList(this, this.field_22787, this.field_22789, this.field_22790 - 60, 30, this.field_22790 - 30);
        int menuPos = 40;
        this.inputWidget = new class_342(this.field_22793, menuPos, 5, this.field_22789 / 3, 20, (class_2561)class_2561.method_43470((String)"Search"));
        menuPos += this.field_22789 / 3 + 10;
        this.method_25429((class_364)this.inputWidget);
        this.inputWidget.method_1863(this::setSearch);
        this.inputWidget.method_1852(this.searchString);
        this.method_25429((class_364)this.entryList);
        this.method_48265((class_364)this.inputWidget);
        class_4185 filterButtonWidget = class_4185.method_46430((class_2561)class_2561.method_43471((String)"blanket-client-tweaks.config.filter"), button -> this.field_22787.method_1507((class_437)this.categorySelectorScreen)).method_46434(menuPos, 5, 40, 20).method_46431();
        this.method_25429((class_364)filterButtonWidget);
        this.drawables.add((class_4068)filterButtonWidget);
        class_4185 bulkButtonWidget = class_4185.method_46430((class_2561)class_2561.method_43471((String)"blanket-client-tweaks.config.bulk"), button -> this.field_22787.method_1507((class_437)new BulkActionScreen(this))).method_46434(menuPos += 50, 5, 80, 20).method_46431();
        this.method_25429((class_364)bulkButtonWidget);
        this.drawables.add((class_4068)bulkButtonWidget);
        int buttonWidths = Math.min(200, (this.field_22789 - 50 - 12) / 3);
        this.quitButton = class_4185.method_46430((class_2561)(this.isEdited() ? class_2561.method_43471((String)"text.cloth-config.cancel_discard") : class_2561.method_43471((String)"gui.cancel")), widget -> this.quit()).method_46434(this.field_22789 / 2 - buttonWidths - 3, this.field_22790 - 26, buttonWidths, 20).method_46431();
        this.method_37063((class_364)this.quitButton);
        this.saveButton = new class_4185(this.field_22789 / 2 + 3, this.field_22790 - 26, buttonWidths, 20, class_333.field_18967, button -> this.saveAll(true), Supplier::get){

            public void method_25394(class_332 graphics, int mouseX, int mouseY, float delta) {
                boolean hasErrors = false;
                for (List abstractConfigEntries : Lists.newArrayList(BlanketConfigScreen.this.getCategorizedEntries().values())) {
                    for (AbstractConfigEntry abstractConfigEntry : abstractConfigEntries) {
                        if (!abstractConfigEntry.getConfigError().isPresent()) continue;
                        hasErrors = true;
                        break;
                    }
                    if (!hasErrors) continue;
                    break;
                }
                this.field_22763 = BlanketConfigScreen.this.isEdited() && !hasErrors;
                this.method_25355((class_2561)(hasErrors ? class_2561.method_43471((String)"text.cloth-config.error_cannot_save") : class_2561.method_43471((String)"text.cloth-config.save_and_done")));
                super.method_25394(graphics, mouseX, mouseY, delta);
            }
        };
        this.method_37063((class_364)this.saveButton);
        this.drawables.add((class_4068)this.saveButton);
        this.drawables.add((class_4068)this.quitButton);
    }

    public boolean matchesSearch(Iterator<String> tags) {
        String searchText = this.inputWidget.method_1882();
        if (searchText.length() == 0) {
            return true;
        }
        if (!tags.hasNext()) {
            return true;
        }
        boolean found = false;
        while (tags.hasNext()) {
            String tag = tags.next();
            if (!tag.toLowerCase(Locale.ROOT).contains(searchText.toLowerCase())) continue;
            found = true;
            break;
        }
        return found;
    }

    public void setSearch(String str) {
        this.searchString = str;
        ArrayList<AbstractConfigListEntry> entriesToAdd = new ArrayList<AbstractConfigListEntry>();
        for (class_3545<Field, AbstractConfigListEntry> entry : this.configList) {
            ConfigEntry configEntry = ((Field)entry.method_15442()).getAnnotation(ConfigEntry.class);
            String entryName = !configEntry.displayName().equals("") ? configEntry.displayName() : ((Field)entry.method_15442()).getName();
            if (!entryName.toLowerCase().contains(this.searchString.toLowerCase()) || !this.categoryFilter.apply(configEntry.categories()).booleanValue()) continue;
            entriesToAdd.add((AbstractConfigListEntry)entry.method_15441());
        }
        if (this.sortOrder != 0) {
            entriesToAdd.sort((o1, o2) -> o1.getFieldName().getString().toLowerCase().compareTo(o2.getFieldName().getString().toLowerCase()) * this.sortOrder);
        }
        this.entryList.setElements(entriesToAdd);
    }

    public void setSortOrder(int newOrder) {
        if (newOrder > 1 || newOrder < -1) {
            throw new IllegalArgumentException();
        }
        this.sortOrder = newOrder;
    }

    private List<class_3545<Field, AbstractConfigListEntry>> fillConfigList() {
        ArrayList<class_3545<Field, AbstractConfigListEntry>> configList = new ArrayList<class_3545<Field, AbstractConfigListEntry>>();
        ConfigHelper.iterateOnConfig((field, configEntry) -> this.addEntry(configList, field, configEntry));
        return configList;
    }

    public List<class_3545<Field, AbstractConfigListEntry>> getConfigEntries() {
        return this.configList;
    }

    private void addEntry(List<class_3545<Field, AbstractConfigListEntry>> configList, Field field, ConfigEntry configEntry) throws IllegalAccessException {
        List<AbstractConfigListEntry> propertyEntries;
        AbstractConfigListEntry<?> entry = ScreenHelper.createConfigEntry(field);
        entry.setScreen((AbstractConfigScreen)this);
        if (configEntry.extraProperties().length != 0 && !(propertyEntries = ScreenHelper.createExtraConfigEntries(configEntry.extraProperties())).isEmpty()) {
            FirstElementAlwaysDisplaySubCategoryEntry listEntry = new FirstElementAlwaysDisplaySubCategoryEntry((AbstractConfigEntry)entry, propertyEntries, this);
            configList.add((class_3545<Field, AbstractConfigListEntry>)new class_3545((Object)field, (Object)listEntry));
            return;
        }
        configList.add((class_3545<Field, AbstractConfigListEntry>)new class_3545((Object)field, entry));
    }

    public void saveAll(boolean openOtherScreens) {
        super.saveAll(openOtherScreens);
        ConfigHelper.saveConfig();
    }

    public Map<class_2561, List<AbstractConfigEntry<?>>> getCategorizedEntries() {
        HashMap map = new HashMap();
        List list = this.configList.stream().collect(ArrayList::new, (abstractConfigEntries, fieldAbstractConfigListEntryEntry) -> abstractConfigEntries.add((AbstractConfigEntry)fieldAbstractConfigListEntryEntry.method_15441()), List::addAll);
        map.put((class_2561)class_2561.method_43470((String)"blanket"), list);
        return map;
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float delta) {
        this.method_25420(graphics);
        this.entryList.method_25394(graphics, mouseX, mouseY, delta);
        this.inputWidget.method_25394(graphics, mouseX, mouseY, delta);
        for (class_4068 drawable : this.drawables) {
            drawable.method_25394(graphics, mouseX, mouseY, delta);
        }
        super.method_25394(graphics, mouseX, mouseY, delta);
    }
}

