/*
 * Decompiled with CFR 0.152.
 */
package io.github.blanketmc.blanket.config;

import io.github.blanketmc.blanket.ClientFixes;
import io.github.blanketmc.blanket.Config;
import io.github.blanketmc.blanket.config.ConfigEntry;
import io.github.blanketmc.blanket.config.ConfigJsonSerializer;
import io.github.blanketmc.blanket.config.ExtraProperty;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2561;
import net.minecraft.class_3545;
import net.minecraft.class_5250;
import org.apache.logging.log4j.Level;

public final class ConfigHelper {
    private static final Map<Field, Object> defaults = new HashMap<Field, Object>();

    public static int countActiveConfigOptions(Config config) {
        Field[] fields;
        int count = 0;
        for (Field field : fields = Config.class.getFields()) {
            try {
                ConfigEntry fieldInfo = field.getAnnotation(ConfigEntry.class);
                if (fieldInfo == null || !Modifier.isStatic(field.getModifiers())) continue;
                if (field.getType().equals(Boolean.TYPE)) {
                    if (!field.getBoolean(config)) continue;
                    ++count;
                    continue;
                }
                if (ConfigHelper.getDefaultValue(field).equals(field.get(null))) continue;
                ++count;
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        return count;
    }

    public static void iterateOnConfig(ConfigIterator iterator) {
        Field[] fields;
        for (Field field : fields = Config.class.getFields()) {
            try {
                ConfigEntry fieldInfo = field.getAnnotation(ConfigEntry.class);
                if (fieldInfo == null) continue;
                iterator.acceptConfigEntry(field, fieldInfo);
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
    }

    public static List<Field> getConfigFieldsForCategory(ConfigEntry.Category category) {
        ArrayList<Field> entries = new ArrayList<Field>();
        for (Field field : Config.class.getFields()) {
            ConfigEntry fieldInfo = field.getAnnotation(ConfigEntry.class);
            if (fieldInfo == null || !category.equals((Object)ConfigEntry.Category.ALL) && !Arrays.asList(fieldInfo.categories()).contains((Object)category)) continue;
            entries.add(field);
        }
        return entries;
    }

    public static List<class_3545<Field, ConfigEntry>> getConfigEntriesForCategory(ConfigEntry.Category category) {
        Field[] fields;
        ArrayList<class_3545<Field, ConfigEntry>> entries = new ArrayList<class_3545<Field, ConfigEntry>>();
        for (Field field : fields = Config.class.getFields()) {
            ConfigEntry fieldInfo = field.getAnnotation(ConfigEntry.class);
            if (fieldInfo == null || !Arrays.asList(fieldInfo.categories()).contains((Object)category)) continue;
            entries.add((class_3545<Field, ConfigEntry>)new class_3545((Object)field, (Object)fieldInfo));
        }
        return entries;
    }

    public static class_5250 getTextComponent(String str, String ifNull) {
        if (str.equals("")) {
            if (ifNull == null) {
                throw new IllegalArgumentException();
            }
            return class_2561.method_43470((String)ifNull);
        }
        if (str.startsWith("blanket-client-tweaks.")) {
            return class_2561.method_43471((String)str);
        }
        return class_2561.method_43470((String)str);
    }

    public static void saveConfig() {
        Path toConfig = FabricLoader.getInstance().getConfigDir();
        toConfig = toConfig.resolve("blanket_client-fixes.json");
        try (BufferedWriter writer = Files.newBufferedWriter(toConfig, StandardCharsets.UTF_8, new OpenOption[0]);){
            ConfigJsonSerializer.serializer.toJson((Object)new Config(), (Appendable)writer);
        }
        catch (IOException e) {
            ClientFixes.log(Level.ERROR, e.getMessage());
        }
    }

    public static void loadConfig() {
        Path toConfig = FabricLoader.getInstance().getConfigDir();
        if (!(toConfig = toConfig.resolve("blanket_client-fixes.json")).toFile().isFile()) {
            ConfigHelper.saveConfig();
        }
        try (BufferedReader reader = Files.newBufferedReader(toConfig, StandardCharsets.UTF_8);){
            ConfigJsonSerializer.serializer.fromJson((Reader)reader, Config.class);
        }
        catch (IOException e) {
            ClientFixes.log(Level.ERROR, e.getMessage());
        }
    }

    public static <T> T callClassConstructor(Class<T> clazz) {
        try {
            Constructor<T> constructor = clazz.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            return constructor.newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    public static Object getDefaultValue(Field configField) {
        if (!configField.isAnnotationPresent(ConfigEntry.class) && !configField.isAnnotationPresent(ExtraProperty.class)) {
            throw new IllegalArgumentException(configField + " is not a config entry");
        }
        return defaults.get(configField);
    }

    static {
        for (Field field : Config.class.getFields()) {
            if (!Modifier.isStatic(field.getModifiers()) || !field.isAnnotationPresent(ConfigEntry.class) && !field.isAnnotationPresent(ExtraProperty.class)) continue;
            try {
                defaults.put(field, field.get(null));
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
    }

    public static interface ConfigIterator {
        public void acceptConfigEntry(Field var1, ConfigEntry var2) throws IllegalAccessException;
    }
}

