/*
 * Decompiled with CFR 0.152.
 */
package tech.thatgravyboat.jukebox.api.service;

import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tech.thatgravyboat.jukebox.api.events.EventHolder;
import tech.thatgravyboat.jukebox.api.events.EventType;
import tech.thatgravyboat.jukebox.api.events.callbacks.ServiceEndedEvent;
import tech.thatgravyboat.jukebox.api.events.callbacks.ServiceErrorEvent;
import tech.thatgravyboat.jukebox.api.events.callbacks.ServiceUnauthorizedEvent;
import tech.thatgravyboat.jukebox.api.events.callbacks.SongChangeEvent;
import tech.thatgravyboat.jukebox.api.events.callbacks.UpdateEvent;
import tech.thatgravyboat.jukebox.api.events.callbacks.VolumeChangeEvent;
import tech.thatgravyboat.jukebox.api.service.Service;
import tech.thatgravyboat.jukebox.api.service.ServiceType;
import tech.thatgravyboat.jukebox.api.state.RepeatState;
import tech.thatgravyboat.jukebox.api.state.State;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010%\n\u0002\b\u0004\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b,\u0010\u001aJ'\u0010\b\u001a\u00020\u00072\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0005H\u0004\u00a2\u0006\u0004\b\b\u0010\tJ'\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00000\r\"\u0004\b\u0000\u0010\n2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\u000b\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0011\u0010\u0010\u001a\u0004\u0018\u00010\u0005H\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0017\u0010\u0015\u001a\u00020\u00142\b\u0010\u0013\u001a\u0004\u0018\u00010\u0012\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0015\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0017\u0010\u0018J\r\u0010\u0019\u001a\u00020\u0014\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u001d\u0010\u001e\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u0007\u00a2\u0006\u0004\b\u001e\u0010\u001fJ5\u0010\"\u001a\u00020\u0014\"\u0004\b\u0000\u0010\n2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\u000b2\u0012\u0010!\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00140 \u00a2\u0006\u0004\b\"\u0010#J5\u0010$\u001a\u00020\u0014\"\u0004\b\u0000\u0010\n2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\u000b2\u0012\u0010!\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00140 \u00a2\u0006\u0004\b$\u0010#R\u0016\u0010%\u001a\u00020\u001b8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b%\u0010&R\u0018\u0010'\u001a\u0004\u0018\u00010\u00058\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b'\u0010(R(\u0010*\u001a\u0016\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b\u0012\b\u0012\u0006\u0012\u0002\b\u00030\r0)8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b*\u0010+\u00a8\u0006-"}, d2={"Ltech/thatgravyboat/jukebox/api/service/BaseService;", "Ltech/thatgravyboat/jukebox/api/service/Service;", "Ltech/thatgravyboat/jukebox/api/state/RepeatState;", "repeat", "check", "Ltech/thatgravyboat/jukebox/api/state/State;", "state", "", "checkRepeatState", "(Ltech/thatgravyboat/jukebox/api/state/RepeatState;Ltech/thatgravyboat/jukebox/api/state/RepeatState;Ltech/thatgravyboat/jukebox/api/state/State;)Z", "T", "Ltech/thatgravyboat/jukebox/api/events/EventType;", "eventType", "Ltech/thatgravyboat/jukebox/api/events/EventHolder;", "getHolder", "(Ltech/thatgravyboat/jukebox/api/events/EventType;)Ltech/thatgravyboat/jukebox/api/events/EventHolder;", "getState", "()Ltech/thatgravyboat/jukebox/api/state/State;", "", "error", "", "onError", "(Ljava/lang/String;)V", "onSuccess", "(Ltech/thatgravyboat/jukebox/api/state/State;)V", "onUnauthorized", "()V", "", "volume", "notify", "onVolumeChange", "(IZ)V", "Lkotlin/Function1;", "listener", "registerListener", "(Ltech/thatgravyboat/jukebox/api/events/EventType;Lkotlin/jvm/functions/Function1;)V", "unregisterListener", "errorCount", "I", "lastState", "Ltech/thatgravyboat/jukebox/api/state/State;", "", "listeners", "Ljava/util/Map;", "<init>", "jukebox"})
public abstract class BaseService
implements Service {
    @NotNull
    private final Map<EventType<?>, EventHolder<?>> listeners = new LinkedHashMap();
    @Nullable
    private State lastState;
    private int errorCount;

    @NotNull
    public final <T> EventHolder<T> getHolder(@NotNull EventType<T> eventType) {
        EventHolder<Object> eventHolder;
        Intrinsics.checkNotNullParameter(eventType, (String)"eventType");
        Map<EventType<?>, EventHolder<?>> $this$getOrPut$iv = this.listeners;
        boolean $i$f$getOrPut = false;
        EventHolder<?> value$iv = $this$getOrPut$iv.get(eventType);
        if (value$iv == null) {
            boolean bl = false;
            EventHolder<T> answer$iv = eventType.createHolder();
            $this$getOrPut$iv.put(eventType, answer$iv);
            eventHolder = answer$iv;
        } else {
            eventHolder = value$iv;
        }
        Intrinsics.checkNotNull(eventHolder, (String)"null cannot be cast to non-null type tech.thatgravyboat.jukebox.api.events.EventHolder<T of tech.thatgravyboat.jukebox.api.service.BaseService.getHolder>");
        return eventHolder;
    }

    public final <T> void registerListener(@NotNull EventType<T> eventType, @NotNull Function1<? super T, Unit> listener) {
        Intrinsics.checkNotNullParameter(eventType, (String)"eventType");
        Intrinsics.checkNotNullParameter(listener, (String)"listener");
        this.getHolder(eventType).add(listener);
    }

    public final <T> void unregisterListener(@NotNull EventType<T> eventType, @NotNull Function1<? super T, Unit> listener) {
        Intrinsics.checkNotNullParameter(eventType, (String)"eventType");
        Intrinsics.checkNotNullParameter(listener, (String)"listener");
        this.getHolder(eventType).remove(listener);
    }

    public final void onError(@Nullable String error) {
        if (this.errorCount == 10) {
            this.stop();
            this.getHolder(EventType.Companion.getSERVICE_ENDED()).fire(new ServiceEndedEvent(error));
        } else {
            int n = this.errorCount;
            this.errorCount = n + 1;
            this.getHolder(EventType.Companion.getSERVICE_ERROR()).fire(new ServiceErrorEvent(error));
        }
    }

    public final void onSuccess(@NotNull State state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        this.errorCount = 0;
        this.getHolder(EventType.Companion.getUPDATE()).fire(new UpdateEvent(state));
        State state2 = this.lastState;
        if (!(state2 != null ? state2.isSame(state) : false)) {
            this.getHolder(EventType.Companion.getSONG_CHANGE()).fire(new SongChangeEvent(state));
        }
        this.lastState = state;
    }

    public final void onUnauthorized() {
        this.getHolder(EventType.Companion.getSERVICE_UNAUTHORIZED()).fire(new ServiceUnauthorizedEvent());
        this.onError("Unauthorized");
    }

    public final void onVolumeChange(int volume, boolean notify) {
        this.getHolder(EventType.Companion.getVOLUME_CHANGE()).fire(new VolumeChangeEvent(volume, notify));
    }

    @Override
    @Nullable
    public State getState() {
        return this.lastState;
    }

    protected final boolean checkRepeatState(@NotNull RepeatState repeat, @NotNull RepeatState check, @NotNull State state) {
        Intrinsics.checkNotNullParameter((Object)((Object)repeat), (String)"repeat");
        Intrinsics.checkNotNullParameter((Object)((Object)check), (String)"check");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return check == repeat && state.getPlayer().getRepeat() != repeat;
    }

    @Override
    @NotNull
    public ServiceType getServiceType() {
        return Service.DefaultImpls.getServiceType(this);
    }

    @Override
    public boolean next() {
        return Service.DefaultImpls.next(this);
    }

    @Override
    public boolean prev() {
        return Service.DefaultImpls.prev(this);
    }
}

