/*
 * Decompiled with CFR 0.152.
 */
package tech.thatgravyboat.craftify.ui.constraints;

import gg.essential.elementa.UIComponent;
import gg.essential.elementa.constraints.ConstraintType;
import gg.essential.elementa.constraints.resolution.ConstraintVisitor;
import gg.essential.elementa.font.DefaultFonts;
import gg.essential.elementa.font.ElementaFonts;
import gg.essential.elementa.font.FontProvider;
import gg.essential.universal.UMatrixStack;
import java.awt.Color;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tech.thatgravyboat.craftify.themes.ThemeConfig;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0011\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u00100\u001a\u00020\u0004\u00a2\u0006\u0004\b8\u00109JY\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\r2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0006H\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012JQ\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\r2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0006H\u0017\u00a2\u0006\u0004\b\u0011\u0010\u0013J\u000f\u0010\u0014\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u000f\u0010\u0016\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u0016\u0010\u0015J\u000f\u0010\u0017\u001a\u00020\u0001H\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u000f\u0010\u0019\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u0019\u0010\u0015J\u001f\u0010\u001b\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u001f\u0010\u001d\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u001d\u0010\u001cJ\u001f\u0010\"\u001a\u00020\u00102\u0006\u0010\u001f\u001a\u00020\u001e2\u0006\u0010!\u001a\u00020 H\u0016\u00a2\u0006\u0004\b\"\u0010#R\"\u0010$\u001a\u00020\u00018\u0016@\u0016X\u0096\u000e\u00a2\u0006\u0012\n\u0004\b$\u0010%\u001a\u0004\b&\u0010\u0018\"\u0004\b'\u0010(R$\u0010*\u001a\u0004\u0018\u00010)8\u0016@\u0016X\u0096\u000e\u00a2\u0006\u0012\n\u0004\b*\u0010+\u001a\u0004\b,\u0010-\"\u0004\b.\u0010/R\u0014\u00100\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b0\u00101R\"\u00102\u001a\u00020\r8\u0016@\u0016X\u0096\u000e\u00a2\u0006\u0012\n\u0004\b2\u00103\u001a\u0004\b4\u00105\"\u0004\b6\u00107\u00a8\u0006:"}, d2={"Ltech/thatgravyboat/craftify/ui/constraints/ThemeFontProvider;", "Lgg/essential/elementa/font/FontProvider;", "Lgg/essential/universal/UMatrixStack;", "matrixStack", "", "string", "Ljava/awt/Color;", "color", "", "x", "y", "originalPointSize", "scale", "", "shadow", "shadowColor", "", "drawString", "(Lgg/essential/universal/UMatrixStack;Ljava/lang/String;Ljava/awt/Color;FFFFZLjava/awt/Color;)V", "(Ljava/lang/String;Ljava/awt/Color;FFFFZLjava/awt/Color;)V", "getBaseLineHeight", "()F", "getBelowLineHeight", "getFont", "()Lgg/essential/elementa/font/FontProvider;", "getShadowHeight", "pointSize", "getStringHeight", "(Ljava/lang/String;F)F", "getStringWidth", "Lgg/essential/elementa/constraints/resolution/ConstraintVisitor;", "visitor", "Lgg/essential/elementa/constraints/ConstraintType;", "type", "visitImpl", "(Lgg/essential/elementa/constraints/resolution/ConstraintVisitor;Lgg/essential/elementa/constraints/ConstraintType;)V", "cachedValue", "Lgg/essential/elementa/font/FontProvider;", "getCachedValue", "setCachedValue", "(Lgg/essential/elementa/font/FontProvider;)V", "Lgg/essential/elementa/UIComponent;", "constrainTo", "Lgg/essential/elementa/UIComponent;", "getConstrainTo", "()Lgg/essential/elementa/UIComponent;", "setConstrainTo", "(Lgg/essential/elementa/UIComponent;)V", "id", "Ljava/lang/String;", "recalculate", "Z", "getRecalculate", "()Z", "setRecalculate", "(Z)V", "<init>", "(Ljava/lang/String;)V", "craftify"})
public final class ThemeFontProvider
implements FontProvider {
    @NotNull
    private final String id;
    @NotNull
    private FontProvider cachedValue;
    private boolean recalculate;
    @Nullable
    private UIComponent constrainTo;

    public ThemeFontProvider(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        this.id = id;
        this.cachedValue = this;
    }

    @NotNull
    public FontProvider getCachedValue() {
        return this.cachedValue;
    }

    public void setCachedValue(@NotNull FontProvider fontProvider) {
        Intrinsics.checkNotNullParameter((Object)fontProvider, (String)"<set-?>");
        this.cachedValue = fontProvider;
    }

    public boolean getRecalculate() {
        return this.recalculate;
    }

    public void setRecalculate(boolean bl) {
        this.recalculate = bl;
    }

    @Nullable
    public UIComponent getConstrainTo() {
        return this.constrainTo;
    }

    public void setConstrainTo(@Nullable UIComponent uIComponent) {
        this.constrainTo = uIComponent;
    }

    private final FontProvider getFont() {
        int font = switch (this.id) {
            case "artist" -> ThemeConfig.INSTANCE.getArtistFont();
            case "title" -> ThemeConfig.INSTANCE.getTitleFont();
            case "progress" -> ThemeConfig.INSTANCE.getProgressFont();
            default -> 0;
        };
        return switch (font) {
            case 1 -> (FontProvider)ElementaFonts.getMINECRAFT();
            case 2 -> (FontProvider)ElementaFonts.getMINECRAFT_BOLD();
            case 3 -> (FontProvider)ElementaFonts.getJETBRAINS_MONO();
            case 4 -> (FontProvider)ElementaFonts.getMINECRAFT_FIVE();
            default -> DefaultFonts.getVANILLA_FONT_RENDERER();
        };
    }

    public float getBaseLineHeight() {
        return this.getFont().getBaseLineHeight();
    }

    public float getBelowLineHeight() {
        return this.getFont().getBelowLineHeight();
    }

    public float getShadowHeight() {
        return this.getFont().getShadowHeight();
    }

    public float getStringHeight(@NotNull String string, float pointSize) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        return this.getFont().getStringHeight(string, pointSize);
    }

    public float getStringWidth(@NotNull String string, float pointSize) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        return this.getFont().getStringWidth(string, pointSize);
    }

    public void drawString(@NotNull UMatrixStack matrixStack, @NotNull String string, @NotNull Color color, float x, float y, float originalPointSize, float scale, boolean shadow, @Nullable Color shadowColor) {
        Intrinsics.checkNotNullParameter((Object)matrixStack, (String)"matrixStack");
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        this.getFont().drawString(matrixStack, string, color, x, y, originalPointSize, scale, shadow, shadowColor);
    }

    @Deprecated(message="For 1.17 this method requires you pass a UMatrixStack as the first argument.\n\nIf you are currently extending this method, you should instead extend the method with the added argument.\nNote however for this to be non-breaking, your parent class needs to transition before you do.\n\nIf you are calling this method and you cannot guarantee that your target class has been fully updated (such as when\ncalling an open method on an open class), you should instead call the method with the \"Compat\" suffix, which will\ncall both methods, the new and the deprecated one.\nIf you are sure that your target class has been updated (such as when calling the super method), you should\n(for super calls you must!) instead just call the method with the original name and added argument.", replaceWith=@ReplaceWith(expression="drawString(matrixStack, string, color, x, y, originalPointSize, scale, shadow, shadowColor)", imports={}))
    public void drawString(@NotNull String string, @NotNull Color color, float x, float y, float originalPointSize, float scale, boolean shadow, @Nullable Color shadowColor) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        this.getFont().drawString(string, color, x, y, originalPointSize, scale, shadow, shadowColor);
    }

    public void visitImpl(@NotNull ConstraintVisitor visitor, @NotNull ConstraintType type) {
        Intrinsics.checkNotNullParameter((Object)visitor, (String)"visitor");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        this.getFont().visitImpl(visitor, type);
    }
}

