/*
 * Decompiled with CFR 0.152.
 */
package tech.thatgravyboat.craftify.ui;

import gg.essential.elementa.UIComponent;
import gg.essential.elementa.components.Window;
import gg.essential.elementa.dsl.UtilitiesKt;
import gg.essential.elementa.state.BasicState;
import gg.essential.elementa.state.MappedState;
import gg.essential.universal.UGraphics;
import gg.essential.universal.UMatrixStack;
import java.awt.Color;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import tech.thatgravyboat.craftify.ui.UITextMarquee;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0016\u0018\u00002\u00020\u0001B\u0019\u0012\b\b\u0002\u0010\u001a\u001a\u00020\u0019\u0012\u0006\u0010\f\u001a\u00020\t\u00a2\u0006\u0004\b$\u0010%J\u000f\u0010\u0003\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0017\u0010\u0007\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0005H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000f\u0010\n\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\r\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\r\u0010\u000eJ\u000f\u0010\u0010\u001a\u00020\u000fH\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0017\u0010\u0012\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0015\u0010\u0014\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\t\u00a2\u0006\u0004\b\u0014\u0010\u0015R\u0016\u0010\u0017\u001a\u00020\u00168\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0017\u0010\u0018R\u0014\u0010\u001a\u001a\u00020\u00198\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001a\u0010\u001bR\u0016\u0010\u001c\u001a\u00020\t8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001c\u0010\u001dR\u0016\u0010\u001e\u001a\u00020\u000f8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001e\u0010\u001fR \u0010!\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0 8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b!\u0010\"R\u0016\u0010#\u001a\u00020\u00168\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b#\u0010\u0018\u00a8\u0006&"}, d2={"Ltech/thatgravyboat/craftify/ui/UITextMarquee;", "Lgg/essential/elementa/UIComponent;", "", "animationFrame", "()V", "Lgg/essential/universal/UMatrixStack;", "matrixStack", "draw", "(Lgg/essential/universal/UMatrixStack;)V", "", "getText", "()Ljava/lang/String;", "text", "setText", "(Ljava/lang/String;)Ltech/thatgravyboat/craftify/ui/UITextMarquee;", "", "shouldUpdate", "()Z", "splitText", "(Ljava/lang/String;)Ljava/lang/String;", "updateText", "(Ljava/lang/String;)V", "", "elapsedFrames", "I", "", "frames", "F", "ogText", "Ljava/lang/String;", "shouldAnimate", "Z", "Lgg/essential/elementa/state/MappedState;", "textState", "Lgg/essential/elementa/state/MappedState;", "totalFrames", "<init>", "(FLjava/lang/String;)V", "craftify"})
public class UITextMarquee
extends UIComponent {
    private final float frames;
    @NotNull
    private final MappedState<String, String> textState;
    @NotNull
    private String ogText;
    private boolean shouldAnimate;
    private int elapsedFrames;
    private int totalFrames;

    public UITextMarquee(float frames, @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.frames = frames;
        this.textState = new BasicState((Object)(text + "   ")).map((Function1)textState.1.INSTANCE);
        this.ogText = text;
    }

    public /* synthetic */ UITextMarquee(float f, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            f = 0.5f;
        }
        this(f, string);
    }

    private final String getText() {
        return (String)this.textState.get();
    }

    private final UITextMarquee setText(String text) {
        UITextMarquee uITextMarquee;
        UITextMarquee $this$setText_u24lambda_u2d0 = uITextMarquee = this;
        boolean bl = false;
        $this$setText_u24lambda_u2d0.textState.set((Object)text);
        return uITextMarquee;
    }

    private final boolean shouldUpdate() {
        return this.elapsedFrames >= this.totalFrames;
    }

    public void animationFrame() {
        super.animationFrame();
        if (this.shouldAnimate) {
            int n = this.elapsedFrames;
            this.elapsedFrames = n + 1;
            if (this.shouldUpdate()) {
                String newText = this.getText();
                this.setText(StringsKt.drop((String)newText, (int)1) + StringsKt.take((String)newText, (int)1));
                this.elapsedFrames = 0;
                this.totalFrames = (int)(this.frames * (float)Window.Companion.of((UIComponent)this).getAnimationFPS());
            }
        }
    }

    public void draw(@NotNull UMatrixStack matrixStack) {
        Intrinsics.checkNotNullParameter((Object)matrixStack, (String)"matrixStack");
        String text = (String)this.textState.get();
        if (((CharSequence)text).length() == 0) {
            return;
        }
        this.beforeDraw(matrixStack);
        float x = this.getLeft();
        float y = this.getTop();
        Color color = this.getColor();
        if (color.getAlpha() <= 10) {
            super.draw(matrixStack);
            return;
        }
        UGraphics.enableBlend();
        String formattedText = this.splitText(text);
        this.getFontProvider().drawString(matrixStack, formattedText, color, x, y, 10.0f, 1.0f, true, null);
        super.draw(matrixStack);
    }

    public final void updateText(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        if (!Intrinsics.areEqual((Object)text, (Object)this.ogText)) {
            this.setText(text + "   ");
            this.ogText = text;
        }
        this.shouldAnimate = UtilitiesKt.width$default((String)text, (float)0.0f, null, (int)3, null) > this.getWidth();
    }

    private final String splitText(String text) {
        int n;
        float charWidth;
        if (UtilitiesKt.width$default((String)text, (float)0.0f, null, (int)3, null) <= this.getWidth()) {
            return text;
        }
        double currWidth = 0.0;
        int index = 0;
        while (index < text.length() && !(currWidth + (double)(charWidth = UtilitiesKt.width$default((char)text.charAt(index), (float)0.0f, (int)1, null)) > (double)this.getWidth())) {
            currWidth += (double)charWidth;
            n = index;
            index = n + 1;
        }
        String string = text;
        n = 0;
        String string2 = string.substring(n, index);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        return string2;
    }
}

