/*
 * Decompiled with CFR 0.152.
 */
package tech.thatgravyboat.craftify.ssl;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import tech.thatgravyboat.craftify.ssl.LambdaExceptionUtils;

public class FixSSL {
    public static SSLContext context = null;

    public static void fixup() {
        try {
            KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            Path ksPath = Paths.get(System.getProperty("java.home"), "lib", "security", "cacerts");
            keyStore.load(Files.newInputStream(ksPath, new OpenOption[0]), "changeit".toCharArray());
            Map<String, Certificate> jdkTrustStore = Collections.list(keyStore.aliases()).stream().collect(Collectors.toMap(a -> a, LambdaExceptionUtils.rethrowFunction(keyStore::getCertificate)));
            KeyStore leKS = KeyStore.getInstance(KeyStore.getDefaultType());
            InputStream leKSFile = FixSSL.class.getResourceAsStream("/lekeystore.jks");
            leKS.load(leKSFile, "supersecretpassword".toCharArray());
            Map<String, Certificate> leTrustStore = Collections.list(leKS.aliases()).stream().collect(Collectors.toMap(a -> a, LambdaExceptionUtils.rethrowFunction(leKS::getCertificate)));
            KeyStore mergedTrustStore = KeyStore.getInstance(KeyStore.getDefaultType());
            mergedTrustStore.load(null, new char[0]);
            jdkTrustStore.forEach(LambdaExceptionUtils.rethrowBiConsumer(mergedTrustStore::setCertificateEntry));
            leTrustStore.forEach(LambdaExceptionUtils.rethrowBiConsumer(mergedTrustStore::setCertificateEntry));
            TrustManagerFactory instance = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            instance.init(mergedTrustStore);
            SSLContext tls2 = SSLContext.getInstance("TLS");
            tls2.init(null, instance.getTrustManagers(), null);
            context = tls2;
            System.out.println("[Craftify]: Added Lets Encrypt root certificates as additional trust");
        }
        catch (IOException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            System.out.println("[Craftify]: Failed to load lets encrypt certificate. Expect problems");
            e.printStackTrace();
        }
    }
}

