/*
 * Decompiled with CFR 0.152.
 */
package tech.thatgravyboat.craftify.services;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import gg.essential.universal.ChatColor;
import gg.essential.universal.UChat;
import gg.essential.universal.wrappers.UPlayer;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.NotNull;
import tech.thatgravyboat.craftify.config.Config;
import tech.thatgravyboat.craftify.services.ServiceHelper;
import tech.thatgravyboat.craftify.utils.EssentialUtils;
import tech.thatgravyboat.craftify.utils.ServerAddonHelper;
import tech.thatgravyboat.craftify.utils.Utils;
import tech.thatgravyboat.jukebox.api.events.EventType;
import tech.thatgravyboat.jukebox.api.events.callbacks.ServiceUnauthorizedEvent;
import tech.thatgravyboat.jukebox.api.events.callbacks.SongChangeEvent;
import tech.thatgravyboat.jukebox.api.events.callbacks.UpdateEvent;
import tech.thatgravyboat.jukebox.api.events.callbacks.VolumeChangeEvent;
import tech.thatgravyboat.jukebox.api.service.BaseService;
import tech.thatgravyboat.jukebox.impl.spotify.SpotifyService;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b,\u0010-J\u001d\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0015\u0010\n\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\u000e\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0011\u0010\u0010\u001a\u00020\u0005*\u00020\b\u00a2\u0006\u0004\b\u0010\u0010\u000bJ\u001d\u0010\u0013\u001a\u0004\u0018\u00010\u0002*\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0011\u0010\u0015\u001a\u00020\u0005*\u00020\b\u00a2\u0006\u0004\b\u0015\u0010\u000bR\u0014\u0010\u0016\u001a\u00020\u00028\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0019\u001a\u00020\u00188\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0019\u0010\u001aR\u001a\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00020\u001b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001c\u0010\u001dR\u0014\u0010\u001f\u001a\u00020\u001e8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001f\u0010 R\u0016\u0010\"\u001a\u00020!8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\"\u0010#R \u0010&\u001a\u000e\u0012\u0004\u0012\u00020%\u0012\u0004\u0012\u00020\u00050$8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b&\u0010'R \u0010)\u001a\u000e\u0012\u0004\u0012\u00020(\u0012\u0004\u0012\u00020\u00050$8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b)\u0010'R \u0010+\u001a\u000e\u0012\u0004\u0012\u00020*\u0012\u0004\u0012\u00020\u00050$8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b+\u0010'\u00a8\u0006."}, d2={"Ltech/thatgravyboat/craftify/services/ServiceHelper;", "", "", "type", "code", "", "loginToSpotify", "(Ljava/lang/String;Ljava/lang/String;)V", "Ltech/thatgravyboat/jukebox/api/service/BaseService;", "service", "setupSpotify", "(Ltech/thatgravyboat/jukebox/api/service/BaseService;)V", "", "volume", "showVolumeNotification", "(I)V", "close", "Lcom/google/gson/JsonObject;", "key", "getOrNull", "(Lcom/google/gson/JsonObject;Ljava/lang/String;)Ljava/lang/String;", "setup", "AUTH_API", "Ljava/lang/String;", "Lcom/google/gson/Gson;", "GSON", "Lcom/google/gson/Gson;", "", "badTokens", "Ljava/util/Set;", "", "essentialPackets", "Z", "", "lastFailedLogin", "J", "Lkotlin/Function1;", "Ltech/thatgravyboat/jukebox/api/events/callbacks/SongChangeEvent;", "songChange", "Lkotlin/jvm/functions/Function1;", "Ltech/thatgravyboat/jukebox/api/events/callbacks/UpdateEvent;", "songUpdate", "Ltech/thatgravyboat/jukebox/api/events/callbacks/VolumeChangeEvent;", "volumeChange", "<init>", "()V", "craftify"})
public final class ServiceHelper {
    @NotNull
    public static final ServiceHelper INSTANCE = new ServiceHelper();
    @NotNull
    private static final String AUTH_API = "https://craftify.thatgravyboat.tech/api/v1/public/auth";
    @NotNull
    private static final Set<String> badTokens = new LinkedHashSet();
    private static final boolean essentialPackets = Intrinsics.areEqual((Object)System.getProperty("craftify.essentialFakePackets", "false"), (Object)"true");
    @NotNull
    private static final Gson GSON = new Gson();
    private static long lastFailedLogin;
    @NotNull
    private static final Function1<UpdateEvent, Unit> songUpdate;
    @NotNull
    private static final Function1<SongChangeEvent, Unit> songChange;
    @NotNull
    private static final Function1<VolumeChangeEvent, Unit> volumeChange;

    private ServiceHelper() {
    }

    public final void setup(@NotNull BaseService $this$setup) {
        Intrinsics.checkNotNullParameter((Object)$this$setup, (String)"<this>");
        $this$setup.registerListener(EventType.Companion.getUPDATE(), songUpdate);
        $this$setup.registerListener(EventType.Companion.getSONG_CHANGE(), songChange);
        $this$setup.registerListener(EventType.Companion.getVOLUME_CHANGE(), volumeChange);
        if (Config.INSTANCE.getSendPackets()) {
            ServerAddonHelper.INSTANCE.setupServerAddon($this$setup);
        }
        if (essentialPackets && Utils.INSTANCE.isEssentialInstalled()) {
            EssentialUtils.INSTANCE.setupServerAddon($this$setup);
        }
    }

    public final void close(@NotNull BaseService $this$close) {
        Intrinsics.checkNotNullParameter((Object)$this$close, (String)"<this>");
        $this$close.unregisterListener(EventType.Companion.getUPDATE(), songUpdate);
        $this$close.unregisterListener(EventType.Companion.getSONG_CHANGE(), songChange);
        $this$close.unregisterListener(EventType.Companion.getVOLUME_CHANGE(), volumeChange);
        if (Config.INSTANCE.getSendPackets()) {
            ServerAddonHelper.INSTANCE.closeServerAddon($this$close);
        }
        if (essentialPackets && Utils.INSTANCE.isEssentialInstalled()) {
            EssentialUtils.INSTANCE.closeServerAddon($this$close);
        }
    }

    public final void setupSpotify(@NotNull BaseService service) {
        Intrinsics.checkNotNullParameter((Object)service, (String)"service");
        if (service instanceof SpotifyService) {
            service.registerListener(EventType.Companion.getSERVICE_UNAUTHORIZED(), (Function1)new Function1<ServiceUnauthorizedEvent, Unit>(service){
                final /* synthetic */ BaseService $service;
                {
                    this.$service = $service;
                    super(1);
                }

                public final void invoke(@NotNull ServiceUnauthorizedEvent it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    String string = Config.INSTANCE.optionalRefresh();
                    if (string != null) {
                        String string2 = string;
                        BaseService baseService = this.$service;
                        String it2 = string2;
                        boolean bl = false;
                        ServiceHelper.INSTANCE.loginToSpotify("refresh", it2);
                        ((SpotifyService)baseService).setToken(Config.INSTANCE.getToken());
                        baseService.restart();
                    }
                }
            });
        }
    }

    public final void loginToSpotify(@NotNull String type, @NotNull String code) {
        String reason;
        boolean failed;
        block24: {
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            Intrinsics.checkNotNullParameter((Object)code, (String)"code");
            if (System.currentTimeMillis() - lastFailedLogin < 10000L) {
                return;
            }
            if (badTokens.contains(code)) {
                return;
            }
            failed = false;
            reason = null;
            reason = "Unknown error";
            try {
                JsonObject jsonObject;
                Utils.Response response2 = Utils.login$default(Utils.INSTANCE, "https://craftify.thatgravyboat.tech/api/v1/public/auth?type=" + type + "&code=" + code, null, null, null, 14, null);
                if (response2 == null) break block24;
                Utils.Response response3 = response2;
                boolean bl = false;
                try {
                    jsonObject = (JsonObject)GSON.fromJson(IOUtils.toString((InputStream)response3.getInputStream(), (Charset)StandardCharsets.UTF_8), JsonObject.class);
                }
                catch (Exception e) {
                    jsonObject = null;
                }
                JsonObject data2 = jsonObject;
                if (response3.success()) {
                    boolean bl2;
                    JsonObject jsonObject2 = data2;
                    if (jsonObject2 == null) {
                        bl2 = false;
                    } else {
                        JsonElement jsonElement = jsonObject2.get("success");
                        bl2 = jsonElement == null ? false : jsonElement.getAsBoolean();
                    }
                    if (bl2) {
                        String refreshToken = INSTANCE.getOrNull(data2, "refresh_token");
                        String accessToken = INSTANCE.getOrNull(data2, "access_token");
                        if (accessToken != null) {
                            String string;
                            Config.INSTANCE.setToken(accessToken);
                            if (!Intrinsics.areEqual((Object)type, (Object)"refresh") && refreshToken == null) {
                                string = "";
                            } else {
                                string = refreshToken;
                                if (string == null) {
                                    string = Config.INSTANCE.getRefreshToken();
                                }
                            }
                            Config.INSTANCE.setRefreshToken(string);
                            Config.INSTANCE.setMusicService("spotify");
                            Config.INSTANCE.markDirty();
                            Config.INSTANCE.writeData();
                        } else {
                            failed = true;
                        }
                    } else {
                        failed = true;
                    }
                } else {
                    failed = true;
                }
                if (failed) {
                    String string;
                    JsonObject jsonObject3 = data2;
                    if (jsonObject3 == null) {
                        string = "Unknown error";
                    } else {
                        string = INSTANCE.getOrNull(jsonObject3, "reason");
                        if (string == null) {
                            string = "Unknown error";
                        }
                    }
                    reason = string;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                failed = true;
                reason = "Check the console for more information";
            }
        }
        if (failed && lastFailedLogin < System.currentTimeMillis() - (long)600000) {
            if (UPlayer.hasPlayer()) {
                UChat.chat((Object)(ChatColor.RED + "Craftify > " + ChatColor.GRAY + "Failed to login to Spotify: " + reason + ", please try logging in again."));
            } else {
                System.out.println((Object)("Failed to login to Spotify: " + reason + ", please try logging in again."));
            }
            lastFailedLogin = System.currentTimeMillis();
            badTokens.add(code);
        }
    }

    private final String getOrNull(JsonObject $this$getOrNull, String key) {
        return $this$getOrNull.has(key) ? $this$getOrNull.get(key).getAsString() : null;
    }

    private final void showVolumeNotification(int volume) {
        String image = volume <= 0 ? "https://i.imgur.com/v2a3Z8n.png" : (volume <= 30 ? "https://i.imgur.com/8L4av1O.png" : (volume <= 70 ? "https://i.imgur.com/tGJKxRr.png" : "https://i.imgur.com/1Ay43hi.png"));
        EssentialUtils.sendNotification$default(EssentialUtils.INSTANCE, "Craftify", "The volume has been set to " + volume + "%", image, false, 8, null);
    }

    public static final /* synthetic */ void access$showVolumeNotification(ServiceHelper $this, int volume) {
        $this.showVolumeNotification(volume);
    }

    static {
        songUpdate = songUpdate.1.INSTANCE;
        songChange = songChange.1.INSTANCE;
        volumeChange = volumeChange.1.INSTANCE;
    }
}

