/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.websocket.internals;

import io.ktor.util.cio.ByteBufferPoolKt;
import io.ktor.utils.io.core.BytePacketBuilder;
import io.ktor.utils.io.core.ByteReadPacket;
import io.ktor.utils.io.core.OutputArraysJVMKt;
import io.ktor.utils.io.core.StringsKt;
import io.ktor.utils.io.pool.ObjectPool;
import io.ktor.websocket.internals.BytePacketUtilsKt;
import java.nio.ByteBuffer;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u001a\u001b\u0010\u0003\u001a\u00020\u0001*\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u0001H\u0000\u00a2\u0006\u0004\b\u0003\u0010\u0004\u001a+\u0010\f\u001a\u00020\u000b*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\f\u0010\r\u001a\u001b\u0010\u000f\u001a\u00020\u0001*\u00020\u000e2\u0006\u0010\u0002\u001a\u00020\u0001H\u0000\u00a2\u0006\u0004\b\u000f\u0010\u0010\"\u0014\u0010\u0011\u001a\u00020\u00018\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0011\u0010\u0012\"\u0014\u0010\u0013\u001a\u00020\u00018\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0013\u0010\u0012\u00a8\u0006\u0014"}, d2={"Ljava/util/zip/Deflater;", "", "data", "deflateFully", "(Ljava/util/zip/Deflater;[B)[B", "Lio/ktor/utils/io/core/BytePacketBuilder;", "deflater", "Ljava/nio/ByteBuffer;", "buffer", "", "flush", "", "deflateTo", "(Lio/ktor/utils/io/core/BytePacketBuilder;Ljava/util/zip/Deflater;Ljava/nio/ByteBuffer;Z)I", "Ljava/util/zip/Inflater;", "inflateFully", "(Ljava/util/zip/Inflater;[B)[B", "EMPTY_CHUNK", "[B", "PADDED_EMPTY_CHUNK", "ktor-websockets"})
public final class DeflaterUtilsKt {
    @NotNull
    private static final byte[] PADDED_EMPTY_CHUNK;
    @NotNull
    private static final byte[] EMPTY_CHUNK;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final byte[] deflateFully(@NotNull Deflater $this$deflateFully, @NotNull byte[] data2) {
        ByteReadPacket byteReadPacket;
        ByteReadPacket byteReadPacket2;
        Intrinsics.checkNotNullParameter((Object)$this$deflateFully, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        $this$deflateFully.setInput(data2);
        boolean $i$f$buildPacket = false;
        BytePacketBuilder builder$iv = new BytePacketBuilder(null, 1, null);
        try {
            BytePacketBuilder $this$deflateFully_u24lambda_u2d1 = builder$iv;
            boolean bl = false;
            ObjectPool<ByteBuffer> $this$useInstance$iv = ByteBufferPoolKt.getKtorDefaultPool();
            boolean $i$f$useInstance = false;
            ByteBuffer instance$iv = $this$useInstance$iv.borrow();
            try {
                ByteBuffer buffer = instance$iv;
                boolean bl2 = false;
                while (!$this$deflateFully.needsInput()) {
                    DeflaterUtilsKt.deflateTo($this$deflateFully_u24lambda_u2d1, $this$deflateFully, buffer, false);
                }
                while (DeflaterUtilsKt.deflateTo($this$deflateFully_u24lambda_u2d1, $this$deflateFully, buffer, true) != 0) {
                }
                Unit unit = Unit.INSTANCE;
            }
            finally {
                $this$useInstance$iv.recycle(instance$iv);
            }
            byteReadPacket2 = builder$iv.build();
        }
        catch (Throwable t$iv) {
            builder$iv.release();
            throw t$iv;
        }
        ByteReadPacket deflatedBytes = byteReadPacket2;
        if (BytePacketUtilsKt.endsWith(deflatedBytes, PADDED_EMPTY_CHUNK)) {
            byte[] it = $i$f$buildPacket = StringsKt.readBytes(deflatedBytes, (int)deflatedBytes.getRemaining() - EMPTY_CHUNK.length);
            boolean bl = false;
            deflatedBytes.release();
            return $i$f$buildPacket;
        }
        $i$f$buildPacket = false;
        builder$iv = new BytePacketBuilder(null, 1, null);
        try {
            BytePacketBuilder $this$deflateFully_u24lambda_u2d3 = builder$iv;
            boolean bl = false;
            $this$deflateFully_u24lambda_u2d3.writePacket(deflatedBytes);
            $this$deflateFully_u24lambda_u2d3.writeByte((byte)0);
            byteReadPacket = builder$iv.build();
        }
        catch (Throwable t$iv) {
            builder$iv.release();
            throw t$iv;
        }
        return StringsKt.readBytes$default(byteReadPacket, 0, 1, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final byte[] inflateFully(@NotNull Inflater $this$inflateFully, @NotNull byte[] data2) {
        ByteReadPacket byteReadPacket;
        Intrinsics.checkNotNullParameter((Object)$this$inflateFully, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        byte[] dataToInflate = ArraysKt.plus((byte[])data2, (byte[])EMPTY_CHUNK);
        $this$inflateFully.setInput(dataToInflate);
        boolean $i$f$buildPacket = false;
        BytePacketBuilder builder$iv = new BytePacketBuilder(null, 1, null);
        try {
            BytePacketBuilder $this$inflateFully_u24lambda_u2d5 = builder$iv;
            boolean bl = false;
            ObjectPool<ByteBuffer> $this$useInstance$iv = ByteBufferPoolKt.getKtorDefaultPool();
            boolean $i$f$useInstance = false;
            ByteBuffer instance$iv = $this$useInstance$iv.borrow();
            try {
                ByteBuffer buffer = instance$iv;
                boolean bl2 = false;
                long limit = (long)dataToInflate.length + $this$inflateFully.getBytesRead();
                while ($this$inflateFully.getBytesRead() < limit) {
                    buffer.clear();
                    int inflated = $this$inflateFully.inflate(buffer.array(), buffer.position(), buffer.limit());
                    buffer.position(buffer.position() + inflated);
                    buffer.flip();
                    OutputArraysJVMKt.writeFully($this$inflateFully_u24lambda_u2d5, buffer);
                }
                Unit unit = Unit.INSTANCE;
            }
            finally {
                $this$useInstance$iv.recycle(instance$iv);
            }
            byteReadPacket = builder$iv.build();
        }
        catch (Throwable t$iv) {
            builder$iv.release();
            throw t$iv;
        }
        ByteReadPacket packet2 = byteReadPacket;
        return StringsKt.readBytes$default(packet2, 0, 1, null);
    }

    private static final int deflateTo(BytePacketBuilder $this$deflateTo, Deflater deflater, ByteBuffer buffer, boolean flush2) {
        int deflated2;
        buffer.clear();
        int n = deflated2 = flush2 ? deflater.deflate(buffer.array(), buffer.position(), buffer.limit(), 2) : deflater.deflate(buffer.array(), buffer.position(), buffer.limit());
        if (deflated2 == 0) {
            return 0;
        }
        buffer.position(buffer.position() + deflated2);
        buffer.flip();
        OutputArraysJVMKt.writeFully($this$deflateTo, buffer);
        return deflated2;
    }

    static {
        byte[] byArray = new byte[]{0, 0, 0, -1, -1};
        PADDED_EMPTY_CHUNK = byArray;
        byArray = new byte[]{0, 0, -1, -1};
        EMPTY_CHUNK = byArray;
    }
}

