/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.websocket;

import io.ktor.util.NIOKt;
import io.ktor.websocket.Frame;
import io.ktor.websocket.UtilsKt;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.concurrent.ArrayBlockingQueue;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0016\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b+\u0010,J\u0015\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001f\u0010\n\u001a\u00020\t2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\f\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b\f\u0010\rJ\u0015\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u000e\u00a2\u0006\u0004\b\u0010\u0010\u0011J'\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0017\u0010\u0015\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0017\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u000eH\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0013\u0010\u0019\u001a\u00020\u000e*\u00020\u000eH\u0002\u00a2\u0006\u0004\b\u0019\u0010\u001aR\u0018\u0010\u001b\u001a\u0004\u0018\u00010\u000e8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001b\u0010\u001cR\u0011\u0010\u001f\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u0018\u0010 \u001a\u0004\u0018\u00010\u000e8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b \u0010\u001cR\"\u0010!\u001a\u00020\u00078\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b!\u0010\"\u001a\u0004\b#\u0010\u001e\"\u0004\b$\u0010\u0016R\u001a\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00020%8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b&\u0010'R\u0011\u0010*\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b(\u0010)\u00a8\u0006-"}, d2={"Lio/ktor/websocket/Serializer;", "", "Lio/ktor/websocket/Frame;", "f", "", "enqueue", "(Lio/ktor/websocket/Frame;)V", "", "mask", "", "estimateFrameHeaderSize", "(Lio/ktor/websocket/Frame;Z)I", "maskSize", "(Z)I", "Ljava/nio/ByteBuffer;", "buffer", "serialize", "(Ljava/nio/ByteBuffer;)V", "frame", "serializeHeader", "(Lio/ktor/websocket/Frame;Ljava/nio/ByteBuffer;Z)V", "setMaskBuffer", "(Z)V", "writeCurrentPayload", "(Ljava/nio/ByteBuffer;)Z", "maskedIfNeeded", "(Ljava/nio/ByteBuffer;)Ljava/nio/ByteBuffer;", "frameBody", "Ljava/nio/ByteBuffer;", "getHasOutstandingBytes", "()Z", "hasOutstandingBytes", "maskBuffer", "masking", "Z", "getMasking", "setMasking", "Ljava/util/concurrent/ArrayBlockingQueue;", "messages", "Ljava/util/concurrent/ArrayBlockingQueue;", "getRemainingCapacity", "()I", "remainingCapacity", "<init>", "()V", "ktor-websockets"})
public final class Serializer {
    @NotNull
    private final ArrayBlockingQueue<Frame> messages = new ArrayBlockingQueue(1024);
    @Nullable
    private ByteBuffer frameBody;
    @Nullable
    private ByteBuffer maskBuffer;
    private boolean masking;

    public final boolean getMasking() {
        return this.masking;
    }

    public final void setMasking(boolean bl) {
        this.masking = bl;
    }

    public final boolean getHasOutstandingBytes() {
        return !((Collection)this.messages).isEmpty() || this.frameBody != null;
    }

    public final int getRemainingCapacity() {
        return this.messages.remainingCapacity();
    }

    public final void enqueue(@NotNull Frame f) {
        Intrinsics.checkNotNullParameter((Object)f, (String)"f");
        this.messages.put(f);
    }

    public final void serialize(@NotNull ByteBuffer buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        while (this.writeCurrentPayload(buffer) && this.messages.peek() != null) {
            Frame frame;
            boolean mask = this.masking;
            this.setMaskBuffer(mask);
            int headerSize = this.estimateFrameHeaderSize(frame, mask);
            if (buffer.remaining() < headerSize) break;
            this.serializeHeader(frame, buffer, mask);
            this.messages.remove();
            this.frameBody = this.maskedIfNeeded(frame.getBuffer());
        }
    }

    private final void serializeHeader(Frame frame, ByteBuffer buffer, boolean mask) {
        block4: {
            ByteBuffer byteBuffer;
            boolean $this$flagAt$iv;
            int size2 = frame.getBuffer().remaining();
            int formattedLength = size2 < 126 ? size2 : (size2 <= 65535 ? 126 : 127);
            boolean bl = frame.getFin();
            int at$iv = 7;
            boolean $i$f$flagAt = false;
            int n = $this$flagAt$iv ? 1 << at$iv : 0;
            $this$flagAt$iv = frame.getRsv1();
            at$iv = 6;
            $i$f$flagAt = false;
            int n2 = n | ($this$flagAt$iv ? 1 << at$iv : 0);
            $this$flagAt$iv = frame.getRsv2();
            at$iv = 5;
            $i$f$flagAt = false;
            int n3 = n2 | ($this$flagAt$iv ? 1 << at$iv : 0);
            $this$flagAt$iv = frame.getRsv3();
            at$iv = 4;
            $i$f$flagAt = false;
            int header = n3 | ($this$flagAt$iv ? 1 << at$iv : 0) | frame.getFrameType().getOpcode();
            buffer.put((byte)header);
            $this$flagAt$iv = mask;
            at$iv = 7;
            $i$f$flagAt = false;
            buffer.put((byte)(($this$flagAt$iv ? 1 << at$iv : 0) | formattedLength));
            switch (formattedLength) {
                case 126: {
                    buffer.putShort((short)frame.getBuffer().remaining());
                    break;
                }
                case 127: {
                    buffer.putLong(frame.getBuffer().remaining());
                }
            }
            if ((byteBuffer = this.maskBuffer) == null || (byteBuffer = byteBuffer.duplicate()) == null) break block4;
            NIOKt.moveTo$default(byteBuffer, buffer, 0, 2, null);
        }
    }

    private final int estimateFrameHeaderSize(Frame f, boolean mask) {
        int size2 = f.getBuffer().remaining();
        return (size2 < 126 ? 2 : (size2 <= Short.MAX_VALUE ? 4 : 10)) + this.maskSize(mask);
    }

    private final boolean writeCurrentPayload(ByteBuffer buffer) {
        ByteBuffer byteBuffer = this.frameBody;
        if (byteBuffer == null) {
            return true;
        }
        ByteBuffer frame = byteBuffer;
        NIOKt.moveTo$default(frame, buffer, 0, 2, null);
        if (!frame.hasRemaining()) {
            this.frameBody = null;
            return true;
        }
        return false;
    }

    private final int maskSize(boolean mask) {
        return mask ? 4 : 0;
    }

    private final ByteBuffer maskedIfNeeded(ByteBuffer $this$maskedIfNeeded) {
        ByteBuffer byteBuffer;
        block3: {
            block2: {
                ByteBuffer byteBuffer2;
                byteBuffer = this.maskBuffer;
                if (byteBuffer == null) break block2;
                ByteBuffer mask = byteBuffer;
                boolean bl = false;
                ByteBuffer $this$maskedIfNeeded_u24lambda_u2d1_u24lambda_u2d0 = byteBuffer2 = NIOKt.copy$default($this$maskedIfNeeded, 0, 1, null);
                boolean bl2 = false;
                UtilsKt.xor($this$maskedIfNeeded_u24lambda_u2d1_u24lambda_u2d0, mask);
                ByteBuffer byteBuffer3 = byteBuffer2;
                byteBuffer = byteBuffer3;
                if (byteBuffer3 != null) break block3;
            }
            byteBuffer = $this$maskedIfNeeded;
        }
        return byteBuffer;
    }

    /*
     * WARNING - void declaration
     */
    private final void setMaskBuffer(boolean mask) {
        if (mask) {
            void $this$setMaskBuffer_u24lambda_u2d2;
            ByteBuffer byteBuffer;
            ByteBuffer byteBuffer2 = byteBuffer = ByteBuffer.allocate(4);
            Serializer serializer2 = this;
            boolean bl = false;
            $this$setMaskBuffer_u24lambda_u2d2.putInt(Random.Default.nextInt());
            $this$setMaskBuffer_u24lambda_u2d2.clear();
            serializer2.maskBuffer = byteBuffer;
        } else {
            this.maskBuffer = null;
        }
    }
}

