/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.enderchests.common.tileentity;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1263;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2618;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;
import shetiphian.core.common.Function;
import shetiphian.core.common.NameHelper;
import shetiphian.core.common.inventory.IContainerCallback;
import shetiphian.core.common.inventory.InventoryInternal;
import shetiphian.core.common.rgb16.IRGB16_Tile;
import shetiphian.core.common.rgb16.RGB16;
import shetiphian.core.common.rgb16.RGB16Helper;
import shetiphian.core.common.tileentity.IDetachedInventory;
import shetiphian.core.common.tileentity.ILoadStateAware;
import shetiphian.core.common.tileentity.TileEntityBase;
import shetiphian.enderchests.EnderChests;
import shetiphian.enderchests.Roster;
import shetiphian.enderchests.common.block.BlockEnderChest;
import shetiphian.enderchests.common.inventory.ContainerEnderChest;
import shetiphian.enderchests.common.misc.ChestHelper;
import shetiphian.enderchests.common.misc.ChestInfoHelper;
import shetiphian.enderchests.common.misc.LocationManager;

public class TileEntityEnderChest
extends TileEntityBase
implements class_2618,
IRGB16_Tile,
IContainerCallback,
ILoadStateAware,
IDetachedInventory {
    private String code = "000";
    private String ownerID = null;
    private String owner = "all";
    private class_1799 personalItem;
    private float lidAngle;
    private float prevLidAngle;
    private int numPlayersUsing;
    private int ticksSinceSync;
    private final List<String> usedUpgrades = new ArrayList<String>();

    public TileEntityEnderChest(class_2338 pos, class_2680 state) {
        super(Roster.Tiles.ENDERCHEST, pos, state);
    }

    public void buildNBT(class_2487 nbtTag) {
        nbtTag.method_10582("code", this.getCode());
        nbtTag.method_10582("owner", this.owner);
        if (!Strings.isNullOrEmpty((String)this.ownerID)) {
            nbtTag.method_10582("owner.id", this.ownerID);
        }
        nbtTag.method_10582("owner_id", this.getOwnerID());
        if (this.personalItem != null) {
            class_2487 compound = new class_2487();
            this.personalItem.method_7953(compound);
            nbtTag.method_10566("upgrade.access", (class_2520)compound);
            nbtTag.method_10582("personal", class_7923.field_41178.method_10221((Object)this.personalItem.method_7909()).toString());
        }
        if (!this.usedUpgrades.isEmpty()) {
            class_2499 listNBT = new class_2499();
            for (String upgrade : this.usedUpgrades) {
                listNBT.add((Object)class_2519.method_23256((String)upgrade));
            }
            nbtTag.method_10566("used_upgrades", (class_2520)listNBT);
        }
    }

    public void processNBT(class_2487 nbtTag) {
        this.setCode(nbtTag.method_10558("code"));
        this.owner = nbtTag.method_10558("owner");
        if (nbtTag.method_10545("owner.id")) {
            this.ownerID = nbtTag.method_10558("owner.id");
        }
        if (nbtTag.method_10545("upgrade.access")) {
            class_1799 stack = class_1799.method_7915((class_2487)nbtTag.method_10562("upgrade.access"));
            if (!stack.method_7960() && stack.method_7947() != 1) {
                stack.method_7939(1);
            }
            this.personalItem = stack;
        }
        if (nbtTag.method_10545("used_upgrades")) {
            this.usedUpgrades.clear();
            class_2499 listNBT = nbtTag.method_10554("used_upgrades", 8);
            listNBT.listIterator().forEachRemaining(entry -> this.usedUpgrades.add(entry.method_10714()));
        }
    }

    public void processNBT_SaveOnly(class_2487 nbtTag) {
        super.processNBT_SaveOnly(nbtTag);
        if (!Strings.isNullOrEmpty((String)this.ownerID)) {
            this.owner = NameHelper.getDisplayNameFor((String)this.ownerID);
        }
    }

    @NotNull
    public class_1263 getInventory() {
        return this.getChest();
    }

    public boolean applyItem(class_1799 stack) {
        String key = class_7923.field_41178.method_10221((Object)stack.method_7909()).toString();
        if (this.usedUpgrades.contains(key)) {
            return false;
        }
        this.usedUpgrades.add(key);
        return true;
    }

    public float method_11274(float partialTick) {
        return class_3532.method_16439((float)partialTick, (float)this.prevLidAngle, (float)this.lidAngle);
    }

    public static void tick(class_1937 world, class_2338 pos, class_2680 state, TileEntityEnderChest tile) {
        int x = pos.method_10263();
        int y = pos.method_10264();
        int z = pos.method_10260();
        ++tile.ticksSinceSync;
        if (!world.method_8608() && tile.numPlayersUsing != 0 && (tile.ticksSinceSync + x + y + z) % 200 == 0) {
            tile.numPlayersUsing = 0;
            for (class_1657 player : world.method_18467(class_1657.class, new class_238((double)((float)x - 5.0f), (double)((float)y - 5.0f), (double)((float)z - 5.0f), (double)((float)(x + 1) + 5.0f), (double)((float)(y + 1) + 5.0f), (double)((float)(z + 1) + 5.0f)))) {
                if (!(player.field_7512 instanceof ContainerEnderChest) || !((ContainerEnderChest)player.field_7512).isParentTile(tile)) continue;
                ++tile.numPlayersUsing;
            }
        }
        tile.prevLidAngle = tile.lidAngle;
        if (tile.numPlayersUsing > 0 && tile.lidAngle == 0.0f) {
            world.method_43128(null, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, class_3417.field_14982, class_3419.field_15245, 0.5f, world.field_9229.method_43057() * 0.1f + 0.9f);
        }
        if (tile.numPlayersUsing == 0 && tile.lidAngle > 0.0f || tile.numPlayersUsing > 0 && tile.lidAngle < 1.0f) {
            float oldAngle = tile.lidAngle;
            tile.lidAngle = tile.numPlayersUsing > 0 ? (tile.lidAngle += 0.075f) : (tile.lidAngle -= 0.075f);
            if (tile.lidAngle > 1.0f) {
                tile.lidAngle = 1.0f;
            }
            if (tile.lidAngle < 0.5f && oldAngle >= 0.5f) {
                world.method_43128(null, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, class_3417.field_14823, class_3419.field_15245, 0.5f, world.field_9229.method_43057() * 0.1f + 0.9f);
            }
            if (tile.lidAngle < 0.0f) {
                tile.lidAngle = 0.0f;
            }
        }
    }

    @Environment(value=EnvType.CLIENT)
    public float getLidAngle(float partialTicks) {
        return class_3532.method_16439((float)partialTicks, (float)this.prevLidAngle, (float)this.lidAngle);
    }

    public int getLidOffsetIndex() {
        return Math.round(this.lidAngle * 100.0f) / 10;
    }

    public boolean method_11004(int id, int value) {
        if (id == 1) {
            this.numPlayersUsing = value;
            return true;
        }
        return super.method_11004(id, value);
    }

    public boolean isOpen() {
        return this.numPlayersUsing > 0;
    }

    private boolean canBeAutomated() {
        return this.isPublic() ? EnderChests.CONFIG.COMMON.ACCESS_SETTINGS.public_automation : (this.isTeam() ? EnderChests.CONFIG.COMMON.ACCESS_SETTINGS.team_automation : EnderChests.CONFIG.COMMON.ACCESS_SETTINGS.personal_automation);
    }

    public InventoryInternal getChest() {
        return ChestHelper.getChest(this.field_11863, this.getOwnerID(), this.getCode());
    }

    public boolean canInteractWith(class_2586 blockEntity, class_1263 inventory, class_1657 player, boolean original) {
        return this.field_11863 != null && this.field_11863.method_8321(this.field_11867) == this && player.method_5649((double)this.field_11867.method_10263() + 0.5, (double)this.field_11867.method_10264() + 0.5, (double)this.field_11867.method_10260() + 0.5) <= 64.0;
    }

    public void onContainerOpen(class_2586 owner, class_1263 inventory, class_1657 player) {
        if (this.numPlayersUsing < 0) {
            this.numPlayersUsing = 0;
        }
        if (!player.method_7325()) {
            ++this.numPlayersUsing;
            if (this.field_11863 != null) {
                this.field_11863.method_8427(this.field_11867, this.method_11010().method_26204(), 1, this.numPlayersUsing);
                this.field_11863.method_8408(this.field_11867, this.method_11010().method_26204());
            }
        }
    }

    public void onContainerClosed(class_2586 owner, class_1263 inventory, class_1657 player) {
        if (!player.method_7325()) {
            --this.numPlayersUsing;
            if (this.field_11863 != null) {
                this.field_11863.method_8427(this.field_11867, this.method_11010().method_26204(), 1, this.numPlayersUsing);
                this.field_11863.method_8408(this.field_11867, this.method_11010().method_26204());
            }
        }
    }

    public boolean canEdit(class_1657 player) {
        boolean canEdit = true;
        String msg = "";
        if (!player.method_31549().field_7477) {
            if (this.isTeam()) {
                canEdit = !EnderChests.CONFIG.COMMON.ACCESS_SETTINGS.team_edit_lock || this.ownerID.equalsIgnoreCase(this.getPlayerTeam(player));
                msg = "team.denied";
            } else if (!this.isPublic()) {
                canEdit = !EnderChests.CONFIG.COMMON.ACCESS_SETTINGS.personal_edit_lock || !Strings.isNullOrEmpty((String)this.ownerID) && this.ownerID.equals(player.method_5667().toString());
                msg = "private.denied";
            }
        }
        if (!canEdit && !Strings.isNullOrEmpty((String)msg)) {
            ChestInfoHelper.sendError(player, "enderchests.chest." + msg);
        }
        return canEdit;
    }

    public boolean canUse(class_1657 player) {
        boolean canUse = true;
        String msg = "";
        if (!player.method_31549().field_7477) {
            if (this.isTeam()) {
                canUse = !EnderChests.CONFIG.COMMON.ACCESS_SETTINGS.team_use_lock || this.ownerID.equalsIgnoreCase(this.getPlayerTeam(player));
                msg = "team.denied";
            } else if (this.isPublic()) {
                canUse = EnderChests.CONFIG.COMMON.ACCESS_SETTINGS.public_chests;
                msg = "public.disabled";
            } else {
                canUse = !EnderChests.CONFIG.COMMON.ACCESS_SETTINGS.personal_use_lock || !Strings.isNullOrEmpty((String)this.ownerID) && this.ownerID.equals(player.method_5667().toString());
                msg = "private.denied";
            }
        }
        if (!canUse && !Strings.isNullOrEmpty((String)msg)) {
            ChestInfoHelper.sendError(player, "enderchests.chest." + msg);
        }
        return canUse;
    }

    public boolean canLink(class_1657 player) {
        boolean canLink = true;
        String msg = "";
        if (!player.method_31549().field_7477) {
            if (this.isTeam()) {
                if (EnderChests.CONFIG.COMMON.ACCESS_SETTINGS.team_bags) {
                    canLink = !EnderChests.CONFIG.COMMON.ACCESS_SETTINGS.team_link_lock || this.ownerID.equalsIgnoreCase(this.getPlayerTeam(player));
                    msg = "chest.team.denied";
                } else {
                    canLink = false;
                    msg = "bag.team.disabled";
                }
            } else if (!this.isPublic()) {
                if (EnderChests.CONFIG.COMMON.ACCESS_SETTINGS.personal_bags) {
                    canLink = !EnderChests.CONFIG.COMMON.ACCESS_SETTINGS.personal_link_lock || !Strings.isNullOrEmpty((String)this.ownerID) && this.ownerID.equals(player.method_5667().toString());
                    msg = "chest.private.denied";
                } else {
                    canLink = false;
                    msg = "bag.private.disabled";
                }
            }
        }
        if (!canLink && !Strings.isNullOrEmpty((String)msg)) {
            ChestInfoHelper.sendError(player, "enderchests." + msg);
        }
        return canLink;
    }

    private String getPlayerTeam(class_1657 player) {
        String team = Function.getPlayerTeamID((class_1657)player);
        return "#" + (Strings.isNullOrEmpty((String)team) ? "none" : team);
    }

    public String getOwner() {
        return !Strings.isNullOrEmpty((String)this.owner) ? this.owner : "all";
    }

    public String getOwnerID() {
        if (this.getOwner().equalsIgnoreCase("all")) {
            return "all";
        }
        if (!Strings.isNullOrEmpty((String)this.ownerID)) {
            return this.ownerID;
        }
        return this.getOwner();
    }

    public String getOwnerName() {
        return ChestInfoHelper.getDisplayNameFromOwnerID(this.ownerID);
    }

    public void setOwner(class_1657 player, class_1799 stack) {
        this.personalItem = stack;
        this.owner = player.method_5476().getString();
        this.ownerID = player.method_5667().toString();
    }

    public void setOwner(String ownerName, String ownerID, class_1799 stack) {
        if (ownerID != null) {
            this.personalItem = stack;
            this.owner = ownerName;
            this.ownerID = ownerID;
        }
    }

    public class_1799 getPersonalItem() {
        if (this.personalItem != null && !this.personalItem.method_7960()) {
            if (this.personalItem.method_7947() != 1) {
                this.personalItem.method_7939(1);
            }
            return this.personalItem;
        }
        return class_1799.field_8037;
    }

    public boolean isPublic() {
        return this.getOwner().equalsIgnoreCase("all");
    }

    public boolean isTeam() {
        return this.ownerID != null && this.ownerID.startsWith("#");
    }

    public String getCode() {
        while (this.code.length() < 3) {
            this.code = "0" + this.code;
        }
        return this.code.toUpperCase();
    }

    public void setCode(String code) {
        while (((String)code).length() < 3) {
            code = "0" + (String)code;
        }
        this.code = ((String)code).toUpperCase();
    }

    public boolean hasError() {
        return !this.isPublic() && Strings.isNullOrEmpty((String)this.ownerID);
    }

    public RGB16 getRGB16(class_1657 player) {
        if (player == null) {
            return null;
        }
        int ring = this.getRingHit(player);
        if (ring < 0 || ring > 2) {
            return null;
        }
        int value = Integer.parseInt("" + this.getCode().charAt(ring), 16);
        return new RGB16(class_1767.method_7791((int)value).method_7792());
    }

    public boolean setRGB16(short rgbIndex, class_1657 player) {
        return this.doColorRing(class_1767.method_7791((int)RGB16Helper.getSimpleColor((short)rgbIndex)), player);
    }

    public boolean doColorRing(class_1767 color, class_1657 player) {
        if (player == null || !this.canEdit(player) || !EnderChests.CONFIG.COMMON.enable_in_world_coloring) {
            return false;
        }
        int ring = this.getRingHit(player);
        if (ring < 0 || ring > 2) {
            return false;
        }
        char charColor = Integer.toHexString(color.method_7789()).charAt(0);
        char[] charCode = this.getCode().toCharArray();
        if (charCode[ring] != charColor) {
            charCode[ring] = charColor;
            this.setCode("" + charCode[0] + charCode[1] + charCode[2]);
            Function.syncTile((class_2586)this);
            return true;
        }
        return false;
    }

    private int getRingHit(class_1657 player) {
        class_265[] shapes = BlockEnderChest.SHAPES.get(this.method_11010().method_11654((class_2769)BlockEnderChest.FACING));
        return Function.getSubShapeHit((class_1297)player, (class_2338)this.field_11867, (class_265[])shapes) - 1;
    }

    private void setMyLocation() {
        if (this.field_11863 != null && !this.field_11863.method_8608()) {
            LocationManager.set(this.getOwnerID(), this.getCode(), this);
        }
    }

    private void clearMyLocation() {
        if (this.field_11863 != null && !this.field_11863.method_8608()) {
            LocationManager.clear(this.getOwnerID(), this.getCode(), this);
        }
    }

    public void onLoad() {
        this.setMyLocation();
    }

    public void onChunkUnloaded() {
        this.clearMyLocation();
    }
}

