/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.enderchests.common.misc;

import com.google.common.base.Strings;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;
import shetiphian.enderchests.common.misc.ChestInfoHelper;

public class StackHelper {
    public static final String[] BASE_CODES = new String[]{"000", "111", "222", "333", "444", "555", "666", "777", "888", "999", "AAA", "BBB", "CCC", "DDD", "EEE", "FFF"};

    public static class_1799 create(class_1792 item, String code, String ownerID, @NotNull class_1799 personalItem) {
        class_1799 stack = StackHelper.create(item, code, !personalItem.method_7960() ? ownerID : "all");
        if (!personalItem.method_7960()) {
            String id = class_7923.field_41178.method_10221((Object)personalItem.method_7909()).toString();
            StackHelper.getTag(stack).method_10582("personal", id);
        }
        return stack;
    }

    public static class_1799 create(class_1792 item, String code, String ownerID) {
        class_1799 stack = new class_1799((class_1935)item);
        StackHelper.setCode(stack, code);
        StackHelper.setOwner(stack, ownerID);
        return stack;
    }

    public static void setOwner(class_1799 stack, String ownerID) {
        if (Strings.isNullOrEmpty((String)ownerID) || ownerID.equalsIgnoreCase("all")) {
            ownerID = "all";
        }
        StackHelper.getTag(stack).method_10582("owner", ownerID);
    }

    public static void setCode(class_1799 stack, String code) {
        StackHelper.getTag(stack).method_10582("code", StackHelper.formatCode(code));
    }

    public static String getOwnerID(class_1799 stack) {
        if (!stack.method_7960()) {
            if (StackHelper.getTag(stack).method_10545("owner")) {
                return StackHelper.getTag(stack).method_10558("owner");
            }
            StackHelper.setOwner(stack, "all");
        }
        return "all";
    }

    public static String getOwnerName(class_1799 stack) {
        return ChestInfoHelper.getDisplayNameFromOwnerID(StackHelper.getOwnerID(stack));
    }

    public static String getCode(class_1799 stack) {
        if (StackHelper.getTag(stack).method_10545("code")) {
            return StackHelper.formatCode(StackHelper.getTag(stack).method_10558("code"));
        }
        StackHelper.setCode(stack, "000");
        return "000";
    }

    @NotNull
    public static class_1799 getPersonalItem(class_1799 stack) {
        String id = StackHelper.getTag(stack).method_10558("personal");
        if (!Strings.isNullOrEmpty((String)id)) {
            try {
                class_1792 item = (class_1792)class_7923.field_41178.method_10223(new class_2960(id));
                if (item != null) {
                    return new class_1799((class_1935)item, 1);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return class_1799.field_8037;
    }

    public static boolean isPublic(class_1799 stack) {
        String ownerID = StackHelper.getOwnerID(stack);
        return Strings.isNullOrEmpty((String)ownerID) || ownerID.equalsIgnoreCase("all");
    }

    public static boolean isPrivate(class_1799 stack) {
        return !StackHelper.isPublic(stack) && !StackHelper.isTeam(stack);
    }

    public static boolean isTeam(class_1799 stack) {
        String ownerID = StackHelper.getOwnerID(stack);
        return !Strings.isNullOrEmpty((String)ownerID) && ownerID.startsWith("#");
    }

    private static class_2487 getTag(class_1799 stack) {
        return stack.method_7948();
    }

    private static String formatCode(String code) {
        if (Strings.isNullOrEmpty((String)code)) {
            return "000";
        }
        if (((String)(code = ((String)code).toUpperCase())).length() != 3) {
            while (((String)code).length() < 3) {
                code = "0" + (String)code;
            }
            code = ((String)code).substring(0, 3);
        }
        if (((String)code).matches("[0-9A-F]{3}")) {
            return code;
        }
        char[] parts = ((String)code).toCharArray();
        for (int index = 0; index < 3; ++index) {
            if (!("" + parts[index]).matches("[^0-9A-F]")) continue;
            parts[index] = 48;
        }
        return "" + parts[0] + parts[1] + parts[2];
    }
}

