/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.bettertrims.util.mixin;

import com.bawnorton.bettertrims.util.mixin.AdvancedConditionChecker;
import java.util.Optional;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.Version;
import net.fabricmc.loader.api.VersionParsingException;

public class IrisConditionChecker
implements AdvancedConditionChecker {
    private final Version minVersion;
    private final Version maxVersion;

    public IrisConditionChecker(String min, String max) {
        try {
            this.minVersion = min.isEmpty() ? null : Version.parse((String)min);
            this.maxVersion = max.isEmpty() ? null : Version.parse((String)max);
        }
        catch (VersionParsingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean shouldApply() {
        return this.versionCheck();
    }

    private boolean versionCheck() {
        Optional optional = FabricLoader.getInstance().getModContainer("iris");
        if (optional.isEmpty()) {
            return false;
        }
        if (this.minVersion == null && this.maxVersion == null) {
            return true;
        }
        Version version = ((ModContainer)optional.get()).getMetadata().getVersion();
        if (this.minVersion != null && version.compareTo((Object)this.minVersion) < 0) {
            return false;
        }
        return this.maxVersion == null || version.compareTo((Object)this.maxVersion) <= 0;
    }
}

