/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.bettertrims.networking;

import com.bawnorton.bettertrims.BetterTrims;
import com.bawnorton.bettertrims.config.ConfigManager;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public abstract class Networking {
    public static final class_2960 CONFIG_OP_CHECK = BetterTrims.id("config_op_check");
    public static final class_2960 CONFIG_SYNC = BetterTrims.id("config_sync");
    public static final class_2960 HANDSHAKE = BetterTrims.id("handshake");
    private static MinecraftServer server;

    public static void init() {
        ServerPlayNetworking.registerGlobalReceiver((class_2960)HANDSHAKE, (server, player, handler, buf, responseSender) -> Networking.sendConfigToPlayer(player));
        ServerPlayNetworking.registerGlobalReceiver((class_2960)CONFIG_SYNC, (server, player, handler, buf, responseSender) -> {
            ConfigManager.deserializeConfig(buf.method_19772());
            Networking.sendConfigToAllOtherPlayers(server, player);
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)CONFIG_OP_CHECK, (server, player, handler, buf, responseSender) -> {
            class_2540 response = PacketByteBufs.create();
            response.writeBoolean(player.method_5687(2));
            responseSender.sendPacket(CONFIG_OP_CHECK, response);
        });
    }

    private static void sendConfigToAllOtherPlayers(MinecraftServer server, class_3222 player) {
        server.method_3760().method_14571().forEach(otherPlayer -> {
            if (otherPlayer.equals((Object)player)) {
                return;
            }
            Networking.sendConfigToPlayer(otherPlayer);
        });
    }

    private static void sendConfigToPlayer(class_3222 player) {
        String serialized = ConfigManager.serializeConfig();
        class_2540 buf = PacketByteBufs.create();
        buf.writeBoolean(Networking.isDedicated());
        buf.method_10814(serialized);
        ServerPlayNetworking.send((class_3222)player, (class_2960)CONFIG_SYNC, (class_2540)buf);
    }

    public static void setServer(MinecraftServer server) {
        Networking.server = server;
    }

    public static boolean isDedicated() {
        if (server == null) {
            return false;
        }
        return server.method_3816();
    }
}

