/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.bettertrims.effect;

import com.bawnorton.bettertrims.config.ConfigManager;
import com.bawnorton.bettertrims.effect.ArmorTrimEffect;
import com.bawnorton.bettertrims.effect.TrimMaterial;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_8053;
import net.minecraft.class_8055;

public abstract class ArmorTrimEffects {
    private static final List<ArmorTrimEffect> EFFECTS = new ArrayList<ArmorTrimEffect>();
    public static final ArmorTrimEffect QUARTZ = ArmorTrimEffects.of(TrimMaterial.of(class_8055.field_42004), () -> ConfigManager.getConfig().enableQuartz);
    public static final ArmorTrimEffect IRON = ArmorTrimEffects.of(TrimMaterial.of(class_8055.field_42005), () -> ConfigManager.getConfig().enableIron);
    public static final ArmorTrimEffect NETHERITE = ArmorTrimEffects.of(TrimMaterial.of(class_8055.field_42006), () -> ConfigManager.getConfig().enableNetherite);
    public static final ArmorTrimEffect REDSTONE = ArmorTrimEffects.of(TrimMaterial.of(class_8055.field_42007), () -> ConfigManager.getConfig().enableRedstone);
    public static final ArmorTrimEffect COPPER = ArmorTrimEffects.of(TrimMaterial.of(class_8055.field_42008), () -> ConfigManager.getConfig().enableCopper);
    public static final ArmorTrimEffect GOLD = ArmorTrimEffects.of(TrimMaterial.of(class_8055.field_42009), () -> ConfigManager.getConfig().enableGold);
    public static final ArmorTrimEffect EMERALD = ArmorTrimEffects.of(TrimMaterial.of(class_8055.field_42010), () -> ConfigManager.getConfig().enableEmerald);
    public static final ArmorTrimEffect DIAMOND = ArmorTrimEffects.of(TrimMaterial.of(class_8055.field_42011), () -> ConfigManager.getConfig().enableDiamond);
    public static final ArmorTrimEffect LAPIS = ArmorTrimEffects.of(TrimMaterial.of(class_8055.field_42012), () -> ConfigManager.getConfig().enableLapis);
    public static final ArmorTrimEffect AMETHYST = ArmorTrimEffects.of(TrimMaterial.of(class_8055.field_42013), () -> ConfigManager.getConfig().enableAmethyst);
    public static final ArmorTrimEffect COAL = ArmorTrimEffects.of(TrimMaterial.of(class_1802.field_8713), () -> ConfigManager.getConfig().enableCoal);
    public static final ArmorTrimEffect DRAGONS_BREATH = ArmorTrimEffects.of(TrimMaterial.of(class_1802.field_8613).or(TrimMaterial.of("dragon")), () -> ConfigManager.getConfig().enableDragonsBreath);
    public static final ArmorTrimEffect CHORUS_FRUIT = ArmorTrimEffects.of(TrimMaterial.of(class_1802.field_8233), () -> ConfigManager.getConfig().enableChorusFruit);
    public static final ArmorTrimEffect ECHO_SHARD = ArmorTrimEffects.of(TrimMaterial.of(class_1802.field_38746).or(TrimMaterial.of("echo")), () -> ConfigManager.getConfig().enableEchoShard);
    public static final ArmorTrimEffect ENDER_PEARL = ArmorTrimEffects.of(TrimMaterial.of(class_1802.field_8634).or(TrimMaterial.of("ender")), () -> ConfigManager.getConfig().enableEnderPearl);
    public static final ArmorTrimEffect FIRE_CHARGE = ArmorTrimEffects.of(TrimMaterial.of(class_1802.field_8814).or(TrimMaterial.of("flame")), () -> ConfigManager.getConfig().enableFireCharge);
    public static final ArmorTrimEffect GLOWSTONE_DUST = ArmorTrimEffects.of(TrimMaterial.of(class_1802.field_8601).or(TrimMaterial.of("glowstone")), () -> ConfigManager.getConfig().enableGlowstoneDust);
    public static final ArmorTrimEffect LEATHER = ArmorTrimEffects.of(TrimMaterial.of(class_1802.field_8745), () -> ConfigManager.getConfig().enableLeather);
    public static final ArmorTrimEffect NETHER_BRICK = ArmorTrimEffects.of(TrimMaterial.of(class_1802.field_8729).or(TrimMaterial.of("netherbrick")), () -> ConfigManager.getConfig().enableNetherBrick);
    public static final ArmorTrimEffect PRISMARINE_SHARD = ArmorTrimEffects.of(TrimMaterial.of(class_1802.field_8662).or(TrimMaterial.of("prismarine")), () -> ConfigManager.getConfig().enablePrismarineShard);
    public static final ArmorTrimEffect RABBIT_HIDE = ArmorTrimEffects.of(TrimMaterial.of(class_1802.field_8245).or(TrimMaterial.of("rabbit")), () -> ConfigManager.getConfig().enableRabbitHide);
    public static final ArmorTrimEffect SLIME_BALL = ArmorTrimEffects.of(TrimMaterial.of(class_1802.field_8777).or(TrimMaterial.of("slime")), () -> ConfigManager.getConfig().enableSlimeBall);
    public static final ArmorTrimEffect ENCHANTED_GOLDEN_APPLE = ArmorTrimEffects.of(TrimMaterial.of(class_1802.field_8367).or(TrimMaterial.of("rainbow")), () -> ConfigManager.getConfig().enableEnchantedGoldenApple);
    public static final ArmorTrimEffect PLATINUM = ArmorTrimEffects.of(TrimMaterial.of("platinum"), () -> ConfigManager.getConfig().enablePlatinum);
    public static final ArmorTrimEffect SILVER = ArmorTrimEffects.of(TrimMaterial.of("silver"), () -> ConfigManager.getConfig().enableSilver);

    public static ArmorTrimEffect of(TrimMaterial material, BooleanSupplier enabled) {
        ArmorTrimEffect effect = new ArmorTrimEffect(material, enabled, material.getTooltip());
        EFFECTS.add(effect);
        return effect;
    }

    public static void forEachAppliedEffect(class_1799 stack, Consumer<ArmorTrimEffect> effectConsumer) {
        for (ArmorTrimEffect effect : EFFECTS) {
            if (!effect.appliesTo(stack)) continue;
            effectConsumer.accept(effect);
        }
    }

    public static List<ArmorTrimEffect> getEffects(class_8053 armorTrim) {
        ArrayList<ArmorTrimEffect> effects = new ArrayList<ArmorTrimEffect>();
        for (ArmorTrimEffect effect : EFFECTS) {
            if (!effect.appliesTo(armorTrim)) continue;
            effects.add(effect);
        }
        return effects;
    }
}

