/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.bettertrims.effect;

import com.bawnorton.bettertrims.compat.Compat;
import com.bawnorton.bettertrims.compat.StackedTrimsCompat;
import com.bawnorton.bettertrims.effect.TrimMaterial;
import com.bawnorton.bettertrims.util.EquippedStack;
import java.util.List;
import java.util.function.BooleanSupplier;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import net.minecraft.class_8053;
import net.minecraft.class_8054;

public class ArmorTrimEffect {
    private final TrimMaterial material;
    private final BooleanSupplier enabled;
    private final class_2561 tooltip;

    public ArmorTrimEffect(TrimMaterial matieral, BooleanSupplier enabled, class_2561 tooltip) {
        this.material = matieral;
        this.enabled = enabled;
        this.tooltip = tooltip;
    }

    private String getTrimMaterial(class_1799 stack) {
        class_2487 nbt = stack.method_7969();
        if (nbt == null) {
            return null;
        }
        class_2520 trimElement = nbt.method_10580("Trim");
        if (!(trimElement instanceof class_2487)) {
            return null;
        }
        class_2487 nbtCompound = (class_2487)trimElement;
        return new class_2960(nbtCompound.method_10558("material")).method_12832();
    }

    public boolean appliesTo(EquippedStack stack) {
        if (!stack.correctSlot()) {
            return false;
        }
        return this.appliesTo(stack.itemStack());
    }

    public boolean appliesTo(class_1799 stack) {
        if (!this.enabled.getAsBoolean()) {
            return false;
        }
        if (Compat.isStackedTrimsLoaded()) {
            List<String> materials = StackedTrimsCompat.getTrimMaterials(stack);
            if (materials == null) {
                return false;
            }
            return this.material.appliesTo(materials);
        }
        String material = this.getTrimMaterial(stack);
        return material != null && this.material.appliesTo(material);
    }

    public boolean appliesTo(Iterable<EquippedStack> stacks) {
        for (EquippedStack stack : stacks) {
            if (!this.appliesTo(stack)) continue;
            return true;
        }
        return false;
    }

    public boolean appliesTo(class_8053 armorTrim) {
        String material = class_7923.field_41178.method_10221((Object)((class_1792)((class_8054)armorTrim.method_48431().comp_349()).comp_1209().comp_349())).method_12832();
        if (!this.enabled.getAsBoolean()) {
            return false;
        }
        return this.material.appliesTo(material);
    }

    public void apply(Iterable<EquippedStack> armour, Effect effect) {
        for (EquippedStack stack : armour) {
            if (!this.appliesTo(stack)) continue;
            effect.applyEffect();
        }
    }

    public class_2561 getTooltip() {
        return this.tooltip;
    }

    @FunctionalInterface
    public static interface Effect {
        public void applyEffect();
    }
}

