/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.bettertrims.config.option;

import com.bawnorton.bettertrims.BetterTrims;
import com.bawnorton.bettertrims.config.annotation.BooleanOption;
import com.bawnorton.bettertrims.config.annotation.FloatOption;
import com.bawnorton.bettertrims.config.annotation.IntOption;
import com.bawnorton.bettertrims.config.annotation.NestedOption;
import com.bawnorton.bettertrims.config.annotation.TextureLocation;
import com.bawnorton.bettertrims.reflection.Reflection;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_1792;
import net.minecraft.class_2960;
import net.minecraft.class_4941;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class ConfigOptionReference {
    private static final Map<String, class_2960> TEXTURE_CACHE = new HashMap<String, class_2960>();
    private final Object instance;
    private final Field field;
    private Object value;

    protected ConfigOptionReference(Object instance, Field field) {
        this.instance = instance;
        this.field = field;
        this.value = Reflection.accessField(field, instance);
    }

    public static ConfigOptionReference of(Object instance, Field field) {
        ConfigOptionReference reference = new ConfigOptionReference(instance, field);
        reference.validateAnnotations();
        return reference;
    }

    public static Optional<String> readGroup(Field field) {
        return Optional.of(switch (FieldType.of(field.getType())) {
            default -> throw new IncompatibleClassChangeError();
            case FieldType.BOOLEAN -> field.getAnnotation(BooleanOption.class).group();
            case FieldType.INTEGER -> field.getAnnotation(IntOption.class).group();
            case FieldType.FLOAT -> field.getAnnotation(FloatOption.class).group();
            case FieldType.NESTED -> field.getAnnotation(NestedOption.class).group();
        });
    }

    private void validateAnnotations() {
        Annotation[] annotations = this.field.getAnnotations();
        if (annotations.length == 0) {
            throw new IllegalStateException("Field \"" + this.field.getName() + "\" has no annotations.");
        }
        boolean hasType = false;
        for (Annotation annotation : annotations) {
            if (!(annotation instanceof BooleanOption) && !(annotation instanceof IntOption) && !(annotation instanceof FloatOption) && !(annotation instanceof NestedOption)) continue;
            if (hasType) {
                throw new IllegalStateException("Field \"" + this.field.getName() + "\" has multiple type annotations.");
            }
            hasType = true;
        }
        if (!hasType) {
            throw new IllegalStateException("Field \"" + this.field.getName() + "\" has no type annotation.");
        }
        this.validateOptionType();
    }

    private void validateOptionType() {
        FieldType fieldType = this.getType();
        Class<? extends Annotation> expectedAnnotation = fieldType.expectedAnnotation();
        Annotation annotation = this.field.getAnnotation(expectedAnnotation);
        if (annotation == null) {
            throw new IllegalStateException("Field \"" + this.field.getName() + "\" has invalid type annotation. Expected @" + expectedAnnotation.getSimpleName());
        }
    }

    private void validateValueType(Class<?> clazz) {
        if (this.value == null) {
            return;
        }
        if (clazz == null) {
            throw new IllegalArgumentException("Class cannot be null.");
        }
        if (!clazz.isAssignableFrom(this.value.getClass())) {
            throw new IllegalArgumentException("Invalid type " + clazz.getName() + " for " + this.value.getClass().getName());
        }
    }

    public <T> void setConfigValue(T value) {
        if (value == null) {
            throw new IllegalArgumentException("Value cannot be null.");
        }
        this.validateValueType(value.getClass());
        Reflection.setField(this.field, this.instance, value);
        this.value = value;
    }

    private <T> T getValueAsType(Class<T> clazz) {
        this.validateValueType(clazz);
        return clazz.cast(this.value);
    }

    public boolean isValueNull() {
        return this.value == null;
    }

    public String getFormattedName() {
        StringBuilder builder = new StringBuilder();
        String name = this.field.getName();
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (Character.isUpperCase(c)) {
                builder.append('.');
                builder.append(Character.toLowerCase(c));
                continue;
            }
            builder.append(c);
        }
        return builder.toString();
    }

    public boolean isOf(String type) {
        return this.getOptionType().equals(type);
    }

    public String getOptionType() {
        this.validateOptionType();
        return switch (this.getType()) {
            default -> throw new IncompatibleClassChangeError();
            case FieldType.BOOLEAN -> this.field.getAnnotation(BooleanOption.class).group();
            case FieldType.INTEGER -> this.field.getAnnotation(IntOption.class).group();
            case FieldType.FLOAT -> this.field.getAnnotation(FloatOption.class).group();
            case FieldType.NESTED -> this.field.getAnnotation(NestedOption.class).group();
        };
    }

    public boolean isNested() {
        return this.getType() == FieldType.NESTED;
    }

    public FieldType getType() {
        return FieldType.of(this.field.getType());
    }

    public void booleanValue(Boolean value) {
        this.setConfigValue(value);
    }

    public void intValue(Integer value) {
        this.setConfigValue(value);
    }

    public void floatValue(Float value) {
        this.setConfigValue(value);
    }

    public Boolean booleanValue() {
        return this.getValueAsType(Boolean.class);
    }

    public Integer intValue() {
        return this.getValueAsType(Integer.class);
    }

    public Float floatValue() {
        return this.getValueAsType(Float.class);
    }

    public Object nestedValue() {
        return this.getValueAsType(Object.class);
    }

    private Number minValue() {
        return switch (this.getType()) {
            default -> throw new IncompatibleClassChangeError();
            case FieldType.FLOAT -> Float.valueOf(this.field.getAnnotation(FloatOption.class).min());
            case FieldType.INTEGER -> this.field.getAnnotation(IntOption.class).min();
            case FieldType.BOOLEAN, FieldType.NESTED -> throw new IllegalArgumentException("Cannot get min value for type " + this.getType());
        };
    }

    private Number maxValue() {
        return switch (this.getType()) {
            default -> throw new IncompatibleClassChangeError();
            case FieldType.FLOAT -> Float.valueOf(this.field.getAnnotation(FloatOption.class).max());
            case FieldType.INTEGER -> this.field.getAnnotation(IntOption.class).max();
            case FieldType.BOOLEAN, FieldType.NESTED -> throw new IllegalArgumentException("Cannot get max value for type " + this.getType());
        };
    }

    public Float minFloatValue() {
        return (Float)this.minValue();
    }

    public Float maxFloatValue() {
        return (Float)this.maxValue();
    }

    public Integer minIntValue() {
        return (Integer)this.minValue();
    }

    public Integer maxIntValue() {
        return (Integer)this.maxValue();
    }

    @Nullable
    public class_2960 findTexture() {
        if (!this.field.isAnnotationPresent(TextureLocation.class)) {
            return null;
        }
        TextureLocation location = this.field.getAnnotation(TextureLocation.class);
        if (!location.effectLookup()) {
            String locationString = location.value();
            if (locationString.equals("none")) {
                return null;
            }
            return new class_2960(locationString);
        }
        String searchString = location.value();
        return TEXTURE_CACHE.computeIfAbsent(searchString, id -> {
            class_2960 itemId = class_7923.field_41178.method_10235().stream().filter(identifier -> identifier.method_12832().contains(searchString)).findFirst().orElseGet(() -> {
                BetterTrims.LOGGER.debug("Could not find item for identifier \"%s\", trying \"%s_ingot\"".formatted(searchString, searchString));
                String ingotSearchString = searchString + "_ingot";
                return class_7923.field_41178.method_10235().stream().filter(identifier -> identifier.method_12832().contains(ingotSearchString)).findFirst().orElseGet(() -> {
                    BetterTrims.LOGGER.debug("Could not find item for identifier \"%s_ingot\"".formatted(ingotSearchString));
                    return null;
                });
            });
            if (itemId == null) {
                return null;
            }
            return class_4941.method_25840((class_1792)((class_1792)class_7923.field_41178.method_10223(itemId))).method_45138("textures/").method_48331(".png");
        });
    }

    public int hashCode() {
        return Objects.hash(this.field);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ConfigOptionReference)) {
            return false;
        }
        ConfigOptionReference other = (ConfigOptionReference)obj;
        return Objects.equals(this.field, other.field);
    }

    public String toString() {
        return "ConfigOptionReference[field=" + this.field + ", value=" + this.value + "]";
    }

    public static enum FieldType {
        BOOLEAN,
        INTEGER,
        FLOAT,
        NESTED;


        public static FieldType of(Class<?> clazz) {
            if (Boolean.class.isAssignableFrom(clazz)) {
                return BOOLEAN;
            }
            if (Integer.class.isAssignableFrom(clazz)) {
                return INTEGER;
            }
            if (Float.class.isAssignableFrom(clazz)) {
                return FLOAT;
            }
            if (Object.class.isAssignableFrom(clazz)) {
                return NESTED;
            }
            throw new IllegalArgumentException("Unknown type " + clazz.getName());
        }

        private Class<? extends Annotation> expectedAnnotation() {
            return switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case BOOLEAN -> BooleanOption.class;
                case INTEGER -> IntOption.class;
                case FLOAT -> FloatOption.class;
                case NESTED -> NestedOption.class;
            };
        }
    }
}

