/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.bettertrims.client.networking;

import com.bawnorton.bettertrims.client.event.EventHandler;
import com.bawnorton.bettertrims.config.ConfigManager;
import com.bawnorton.bettertrims.networking.Networking;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_368;
import net.minecraft.class_370;
import net.minecraft.class_374;

@Environment(value=EnvType.CLIENT)
public abstract class ClientNetworking {
    private static boolean isConnectedToDedicated = false;
    private static boolean displayNewConfigToast = false;
    private static boolean refreshScreen = false;

    public static void init() {
        ClientPlayNetworking.registerGlobalReceiver((class_2960)Networking.CONFIG_SYNC, (client, handler, buf, responseSender) -> {
            isConnectedToDedicated = buf.readBoolean();
            String serialized = buf.method_19772();
            ConfigManager.deserializeConfig(serialized);
            if (!isConnectedToDedicated) {
                return;
            }
            if (displayNewConfigToast) {
                class_374 toastManager = client.method_1566();
                toastManager.method_1999((class_368)class_370.method_29047((class_310)client, (class_370.class_371)class_370.class_371.field_23774, (class_2561)class_2561.method_43471((String)"bettertrims.new_config.title"), (class_2561)class_2561.method_43471((String)"bettertrims.new_config.desc")));
            } else {
                displayNewConfigToast = true;
            }
            if (refreshScreen) {
                client.execute(EventHandler::onRecievedConfig);
                refreshScreen = false;
            }
        });
        ClientPlayNetworking.registerGlobalReceiver((class_2960)Networking.CONFIG_OP_CHECK, (client, handler, buf, responseSender) -> {
            displayNewConfigToast = false;
            class_374 toastManager = client.method_1566();
            boolean canSendConfig = buf.readBoolean();
            if (canSendConfig) {
                ClientNetworking.sendConfigToServer();
                toastManager.method_1999((class_368)class_370.method_29047((class_310)client, (class_370.class_371)class_370.class_371.field_23774, (class_2561)class_2561.method_43471((String)"bettertrims.config_synced.title"), (class_2561)class_2561.method_43471((String)"bettertrims.config_synced.desc")));
                return;
            }
            refreshScreen = true;
            ClientNetworking.requestConfigFromServer();
            toastManager.method_1999((class_368)class_370.method_29047((class_310)client, (class_370.class_371)class_370.class_371.field_23774, (class_2561)class_2561.method_43471((String)"bettertrims.config_not_synced.title"), (class_2561)class_2561.method_43471((String)"bettertrims.config_not_synced.desc")));
        });
    }

    public static void sendHandshake() {
        ClientPlayNetworking.send((class_2960)Networking.HANDSHAKE, (class_2540)PacketByteBufs.empty());
    }

    public static void trySendConfigToServer() {
        ClientPlayNetworking.send((class_2960)Networking.CONFIG_OP_CHECK, (class_2540)PacketByteBufs.empty());
    }

    public static void sendConfigToServer() {
        ClientPlayNetworking.send((class_2960)Networking.CONFIG_SYNC, (class_2540)PacketByteBufs.create().method_10814(ConfigManager.serializeConfig()));
    }

    private static void requestConfigFromServer() {
        ClientNetworking.sendHandshake();
    }

    public static boolean isConnectedToDedicated() {
        return isConnectedToDedicated;
    }
}

