/*
 * Decompiled with CFR 0.152.
 */
package fuzs.completionistsindex.client.gui.screens.inventory;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import fuzs.completionistsindex.CompletionistsIndex;
import fuzs.completionistsindex.client.gui.screens.inventory.ItemsIndexViewScreen;
import fuzs.completionistsindex.client.gui.screens.inventory.StatsSorting;
import fuzs.puzzleslib.api.client.screen.v2.ScreenHelper;
import fuzs.puzzleslib.api.core.v1.ModLoaderEnvironment;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.StringJoiner;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_2477;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3417;
import net.minecraft.class_344;
import net.minecraft.class_3468;
import net.minecraft.class_3469;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_465;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_6880;
import net.minecraft.class_7919;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public abstract class IndexViewScreen
extends class_437 {
    public static final class_2960 INDEX_LOCATION = CompletionistsIndex.id("textures/gui/index.png");
    private static final class_5250 PREVIOUS_PAGE_COMPONENT = class_2561.method_43471((String)"createWorld.customize.custom.prev");
    private static final class_5250 NEXT_PAGE_COMPONENT = class_2561.method_43471((String)"createWorld.customize.custom.next");
    protected final class_437 lastScreen;
    protected int leftPos;
    protected int topPos;
    private class_4185 turnPageBackwards;
    private class_4185 turnPageForwards;
    private static StatsSorting statsSorting = StatsSorting.CREATIVE;
    private int currentPage;
    private class_2561 leftPageIndicator;
    private class_2561 rightPageIndicator;
    private List<IndexViewPage> pages;
    @Nullable
    private List<class_2561> tooltipLines;

    protected IndexViewScreen(class_437 lastScreen) {
        super((class_2561)class_2561.method_43471((String)"gui.stats"));
        this.lastScreen = lastScreen;
    }

    public Comparator<IndexViewPage.Entry> getComparator() {
        return statsSorting.getComparator();
    }

    protected abstract List<IndexViewPage.Entry> getPageEntries();

    protected void rebuildPages() {
        this.pages = IndexViewPage.createPages(this, this.getPageEntries());
        this.setCurrentPage(0);
    }

    protected void method_25426() {
        this.leftPos = (this.field_22789 - 316) / 2;
        this.topPos = (this.field_22790 - 198) / 2;
        ((class_344)this.method_37063((class_364)new class_344(this.leftPos + 17, this.topPos + 11, 16, 13, 42, 202, 20, INDEX_LOCATION, 512, 256, button -> this.method_25419()))).method_47400(class_7919.method_47407((class_2561)class_5244.field_24339));
        ((class_344)this.method_37063((class_364)new class_344(this.leftPos + 316 - 17 - 16, this.topPos + 11, 16, 13, 62, 202, 20, INDEX_LOCATION, 512, 256, button -> {
            statsSorting = statsSorting.cycle();
            button.method_47400(class_7919.method_47407((class_2561)IndexViewScreen.statsSorting.component));
            this.rebuildPages();
        }))).method_47400(class_7919.method_47407((class_2561)IndexViewScreen.statsSorting.component));
        this.turnPageBackwards = (class_4185)this.method_37063((class_364)new class_344(this.leftPos + 27, this.topPos + 173, 18, 10, 1, 203, 20, INDEX_LOCATION, 512, 256, button -> this.decrementPage()));
        this.turnPageBackwards.method_47400(class_7919.method_47407((class_2561)PREVIOUS_PAGE_COMPONENT));
        this.turnPageForwards = (class_4185)this.method_37063((class_364)new class_344(this.leftPos + 316 - 27 - 18, this.topPos + 173, 18, 10, 21, 203, 20, INDEX_LOCATION, 512, 256, button -> this.incrementPage()));
        this.turnPageForwards.method_47400(class_7919.method_47407((class_2561)NEXT_PAGE_COMPONENT));
        this.setCurrentPage(this.currentPage);
    }

    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float tickDelta) {
        this.tooltipLines = null;
        this.method_25420(guiGraphics);
        this.method_25395(null);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        guiGraphics.method_25290(INDEX_LOCATION, this.leftPos, this.topPos, 0.0f, 0.0f, 316, 198, 512, 256);
        guiGraphics.method_51439(this.field_22793, this.leftPageIndicator, this.leftPos + 82 - this.field_22793.method_27525((class_5348)this.leftPageIndicator) / 2, this.topPos + 13, 12100746, false);
        guiGraphics.method_51439(this.field_22793, this.rightPageIndicator, this.leftPos + 233 - this.field_22793.method_27525((class_5348)this.rightPageIndicator) / 2, this.topPos + 13, 12100746, false);
        super.method_25394(guiGraphics, mouseX, mouseY, tickDelta);
        if (this.pages != null && !this.pages.isEmpty()) {
            this.pages.get(this.currentPage).method_25394(guiGraphics, mouseX, mouseY, tickDelta);
        }
        if (this.tooltipLines != null) {
            guiGraphics.method_51437(this.field_22793, this.tooltipLines, Optional.empty(), mouseX, mouseY);
        }
    }

    public boolean method_25402(double mouseX, double mouseY, int buttonId) {
        if (!super.method_25402(mouseX, mouseY, buttonId) && this.pages != null && !this.pages.isEmpty()) {
            return this.pages.get(this.currentPage).mouseClicked((int)mouseX, (int)mouseY, buttonId);
        }
        return false;
    }

    private void decrementPage() {
        if (this.currentPage > 0) {
            this.setCurrentPage(this.currentPage - 1);
        }
    }

    private void incrementPage() {
        if (this.currentPage < this.getAllPages() - 1) {
            this.setCurrentPage(this.currentPage + 1);
        }
    }

    private void setCurrentPage(int newPage) {
        this.currentPage = newPage;
        this.turnPageForwards.field_22764 = true;
        this.turnPageBackwards.field_22764 = true;
        if (newPage == 0) {
            this.turnPageBackwards.field_22764 = false;
        }
        if (newPage >= this.getAllPages() - 1) {
            this.turnPageForwards.field_22764 = false;
        }
        this.leftPageIndicator = class_2561.method_43469((String)"book.pageIndicator", (Object[])new Object[]{newPage * 2 + 1, this.getAllPages() * 2});
        this.rightPageIndicator = class_2561.method_43469((String)"book.pageIndicator", (Object[])new Object[]{newPage * 2 + 2, this.getAllPages() * 2});
    }

    private int getAllPages() {
        return this.pages != null && !this.pages.isEmpty() ? this.pages.size() : 1;
    }

    public boolean method_25401(double mouseX, double mouseY, double delta) {
        if (delta > 0.0) {
            this.decrementPage();
            return true;
        }
        if (delta < 0.0) {
            this.incrementPage();
            return true;
        }
        return super.method_25401(mouseX, mouseY, delta);
    }

    public void method_25419() {
        this.field_22787.method_1507(this.lastScreen);
    }

    public static class IndexViewPage
    implements class_4068 {
        private static final DecimalFormat PERCENTAGE_FORMAT = new DecimalFormat("#.##");
        private final Entry[] entries = new Entry[14];
        private final IndexViewScreen screen;

        private IndexViewPage(IndexViewScreen screen) {
            this.screen = screen;
        }

        public static List<IndexViewPage> createPages(IndexViewScreen screen, List<Entry> entries) {
            ImmutableList.Builder builder = ImmutableList.builder();
            IndexViewPage page = null;
            int itemsCount = 0;
            for (Entry entry : entries) {
                if (page == null) {
                    page = new IndexViewPage(screen);
                    builder.add((Object)page);
                }
                page.entries[itemsCount] = entry;
                if (++itemsCount < 14) continue;
                itemsCount = 0;
                page = null;
            }
            return builder.build();
        }

        public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
            this.renderPageHalf(guiGraphics, mouseX, mouseY, partialTick, this.screen.leftPos + 16, this.screen.topPos + 26, 0, 7);
            this.renderPageHalf(guiGraphics, mouseX, mouseY, partialTick, this.screen.leftPos + 167, this.screen.topPos + 26, 7, 14);
        }

        private void renderPageHalf(class_332 guiGraphics, int mouseX, int mouseY, float partialTick, int startX, int startY, int startIndex, int endIndex) {
            Entry entry;
            guiGraphics.method_51448().method_22903();
            guiGraphics.method_51448().method_46416((float)startX, (float)startY, 0.0f);
            for (int i = startIndex; i < endIndex && (entry = this.entries[i]) != null; ++i) {
                int mouseXOffset = mouseX - startX;
                int mouseYOffset = mouseY - startY - i % 7 * 21;
                class_310 minecraft = ScreenHelper.INSTANCE.getMinecraft((class_437)this.screen);
                entry.render(minecraft, guiGraphics, mouseXOffset, mouseYOffset, partialTick);
                if (entry.tryRenderTooltip(guiGraphics, mouseXOffset, mouseYOffset)) {
                    this.screen.tooltipLines = entry.getTooltipLines();
                }
                guiGraphics.method_51448().method_46416(0.0f, 21.0f, 0.0f);
            }
            guiGraphics.method_51448().method_22909();
        }

        public boolean mouseClicked(int mouseX, int mouseY, int buttonId) {
            for (int i = 0; i < this.entries.length; ++i) {
                int startY;
                Entry entry = this.entries[i];
                if (entry == null) {
                    return false;
                }
                int startX = i >= 7 ? this.screen.leftPos + 167 : this.screen.leftPos + 16;
                if (!entry.isMouseOver(mouseX - startX, mouseY - (startY = this.screen.topPos + 26) - i % 7 * 21)) continue;
                return entry.mouseClicked(this.screen, mouseX, mouseY, buttonId);
            }
            return false;
        }

        public static Entry modItemEntry(String modId, List<class_1799> items, class_3469 statsCounter, class_327 font) {
            if (items.isEmpty()) {
                throw new IllegalArgumentException("items cannot be empty");
            }
            class_5250 modName = modId.equals("__ALL__") ? class_2561.method_43471((String)"gui.all") : class_2561.method_43470((String)ModLoaderEnvironment.INSTANCE.getModName(modId).orElse(IndexViewPage.prettifyModId(modId)));
            class_1799 displayItem = (class_1799)items.stream().skip((int)(Math.random() * (double)items.size())).findAny().orElseThrow();
            long collectedCount = items.stream().filter(stack -> {
                int crafted;
                int pickedUp = statsCounter.method_15024(class_3468.field_15392, (Object)stack.method_7909());
                return pickedUp + (crafted = statsCounter.method_15024(class_3468.field_15370, (Object)stack.method_7909())) > 0;
            }).count();
            boolean collected = collectedCount == (long)items.size();
            float collectionProgress = (float)collectedCount / (float)items.size();
            class_5250 tooltipComponent = class_2561.method_43473().method_10852((class_2561)modName).method_10852((class_2561)class_2561.method_43470((String)(" (" + PERCENTAGE_FORMAT.format(collectionProgress * 100.0f) + "%)")).method_27692(class_124.field_1065));
            return new ModItemEntry(displayItem, IndexViewPage.formatDisplayName(font, (class_2561)modName, collected), collected, List.of(tooltipComponent), (class_2561)class_2561.method_43470((String)(collectedCount + "/" + items.size())), collectionProgress, items);
        }

        private static String prettifyModId(String modId) {
            String[] parts;
            StringJoiner joiner = new StringJoiner(" ");
            for (String part : parts = modId.split("_")) {
                if (part.isEmpty()) continue;
                joiner.add(Character.toUpperCase(part.charAt(0)) + part.substring(1).toLowerCase(Locale.ROOT));
            }
            return joiner.toString();
        }

        public static Entry statsItemEntry(class_1799 stack, class_3469 statsCounter, class_327 font) {
            int pickedUp = statsCounter.method_15024(class_3468.field_15392, (Object)stack.method_7909());
            int crafted = statsCounter.method_15024(class_3468.field_15370, (Object)stack.method_7909());
            boolean collected = pickedUp > 0 || crafted > 0;
            class_2561 displayName = stack.method_7909().method_7864(stack);
            class_5348 formattedName = IndexViewPage.formatDisplayName(font, displayName, collected);
            ArrayList lines = Lists.newArrayList();
            lines.add(class_2561.method_43473().method_10852(stack.method_7909().method_7864(stack)).method_27692(stack.method_7932().field_8908));
            stack.method_7909().method_7851(stack, null, (List)lines, (class_1836)class_1836.field_41070);
            if (pickedUp > 0) {
                lines.add(class_2561.method_43470((String)String.valueOf(pickedUp)).method_27693(" ").method_10852((class_2561)class_2561.method_43471((String)"stat_type.minecraft.picked_up")).method_27692(class_124.field_1078));
            }
            if (crafted > 0) {
                lines.add(class_2561.method_43470((String)String.valueOf(crafted)).method_27693(" ").method_10852((class_2561)class_2561.method_43471((String)"stat_type.minecraft.crafted")).method_27692(class_124.field_1078));
            }
            return new StatsItemEntry(stack, formattedName, collected, (List<class_2561>)ImmutableList.copyOf((Collection)lines));
        }

        private static class_5348 formatDisplayName(class_327 font, class_2561 displayName, boolean collected) {
            class_2583 style = class_2583.field_24360.method_36139(collected ? 4957487 : class_124.field_1074.method_532());
            Object formattedText = font.method_27525((class_5348)displayName) > 95 ? class_5348.method_29433((class_5348[])new class_5348[]{font.method_27527().method_27490((class_5348)displayName, 95 - font.method_1727("..."), style), class_2561.method_43470((String)"...").method_27696(style)}) : class_2561.method_43473().method_10852(displayName).method_27696(style);
            return formattedText;
        }

        public static abstract class Entry {
            final class_1799 item;
            final class_5348 displayName;
            private final boolean collected;
            private final List<class_2561> tooltipLines;

            private Entry(class_1799 item, class_5348 displayName, boolean collected, List<class_2561> tooltipLines) {
                this.item = item;
                this.displayName = displayName;
                this.collected = collected;
                this.tooltipLines = tooltipLines;
            }

            public abstract <T extends Comparable<? super T>> T toComparableKey();

            public boolean isCollected() {
                return this.collected;
            }

            List<class_2561> getTooltipLines() {
                return this.tooltipLines;
            }

            public void render(class_310 minecraft, class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
                this.renderBackground(guiGraphics, mouseX, mouseY, partialTick);
                this.renderForeground(minecraft, guiGraphics, mouseX, mouseY, partialTick);
            }

            public boolean tryRenderTooltip(class_332 guiGraphics, int mouseX, int mouseY) {
                if (this.isHovering(0, 0, 18, 18, mouseX, mouseY)) {
                    class_465.method_33285((class_332)guiGraphics, (int)1, (int)1, (int)0);
                    return true;
                }
                return false;
            }

            public boolean isMouseOver(int mouseX, int mouseY) {
                return this.isHovering(0, 0, 134, 18, mouseX, mouseY);
            }

            public boolean mouseClicked(IndexViewScreen screen, int mouseX, int mouseY, int buttonId) {
                return false;
            }

            private boolean isHovering(int minX, int minY, int maxX, int maxY, int mouseX, int mouseY) {
                return mouseX > minX && mouseX <= maxX && mouseY > minY && mouseY <= maxY;
            }

            public void renderBackground(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                guiGraphics.method_25290(INDEX_LOCATION, 0, 0, 120.0f, 208.0f, 18, 18, 512, 256);
                guiGraphics.method_25290(INDEX_LOCATION, 124, 4, (float)(120 + (this.collected ? 10 : 0)), 198.0f, 10, 10, 512, 256);
            }

            public void renderForeground(class_310 minecraft, class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
                guiGraphics.method_51427(this.item, 1, 1);
            }
        }

        public static class ModItemEntry
        extends Entry {
            private final class_2561 collection;
            private final float collectionProgress;
            private final List<class_1799> items;

            public ModItemEntry(class_1799 item, class_5348 displayName, boolean collected, List<class_2561> tooltipLines, class_2561 collection, float collectionProgress, List<class_1799> items) {
                super(item, displayName, collected, tooltipLines);
                this.collection = collection;
                this.collectionProgress = collectionProgress;
                this.items = items;
            }

            @Override
            public <T extends Comparable<? super T>> T toComparableKey() {
                return (T)this.displayName.getString();
            }

            @Override
            public void renderBackground(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
                super.renderBackground(guiGraphics, mouseX, mouseY, partialTick);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                guiGraphics.method_25290(INDEX_LOCATION, 24, 11, 140.0f, 198.0f, 91, 5, 512, 256);
                guiGraphics.method_25290(INDEX_LOCATION, 24, 11, 140.0f, 203.0f, (int)(91.0f * this.collectionProgress), 5, 512, 256);
                if (this.isMouseOver(mouseX, mouseY)) {
                    guiGraphics.method_25290(INDEX_LOCATION, -2, -2, 316.0f, 0.0f, 140, 22, 512, 256);
                }
            }

            @Override
            public void renderForeground(class_310 minecraft, class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
                super.renderForeground(minecraft, guiGraphics, mouseX, mouseY, partialTick);
                class_327 font = minecraft.field_1772;
                int posX = 70 - font.method_27525(this.displayName) / 2;
                guiGraphics.method_51430(font, class_2477.method_10517().method_30934(this.displayName), posX, 0, 0, false);
                posX = 70 - font.method_27525((class_5348)this.collection) / 2;
                guiGraphics.method_51439(font, this.collection, posX - 1, 10, 0, false);
                guiGraphics.method_51439(font, this.collection, posX, 9, 0, false);
                guiGraphics.method_51439(font, this.collection, posX, 11, 0, false);
                guiGraphics.method_51439(font, this.collection, posX + 1, 10, 0, false);
                guiGraphics.method_51439(font, this.collection, posX, 10, 16762624, false);
            }

            @Override
            public boolean mouseClicked(IndexViewScreen screen, int mouseX, int mouseY, int buttonId) {
                class_310 minecraft = ScreenHelper.INSTANCE.getMinecraft((class_437)screen);
                minecraft.method_1507((class_437)new ItemsIndexViewScreen(screen, this.items));
                minecraft.method_1483().method_4873((class_1113)class_1109.method_47978((class_6880)class_3417.field_15015, (float)1.0f));
                return true;
            }
        }

        private static class StatsItemEntry
        extends Entry {
            public StatsItemEntry(class_1799 item, class_5348 displayName, boolean collected, List<class_2561> tooltipLines) {
                super(item, displayName, collected, tooltipLines);
            }

            @Override
            public <T extends Comparable<? super T>> T toComparableKey() {
                return (T)class_7923.field_41178.method_10221((Object)this.item.method_7909()).method_12832();
            }

            @Override
            public void renderForeground(class_310 minecraft, class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
                super.renderForeground(minecraft, guiGraphics, mouseX, mouseY, partialTick);
                guiGraphics.method_51430(minecraft.field_1772, class_2477.method_10517().method_30934(this.displayName), 23, 5, 0, false);
            }
        }
    }
}

