/*
 * Decompiled with CFR 0.152.
 */
package com.kneelawk.extramodintegrations.tconstruct.recipe.casting;

import com.kneelawk.extramodintegrations.tconstruct.Util;
import dev.emi.emi.api.recipe.BasicEmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.render.EmiTexture;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.TankWidget;
import dev.emi.emi.api.widget.Widget;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_1860;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.recipe.casting.IDisplayableCastingRecipe;

public abstract class AbstractCastingEmiRecipe
extends BasicEmiRecipe {
    public static final class_2960 BACKGROUND_LOC = TConstruct.getResource((String)"textures/gui/jei/casting.png");
    private static final String KEY_COOLING_TIME = TConstruct.makeTranslationKey((String)"jei", (String)"time");
    private static final String KEY_CAST_KEPT = TConstruct.makeTranslationKey((String)"jei", (String)"casting.cast_kept");
    private static final String KEY_CAST_CONSUMED = TConstruct.makeTranslationKey((String)"jei", (String)"casting.cast_consumed");
    protected final EmiIngredient fluidInput;
    protected final EmiIngredient castItem;
    protected final boolean castIsConsumed;
    protected final boolean hasCast;
    protected final int coolingTime;
    protected final EmiTexture block;

    public AbstractCastingEmiRecipe(EmiRecipeCategory category, IDisplayableCastingRecipe recipe, EmiTexture block) {
        class_2960 class_29602;
        if (recipe instanceof class_1860) {
            class_1860 r = (class_1860)recipe;
            class_29602 = r.method_8114();
        } else {
            class_29602 = null;
        }
        super(category, class_29602, 117, 54);
        this.fluidInput = EmiIngredient.of(recipe.getFluids().stream().map(Util::convertFluid).toList());
        this.castItem = EmiIngredient.of(recipe.getCastItems().stream().map(EmiStack::of).toList());
        this.outputs = List.of(EmiStack.of((class_1799)recipe.getOutput()));
        this.castIsConsumed = recipe.isConsumed();
        this.hasCast = recipe.hasCast();
        this.coolingTime = recipe.getCoolingTime();
        this.block = block;
    }

    public List<EmiIngredient> getInputs() {
        return this.castIsConsumed ? List.of(this.fluidInput, this.castItem) : List.of(this.fluidInput);
    }

    public List<EmiIngredient> getCatalysts() {
        return this.castIsConsumed ? List.of() : List.of(this.castItem);
    }

    public void addWidgets(WidgetHolder widgets) {
        widgets.addTexture(BACKGROUND_LOC, 0, 0, 117, 54, 0, 0);
        if (!this.castItem.isEmpty()) {
            widgets.addSlot(this.castItem, 37, 18).drawBack(false).catalyst(!this.castIsConsumed);
        }
        widgets.addSlot((EmiIngredient)this.outputs.get(0), 92, 17).drawBack(false).recipeContext((EmiRecipe)this);
        ((TankWidget)widgets.add((Widget)new TankWidget(this.fluidInput, 2, 2, 34, 34, 81000L))).drawBack(false);
        int h = this.hasCast ? 11 : 27;
        ((TankWidget)widgets.add((Widget)new TankWidget(this.fluidInput, 42, 7, 8, h + 2, 1L))).drawBack(false);
        widgets.addFillingArrow(58, 18, this.coolingTime * 50).tooltipText(List.of(class_2561.method_43469((String)KEY_COOLING_TIME, (Object[])new Object[]{this.coolingTime / 20})));
        widgets.addTexture(this.block, 38, 35);
    }
}

