/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.spark.fabric.plugin;

import java.util.List;
import java.util.Set;
import me.lucko.spark.fabric.smap.SourceDebugCache;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.tree.ClassNode;
import org.spongepowered.asm.mixin.MixinEnvironment;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;
import org.spongepowered.asm.mixin.transformer.IMixinTransformer;
import org.spongepowered.asm.mixin.transformer.ext.Extensions;
import org.spongepowered.asm.mixin.transformer.ext.IExtension;
import org.spongepowered.asm.mixin.transformer.ext.IExtensionRegistry;
import org.spongepowered.asm.mixin.transformer.ext.ITargetClassContext;

public class FabricSparkMixinPlugin
implements IMixinConfigPlugin,
IExtension {
    private static final Logger LOGGER = LogManager.getLogger((String)"spark");

    public void onLoad(String mixinPackage) {
        IMixinTransformer transformer;
        IExtensionRegistry iExtensionRegistry;
        Object activeTransformer = MixinEnvironment.getCurrentEnvironment().getActiveTransformer();
        if (activeTransformer instanceof IMixinTransformer && (iExtensionRegistry = (transformer = (IMixinTransformer)activeTransformer).getExtensions()) instanceof Extensions) {
            Extensions extensions = (Extensions)iExtensionRegistry;
            extensions.add((IExtension)this);
        } else {
            LOGGER.error("Failed to initialize SMAP parser for spark profiler. Mod information for mixin injected methods is now only available with the async-profiler engine.");
        }
    }

    public void export(MixinEnvironment env, String name, boolean force, ClassNode classNode) {
        SourceDebugCache.put(name, classNode);
    }

    public String getRefMapperConfig() {
        return null;
    }

    public boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        return true;
    }

    public void acceptTargets(Set<String> myTargets, Set<String> otherTargets) {
    }

    public List<String> getMixins() {
        return null;
    }

    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    public boolean checkActive(MixinEnvironment environment) {
        return true;
    }

    public void preApply(ITargetClassContext context) {
    }

    public void postApply(ITargetClassContext context) {
    }
}

