/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.spelunkery.worldgen.features;

import com.mojang.serialization.Codec;
import com.ordana.spelunkery.configs.CommonConfigs;
import com.ordana.spelunkery.reg.ModBlocks;
import com.ordana.spelunkery.worldgen.feature_configs.BlockStripeFeatureConfig;
import com.ordana.spelunkery.worldgen.feature_configs.util.FastNoiseLite;
import com.ordana.spelunkery.worldgen.feature_configs.util.StoneEntry;
import com.ordana.spelunkery.worldgen.feature_configs.util.StonePattern;
import java.util.List;
import java.util.Random;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2794;
import net.minecraft.class_2902;
import net.minecraft.class_3031;
import net.minecraft.class_3532;
import net.minecraft.class_5281;
import net.minecraft.class_5821;
import net.minecraft.class_6880;

public class BlockStripeFeature
extends class_3031<BlockStripeFeatureConfig> {
    public BlockStripeFeature(Codec<BlockStripeFeatureConfig> codec) {
        super(codec);
    }

    public boolean method_13151(class_5821<BlockStripeFeatureConfig> context) {
        if (!CommonConfigs.STONE_STRIPE_FEATURES.get().booleanValue()) {
            return false;
        }
        BlockStripeFeatureConfig config = (BlockStripeFeatureConfig)context.method_33656();
        class_2338 originPos = context.method_33655();
        class_5281 worldGenLevel = context.method_33652();
        class_2794 chunkGenerator = context.method_33653();
        class_2791 cachedChunk = worldGenLevel.method_22350(originPos);
        FastNoiseLite cellNoise = new FastNoiseLite();
        cellNoise.SetNoiseType(FastNoiseLite.NoiseType.Cellular);
        cellNoise.SetCellularReturnType(FastNoiseLite.CellularReturnType.CellValue);
        cellNoise.SetDomainWarpType(FastNoiseLite.DomainWarpType.OpenSimplex2);
        cellNoise.SetRotationType3D(FastNoiseLite.RotationType3D.ImproveXZPlanes);
        cellNoise.SetFrequency(0.01f);
        cellNoise.SetFractalOctaves(1);
        FastNoiseLite cellBufferNoise = new FastNoiseLite();
        cellBufferNoise.SetNoiseType(FastNoiseLite.NoiseType.Cellular);
        cellBufferNoise.SetCellularReturnType(FastNoiseLite.CellularReturnType.Distance2Div);
        cellBufferNoise.SetDomainWarpType(FastNoiseLite.DomainWarpType.OpenSimplex2);
        cellBufferNoise.SetRotationType3D(FastNoiseLite.RotationType3D.ImproveXZPlanes);
        cellBufferNoise.SetFrequency(0.01f);
        cellBufferNoise.SetFractalOctaves(1);
        FastNoiseLite noise = new FastNoiseLite();
        noise.SetDomainWarpType(FastNoiseLite.DomainWarpType.OpenSimplex2);
        noise.SetRotationType3D(FastNoiseLite.RotationType3D.ImproveXZPlanes);
        noise.SetFrequency(0.03f);
        noise.SetDomainWarpAmp(1.5f);
        FastNoiseLite.Vector3 domainWarpedVector = new FastNoiseLite.Vector3(0.0, 0.0, 0.0);
        noise.SetFractalOctaves(1);
        int getX = originPos.method_10263() & 0xFFFFFFF0;
        int getZ = originPos.method_10260() & 0xFFFFFFF0;
        int minY = chunkGenerator.method_33730();
        for (int x = getX; x < getX + 16; ++x) {
            for (int z = getZ; z < getZ + 16; ++z) {
                class_2338 currentPos;
                if (originPos.method_10264() == minY && CommonConfigs.PORTAL_FLUID_OCEAN.get().booleanValue() && cachedChunk.method_8320(currentPos = new class_2338(x, minY, z)).method_26215()) {
                    worldGenLevel.method_8652(currentPos, ModBlocks.PORTAL_FLUID.get().method_9564(), 2);
                }
                int heightmap = worldGenLevel.method_8624(class_2902.class_2903.field_13195, x, z);
                for (int y = chunkGenerator.method_33730(); y < heightmap - config.surfaceOffset; ++y) {
                    class_6880 biome;
                    class_2338 currentPos2 = new class_2338(x, y, z);
                    class_2680 currentState = cachedChunk.method_8320(currentPos2);
                    boolean isTarget1 = currentState.method_40143(config.firstTarget);
                    boolean isTarget2 = false;
                    if (config.secondTarget != null && config.secondTargetPlacer != null) {
                        boolean bl = isTarget2 = config.useSecondTarget && currentState.method_40143(config.secondTarget);
                    }
                    if (!isTarget1 && !isTarget2) continue;
                    domainWarpedVector.x = x;
                    domainWarpedVector.y = y;
                    domainWarpedVector.z = z;
                    noise.DomainWarp(domainWarpedVector);
                    float cellValue = cellNoise.GetNoise(domainWarpedVector.x, domainWarpedVector.y, domainWarpedVector.z);
                    cellValue = cellValue * 0.5f + 0.5f;
                    int stoneIndex = class_3532.method_15375((float)(cellValue * (float)config.firstTargetPlacer.size()));
                    float seed = cellValue * 1000000.0f;
                    Random patchRandom = new Random((long)seed);
                    boolean isBlankPatch = patchRandom.nextFloat() < config.blankPatchChance || (double)cellBufferNoise.GetNoise(domainWarpedVector.x, domainWarpedVector.y, domainWarpedVector.z) > -0.1;
                    boolean passesBiomeFilter = true;
                    if (config.biomes != null && config.useBiomeFilter && !config.biomes.method_40241(biome = worldGenLevel.method_23753(currentPos2))) {
                        passesBiomeFilter = false;
                    }
                    if (!passesBiomeFilter || isBlankPatch || config.useHeightFilter && y <= cachedChunk.method_12005(class_2902.class_2903.field_13194, x, z) - config.bottomOffset) continue;
                    List<StoneEntry> patternList = null;
                    if (isTarget1) {
                        patternList = config.firstTargetPlacer;
                    } else if (isTarget2) {
                        patternList = config.secondTargetPlacer;
                    }
                    if (patternList == null) continue;
                    StoneEntry stoneEntry = patternList.get(stoneIndex);
                    StonePattern stonePattern = stoneEntry.getStonePattern();
                    if (stonePattern.shouldPlacePrimaryStone(currentPos2)) {
                        worldGenLevel.method_8652(currentPos2, stoneEntry.getPrimaryStoneState(worldGenLevel, currentPos2), 2);
                        continue;
                    }
                    if (!stonePattern.shouldPlaceSecondaryStone(currentPos2)) continue;
                    worldGenLevel.method_8652(currentPos2, stoneEntry.getSecondaryStoneState(worldGenLevel, currentPos2), 2);
                }
            }
        }
        return false;
    }
}

