/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.spelunkery.blocks.rock_salt;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.ordana.spelunkery.reg.ModTags;
import java.util.Map;
import net.minecraft.class_10;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2415;
import net.minecraft.class_2470;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_2773;
import net.minecraft.class_3218;
import net.minecraft.class_3726;
import net.minecraft.class_3727;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;

public class SaltBlock
extends class_2248 {
    public static final class_2754<class_2773> NORTH = class_2741.field_12495;
    public static final class_2754<class_2773> EAST = class_2741.field_12523;
    public static final class_2754<class_2773> SOUTH = class_2741.field_12551;
    public static final class_2754<class_2773> WEST = class_2741.field_12504;
    public static final Map<class_2350, class_2754<class_2773>> PROPERTY_BY_DIRECTION = Maps.newEnumMap((Map)ImmutableMap.of((Object)class_2350.field_11043, NORTH, (Object)class_2350.field_11034, EAST, (Object)class_2350.field_11035, SOUTH, (Object)class_2350.field_11039, WEST));
    private static final class_265 SHAPE_DOT = class_2248.method_9541((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)1.0, (double)13.0);
    private static final Map<class_2350, class_265> SHAPES_FLOOR = Maps.newEnumMap((Map)ImmutableMap.of((Object)class_2350.field_11043, (Object)class_2248.method_9541((double)3.0, (double)0.0, (double)0.0, (double)13.0, (double)1.0, (double)13.0), (Object)class_2350.field_11035, (Object)class_2248.method_9541((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)1.0, (double)16.0), (Object)class_2350.field_11034, (Object)class_2248.method_9541((double)3.0, (double)0.0, (double)3.0, (double)16.0, (double)1.0, (double)13.0), (Object)class_2350.field_11039, (Object)class_2248.method_9541((double)0.0, (double)0.0, (double)3.0, (double)13.0, (double)1.0, (double)13.0)));
    private static final Map<class_2350, class_265> SHAPES_UP = Maps.newEnumMap((Map)ImmutableMap.of((Object)class_2350.field_11043, (Object)class_259.method_1084((class_265)SHAPES_FLOOR.get(class_2350.field_11043), (class_265)class_2248.method_9541((double)3.0, (double)0.0, (double)0.0, (double)13.0, (double)16.0, (double)1.0)), (Object)class_2350.field_11035, (Object)class_259.method_1084((class_265)SHAPES_FLOOR.get(class_2350.field_11035), (class_265)class_2248.method_9541((double)3.0, (double)0.0, (double)15.0, (double)13.0, (double)16.0, (double)16.0)), (Object)class_2350.field_11034, (Object)class_259.method_1084((class_265)SHAPES_FLOOR.get(class_2350.field_11034), (class_265)class_2248.method_9541((double)15.0, (double)0.0, (double)3.0, (double)16.0, (double)16.0, (double)13.0)), (Object)class_2350.field_11039, (Object)class_259.method_1084((class_265)SHAPES_FLOOR.get(class_2350.field_11039), (class_265)class_2248.method_9541((double)0.0, (double)0.0, (double)3.0, (double)1.0, (double)16.0, (double)13.0))));
    private final Map<class_2680, class_265> SHAPES_CACHE;
    private final class_2680 crossState;

    public SaltBlock(class_4970.class_2251 properties) {
        super(properties);
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)this.field_10647.method_11664()).method_11657(NORTH, (Comparable)class_2773.field_12687)).method_11657(EAST, (Comparable)class_2773.field_12687)).method_11657(SOUTH, (Comparable)class_2773.field_12687)).method_11657(WEST, (Comparable)class_2773.field_12687));
        this.crossState = (class_2680)((class_2680)((class_2680)((class_2680)this.method_9564().method_11657(NORTH, (Comparable)class_2773.field_12689)).method_11657(EAST, (Comparable)class_2773.field_12689)).method_11657(SOUTH, (Comparable)class_2773.field_12689)).method_11657(WEST, (Comparable)class_2773.field_12689);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (class_2680 blockstate : this.method_9595().method_11662()) {
            builder.put((Object)blockstate, (Object)this.calculateVoxelShape(blockstate));
        }
        this.SHAPES_CACHE = builder.build();
    }

    public void method_9514(class_2680 state, class_3218 level, class_2338 pos, class_5819 random) {
        if (level.method_8520(pos.method_10084())) {
            class_2680 belowState = level.method_8320(pos.method_10074());
            level.method_22352(pos, false);
            if (belowState.method_27852(class_2246.field_10219) || belowState.method_27852(class_2246.field_10402)) {
                level.method_8652(pos.method_10074(), class_2246.field_10253.method_9564(), 3);
            }
        }
    }

    public class_265 method_9549(class_2680 state, class_1922 level, class_2338 pos, class_3726 context) {
        class_1309 livingEntity;
        class_3727 c;
        class_1297 e;
        if (context instanceof class_3727 && (e = (c = (class_3727)context).method_32480()) instanceof class_1309 && (livingEntity = (class_1309)e).method_5999()) {
            return class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)24.0, (double)16.0);
        }
        return class_259.method_1073();
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{NORTH, EAST, SOUTH, WEST});
    }

    private class_265 calculateVoxelShape(class_2680 state) {
        class_265 voxelshape = SHAPE_DOT;
        for (class_2350 direction : class_2350.class_2353.field_11062) {
            class_2773 redstoneside = (class_2773)state.method_11654((class_2769)PROPERTY_BY_DIRECTION.get(direction));
            if (redstoneside == class_2773.field_12689) {
                voxelshape = class_259.method_1084((class_265)voxelshape, (class_265)SHAPES_FLOOR.get(direction));
                continue;
            }
            if (redstoneside != class_2773.field_12686) continue;
            voxelshape = class_259.method_1084((class_265)voxelshape, (class_265)SHAPES_UP.get(direction));
        }
        return voxelshape;
    }

    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return this.SHAPES_CACHE.get(state);
    }

    public class_2680 method_9605(class_1750 context) {
        return this.getConnectionState((class_1922)context.method_8045(), this.crossState, context.method_8037());
    }

    private class_2680 getConnectionState(class_1922 world, class_2680 state, class_2338 pos) {
        boolean flag = SaltBlock.isDot(state);
        state = this.getMissingConnections(world, this.method_9564(), pos);
        if (!flag || !SaltBlock.isDot(state)) {
            boolean flag6;
            boolean flag1 = ((class_2773)state.method_11654(NORTH)).method_27855();
            boolean flag2 = ((class_2773)state.method_11654(SOUTH)).method_27855();
            boolean flag3 = ((class_2773)state.method_11654(EAST)).method_27855();
            boolean flag4 = ((class_2773)state.method_11654(WEST)).method_27855();
            boolean flag5 = !flag1 && !flag2;
            boolean bl = flag6 = !flag3 && !flag4;
            if (!flag4 && flag5) {
                state = (class_2680)state.method_11657(WEST, (Comparable)class_2773.field_12689);
            }
            if (!flag3 && flag5) {
                state = (class_2680)state.method_11657(EAST, (Comparable)class_2773.field_12689);
            }
            if (!flag1 && flag6) {
                state = (class_2680)state.method_11657(NORTH, (Comparable)class_2773.field_12689);
            }
            if (!flag2 && flag6) {
                state = (class_2680)state.method_11657(SOUTH, (Comparable)class_2773.field_12689);
            }
        }
        return state;
    }

    private class_2680 getMissingConnections(class_1922 world, class_2680 state, class_2338 pos) {
        boolean flag = !world.method_8320(pos.method_10084()).method_26212(world, pos);
        for (class_2350 direction : class_2350.class_2353.field_11062) {
            if (((class_2773)state.method_11654((class_2769)PROPERTY_BY_DIRECTION.get(direction))).method_27855()) continue;
            class_2773 redstoneside = this.getConnectingSide(world, pos, direction, flag);
            state = (class_2680)state.method_11657((class_2769)PROPERTY_BY_DIRECTION.get(direction), (Comparable)redstoneside);
        }
        return state;
    }

    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 otherState, class_1936 world, class_2338 pos, class_2338 otherPos) {
        class_2773 redstoneside;
        class_2680 newState = direction == class_2350.field_11033 ? (this.method_9558(state, (class_4538)world, pos) ? state : class_2246.field_10124.method_9564()) : (direction == class_2350.field_11036 ? this.getConnectionState((class_1922)world, state, pos) : ((redstoneside = this.getConnectingSide((class_1922)world, pos, direction)).method_27855() == ((class_2773)state.method_11654((class_2769)PROPERTY_BY_DIRECTION.get(direction))).method_27855() && !SaltBlock.isCross(state) ? (class_2680)state.method_11657((class_2769)PROPERTY_BY_DIRECTION.get(direction), (Comparable)redstoneside) : this.getConnectionState((class_1922)world, (class_2680)this.crossState.method_11657((class_2769)PROPERTY_BY_DIRECTION.get(direction), (Comparable)redstoneside), pos)));
        return newState;
    }

    private static boolean isCross(class_2680 state) {
        return ((class_2773)state.method_11654(NORTH)).method_27855() && ((class_2773)state.method_11654(SOUTH)).method_27855() && ((class_2773)state.method_11654(EAST)).method_27855() && ((class_2773)state.method_11654(WEST)).method_27855();
    }

    private static boolean isDot(class_2680 state) {
        return !((class_2773)state.method_11654(NORTH)).method_27855() && !((class_2773)state.method_11654(SOUTH)).method_27855() && !((class_2773)state.method_11654(EAST)).method_27855() && !((class_2773)state.method_11654(WEST)).method_27855();
    }

    public void method_9517(class_2680 state, class_1936 world, class_2338 pos, int var1, int var2) {
        class_2338.class_2339 mutable = new class_2338.class_2339();
        for (class_2350 direction : class_2350.class_2353.field_11062) {
            class_2773 redstoneside = (class_2773)state.method_11654((class_2769)PROPERTY_BY_DIRECTION.get(direction));
            if (redstoneside == class_2773.field_12687 || world.method_8320((class_2338)mutable.method_25505((class_2382)pos, direction)).method_27852((class_2248)this)) continue;
            mutable.method_10098(class_2350.field_11033);
            class_2680 blockstate = world.method_8320((class_2338)mutable);
            if (!blockstate.method_27852(class_2246.field_10282)) {
                class_2338 blockpos = mutable.method_10093(direction.method_10153());
                class_2680 blockstate1 = blockstate.method_26191(direction.method_10153(), world.method_8320(blockpos), world, (class_2338)mutable, blockpos);
                SaltBlock.method_9611((class_2680)blockstate, (class_2680)blockstate1, (class_1936)world, (class_2338)mutable, (int)var1, (int)var2);
            }
            mutable.method_25505((class_2382)pos, direction).method_10098(class_2350.field_11036);
            class_2680 blockstate3 = world.method_8320((class_2338)mutable);
            if (blockstate3.method_27852(class_2246.field_10282)) continue;
            class_2338 pos1 = mutable.method_10093(direction.method_10153());
            class_2680 blockstate2 = blockstate3.method_26191(direction.method_10153(), world.method_8320(pos1), world, (class_2338)mutable, pos1);
            SaltBlock.method_9611((class_2680)blockstate3, (class_2680)blockstate2, (class_1936)world, (class_2338)mutable, (int)var1, (int)var2);
        }
    }

    private class_2773 getConnectingSide(class_1922 world, class_2338 pos, class_2350 dir) {
        return this.getConnectingSide(world, pos, dir, !world.method_8320(pos.method_10084()).method_26212(world, pos));
    }

    private class_2773 getConnectingSide(class_1922 world, class_2338 pos, class_2350 dir, boolean canClimbUp) {
        boolean flag;
        class_2338 blockpos = pos.method_10093(dir);
        class_2680 blockstate = world.method_8320(blockpos);
        if (canClimbUp && (flag = this.canSurviveOn(world, blockpos, blockstate)) && this.canConnectTo(world.method_8320(blockpos.method_10084()), world, blockpos.method_10084(), null)) {
            if (blockstate.method_26206(world, blockpos, dir.method_10153())) {
                return class_2773.field_12686;
            }
            return class_2773.field_12689;
        }
        return !this.canConnectTo(blockstate, world, blockpos, dir) && (blockstate.method_26212(world, blockpos) || !this.canConnectTo(world.method_8320(blockpos.method_10074()), world, blockpos.method_10074(), null)) ? class_2773.field_12687 : class_2773.field_12689;
    }

    public boolean method_9558(class_2680 state, class_4538 world, class_2338 pos) {
        class_2338 blockpos = pos.method_10074();
        class_2680 blockstate = world.method_8320(blockpos);
        return this.canSurviveOn((class_1922)world, blockpos, blockstate);
    }

    private boolean canSurviveOn(class_1922 world, class_2338 pos, class_2680 state) {
        return state.method_26206(world, pos, class_2350.field_11036) || state.method_27852(class_2246.field_10312);
    }

    protected boolean canConnectTo(class_2680 state, class_1922 world, class_2338 pos, @Nullable class_2350 dir) {
        class_2248 b = state.method_26204();
        return state.method_26164(ModTags.SALT_BLOCKS) || state.method_27852((class_2248)this);
    }

    public class_2680 method_9598(class_2680 state, class_2470 rotation) {
        return switch (rotation) {
            case class_2470.field_11464 -> (class_2680)((class_2680)((class_2680)((class_2680)state.method_11657(NORTH, (Comparable)((class_2773)state.method_11654(SOUTH)))).method_11657(EAST, (Comparable)((class_2773)state.method_11654(WEST)))).method_11657(SOUTH, (Comparable)((class_2773)state.method_11654(NORTH)))).method_11657(WEST, (Comparable)((class_2773)state.method_11654(EAST)));
            case class_2470.field_11465 -> (class_2680)((class_2680)((class_2680)((class_2680)state.method_11657(NORTH, (Comparable)((class_2773)state.method_11654(EAST)))).method_11657(EAST, (Comparable)((class_2773)state.method_11654(SOUTH)))).method_11657(SOUTH, (Comparable)((class_2773)state.method_11654(WEST)))).method_11657(WEST, (Comparable)((class_2773)state.method_11654(NORTH)));
            case class_2470.field_11463 -> (class_2680)((class_2680)((class_2680)((class_2680)state.method_11657(NORTH, (Comparable)((class_2773)state.method_11654(WEST)))).method_11657(EAST, (Comparable)((class_2773)state.method_11654(NORTH)))).method_11657(SOUTH, (Comparable)((class_2773)state.method_11654(EAST)))).method_11657(WEST, (Comparable)((class_2773)state.method_11654(SOUTH)));
            default -> state;
        };
    }

    public class_2680 method_9569(class_2680 state, class_2415 mirror) {
        return switch (mirror) {
            case class_2415.field_11300 -> (class_2680)((class_2680)state.method_11657(NORTH, (Comparable)((class_2773)state.method_11654(SOUTH)))).method_11657(SOUTH, (Comparable)((class_2773)state.method_11654(NORTH)));
            case class_2415.field_11301 -> (class_2680)((class_2680)state.method_11657(EAST, (Comparable)((class_2773)state.method_11654(WEST)))).method_11657(WEST, (Comparable)((class_2773)state.method_11654(EAST)));
            default -> super.method_9569(state, mirror);
        };
    }

    public void method_9615(class_2680 state, class_1937 world, class_2338 pos, class_2680 oldState, boolean moving) {
        if (!oldState.method_27852(state.method_26204()) && !world.field_9236) {
            world.method_39279(pos, (class_2248)this, 2);
            for (class_2350 direction : class_2350.class_2353.field_11064) {
                world.method_8452(pos.method_10093(direction), (class_2248)this);
            }
            this.updateNeighborsOfNeighboringWires(world, pos);
        }
    }

    public void method_9536(class_2680 state, class_1937 world, class_2338 pos, class_2680 newState, boolean isMoving) {
        if (!isMoving && !state.method_27852(newState.method_26204())) {
            super.method_9536(state, world, pos, newState, isMoving);
            if (!world.field_9236) {
                for (class_2350 direction : class_2350.values()) {
                    world.method_8452(pos.method_10093(direction), (class_2248)this);
                }
                this.updateNeighborsOfNeighboringWires(world, pos);
            }
        }
    }

    public void method_9612(class_2680 state, class_1937 world, class_2338 pos, class_2248 neighborBlock, class_2338 neighborPos, boolean moving) {
        super.method_9612(state, world, pos, neighborBlock, neighborPos, moving);
        if (!world.field_9236) {
            world.method_39279(pos, (class_2248)this, 2);
        }
    }

    private void updateNeighborsOfNeighboringWires(class_1937 world, class_2338 pos) {
        for (class_2350 direction : class_2350.class_2353.field_11062) {
            this.checkCornerChangeAt(world, pos.method_10093(direction));
        }
        for (class_2350 direction1 : class_2350.class_2353.field_11062) {
            class_2338 blockpos = pos.method_10093(direction1);
            if (world.method_8320(blockpos).method_26212((class_1922)world, blockpos)) {
                this.checkCornerChangeAt(world, blockpos.method_10084());
                continue;
            }
            this.checkCornerChangeAt(world, blockpos.method_10074());
        }
    }

    private void checkCornerChangeAt(class_1937 world, class_2338 pos) {
        if (world.method_8320(pos).method_27852((class_2248)this)) {
            world.method_8452(pos, (class_2248)this);
            for (class_2350 direction : class_2350.values()) {
                world.method_8452(pos.method_10093(direction), (class_2248)this);
            }
        }
    }

    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        class_1269 lightUp = super.method_9534(state, world, pos, player, hand, hit);
        if (lightUp.method_23665()) {
            return lightUp;
        }
        if (player.method_31549().field_7476 && (SaltBlock.isCross(state) || SaltBlock.isDot(state))) {
            class_2680 blockstate = SaltBlock.isCross(state) ? this.method_9564() : this.crossState;
            if ((blockstate = this.getConnectionState((class_1922)world, blockstate, pos)) != state) {
                world.method_8652(pos, blockstate, 3);
                this.updatesOnShapeChange(world, pos, state, blockstate);
                return class_1269.field_5812;
            }
        }
        return class_1269.field_5811;
    }

    private void updatesOnShapeChange(class_1937 world, class_2338 pos, class_2680 state, class_2680 newState) {
        for (class_2350 direction : class_2350.class_2353.field_11062) {
            class_2338 blockpos = pos.method_10093(direction);
            if (((class_2773)state.method_11654((class_2769)PROPERTY_BY_DIRECTION.get(direction))).method_27855() == ((class_2773)newState.method_11654((class_2769)PROPERTY_BY_DIRECTION.get(direction))).method_27855() || !world.method_8320(blockpos).method_26212((class_1922)world, blockpos)) continue;
            world.method_8508(blockpos, newState.method_26204(), direction.method_10153());
        }
    }

    public boolean method_9516(class_2680 state, class_1922 level, class_2338 pos, class_10 type) {
        return false;
    }

    public void method_9548(class_2680 state, class_1937 level, class_2338 pos, class_1297 entity) {
        if (entity instanceof class_1309 && entity.method_5864().method_20210(ModTags.HURT_BY_SALT)) {
            if (((class_1309)entity).method_5999()) {
                entity.method_20803(8);
            }
            entity.method_5643(entity.method_48923().method_48820(), 1.0f);
        }
    }
}

