/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.spelunkery.blocks.entity;

import com.ordana.spelunkery.Spelunkery;
import com.ordana.spelunkery.blocks.SluiceBlock;
import com.ordana.spelunkery.reg.ModBlocks;
import com.ordana.spelunkery.reg.ModEntities;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.BooleanSupplier;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1278;
import net.minecraft.class_1297;
import net.minecraft.class_1301;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1707;
import net.minecraft.class_173;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_1826;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2392;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2621;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3611;
import net.minecraft.class_3917;
import net.minecraft.class_52;
import net.minecraft.class_5561;
import net.minecraft.class_5819;
import net.minecraft.class_5945;
import net.minecraft.class_6017;
import net.minecraft.class_6019;
import net.minecraft.class_8567;

public class SluiceBlockEntity
extends class_2621 {
    private class_2371<class_1799> items = class_2371.method_10213((int)9, (Object)class_1799.field_8037);
    private final class_5561 openersCounter = new class_5561(){

        protected void method_31681(class_1937 level, class_2338 pos, class_2680 state) {
            SluiceBlockEntity.this.playSound(state, class_3417.field_17604);
        }

        protected void method_31683(class_1937 level, class_2338 pos, class_2680 state) {
            SluiceBlockEntity.this.playSound(state, class_3417.field_17603);
        }

        protected void method_31682(class_1937 level, class_2338 pos, class_2680 state, int count, int openCount) {
        }

        protected boolean method_31679(class_1657 player) {
            if (player.field_7512 instanceof class_1707) {
                class_1263 container = ((class_1707)player.field_7512).method_7629();
                return container == SluiceBlockEntity.this;
            }
            return false;
        }
    };
    private int cooldownTime;
    private long tickedGameTime;

    public SluiceBlockEntity(class_2338 blockPos, class_2680 blockState) {
        super(blockState.method_27852(ModBlocks.WOODEN_SLUICE.get()) ? ModEntities.WOODEN_SLUICE.get() : ModEntities.STONE_SLUICE.get(), blockPos, blockState);
    }

    protected void method_11007(class_2487 tag) {
        super.method_11007(tag);
        if (!this.method_11286(tag)) {
            class_1262.method_5426((class_2487)tag, this.items);
        }
    }

    public void method_11014(class_2487 tag) {
        super.method_11014(tag);
        this.items = class_2371.method_10213((int)this.method_5439(), (Object)class_1799.field_8037);
        if (!this.method_11283(tag)) {
            class_1262.method_5429((class_2487)tag, this.items);
        }
    }

    public int method_5439() {
        return 9;
    }

    protected class_2371<class_1799> method_11282() {
        return this.items;
    }

    protected void method_11281(class_2371<class_1799> itemStacks) {
        this.items = itemStacks;
    }

    protected class_2561 method_17823() {
        return class_2561.method_43471((String)"container.spelunkery.sluice");
    }

    protected class_1703 method_5465(int containerId, class_1661 inventory) {
        return new class_1707(class_3917.field_18664, containerId, inventory, (class_1263)this, 1);
    }

    public void method_5435(class_1657 player) {
        if (!this.field_11865 && !player.method_7325()) {
            this.openersCounter.method_31684(player, this.method_10997(), this.method_11016(), this.method_11010());
        }
    }

    public void method_5432(class_1657 player) {
        if (!this.field_11865 && !player.method_7325()) {
            this.openersCounter.method_31685(player, this.method_10997(), this.method_11016(), this.method_11010());
        }
    }

    public void recheckOpen() {
        if (!this.field_11865) {
            this.openersCounter.method_31686(this.method_10997(), this.method_11016(), this.method_11010());
        }
    }

    void playSound(class_2680 state, class_3414 sound) {
        double d = (double)this.field_11867.method_10263() + 0.5;
        double e = (double)this.field_11867.method_10264() + 0.5;
        double f = (double)this.field_11867.method_10260() + 0.5;
        this.field_11863.method_43128((class_1657)null, d, e, f, sound, class_3419.field_15245, 0.5f, this.field_11863.field_9229.method_43057() * 0.1f + 0.9f);
    }

    private void setCooldown(int cooldownTime) {
        this.cooldownTime = cooldownTime;
    }

    private boolean isOnCooldown() {
        return this.cooldownTime > 0;
    }

    public static void pushItemsTick(class_1937 level, class_2338 pos, class_2680 state, SluiceBlockEntity blockEntity) {
        --blockEntity.cooldownTime;
        blockEntity.tickedGameTime = level.method_8510();
        if (!blockEntity.isOnCooldown()) {
            blockEntity.setCooldown(0);
            int flow = SluiceBlock.getFlow(level, state, pos);
            SluiceBlockEntity.tryFilterItems(level, pos, state, blockEntity, flow, () -> SluiceBlockEntity.createFilteredItems(pos, level, blockEntity));
        }
    }

    public static boolean tryFilterItems(class_1937 level, class_2338 pos, class_2680 state, SluiceBlockEntity blockEntity, int flow, BooleanSupplier validator) {
        if (!level.field_9236 && !blockEntity.isOnCooldown()) {
            boolean bl = false;
            int delay = 20;
            for (int i = 0; i < flow; ++i) {
                blockEntity.setCooldown(level.field_9229.method_43048(blockEntity.cooldownTime + delay));
                if (!blockEntity.inventoryFull()) {
                    bl |= validator.getAsBoolean();
                    continue;
                }
                bl = false;
            }
            SluiceBlockEntity.method_31663((class_1937)level, (class_2338)pos, (class_2680)state);
            return bl;
        }
        return false;
    }

    private boolean inventoryFull() {
        class_1799 itemStack;
        Iterator var1 = this.items.iterator();
        do {
            if (var1.hasNext()) continue;
            return true;
        } while (!(itemStack = (class_1799)var1.next()).method_7960() && itemStack.method_7947() == itemStack.method_7914());
        return false;
    }

    public static List getItemsAtAndAbove(class_2338 pos, class_1937 level) {
        class_238 aABB = new class_238(pos.method_10084());
        return new ArrayList(level.method_8390(class_1542.class, aABB, class_1301.field_6154));
    }

    public static boolean createFilteredItems(class_2338 pos, class_1937 level, SluiceBlockEntity entity) {
        Iterator itemList = SluiceBlockEntity.getItemsAtAndAbove(pos, level).iterator();
        if (!itemList.hasNext()) {
            return false;
        }
        class_1542 itemEntity = (class_1542)itemList.next();
        String itemName = Utils.getID((class_1792)itemEntity.method_6983().method_7909()).method_12832();
        String fluidName = Utils.getID((class_3611)level.method_8316(pos.method_10084()).method_15772()).method_12832();
        if (fluidName.contains("flowing_")) {
            fluidName = fluidName.replace("flowing_", "");
        }
        if (!Objects.equals(fluidName, "empty")) {
            class_1826 egg;
            class_1297 eggEntity;
            class_8567.class_8568 builder;
            class_2960 tablePath = Spelunkery.res("gameplay/sluice/" + fluidName + "/" + itemName);
            class_52 lootTable = Objects.requireNonNull(level.method_8503()).method_3857().getLootTable(tablePath);
            ObjectArrayList lootList = lootTable.method_51878((builder = new class_8567.class_8568((class_3218)level).method_51874(class_181.field_1224, (Object)level.method_8320(pos)).method_51874(class_181.field_24424, (Object)class_243.method_24953((class_2382)pos)).method_51874(class_181.field_1229, (Object)class_1799.field_8037).method_51877(class_181.field_1228, (Object)entity)).method_51875(class_173.field_1172));
            if (lootList.isEmpty()) {
                return false;
            }
            class_1799 lootItem = (class_1799)lootList.iterator().next();
            class_1792 class_17922 = lootItem.method_7909();
            if (class_17922 instanceof class_1826 && (eggEntity = (egg = (class_1826)class_17922).method_8015(lootItem.method_7969()).method_5883(level)) != null) {
                eggEntity.method_24203((double)pos.method_10263() + 0.5, (double)(pos.method_10264() + 1), (double)pos.method_10260() + 0.5);
                level.method_8649(eggEntity);
                itemEntity.method_6983().method_7934(1);
                return true;
            }
            SluiceBlockEntity.suckInItems((class_1263)entity, lootItem);
            class_5819 random = level.field_9229;
            class_5945.method_41305((class_1937)level, (class_2338)pos, (class_2394)new class_2392(class_2398.field_11218, lootItem), (class_6017)class_6019.method_35017((int)3, (int)5), (class_2350)class_2350.field_11036, () -> new class_243(class_3532.method_15366((class_5819)random, (double)-0.5, (double)0.5), class_3532.method_15366((class_5819)random, (double)-0.5, (double)0.5), class_3532.method_15366((class_5819)random, (double)-0.5, (double)0.5)), (double)0.55);
            itemEntity.method_6983().method_7934(1);
            return true;
        }
        return false;
    }

    public static boolean suckInItems(class_1263 container, class_1799 itemStack) {
        class_1799 itemStack2 = SluiceBlockEntity.addItem(container, itemStack);
        return itemStack2.method_7960();
    }

    public static class_1799 addItem(class_1263 destination, class_1799 stack) {
        int j = destination.method_5439();
        for (int i = 0; i < j && !stack.method_7960(); ++i) {
            stack = SluiceBlockEntity.tryMoveInItem(destination, stack, i);
        }
        return stack;
    }

    private static class_1799 tryMoveInItem(class_1263 destination, class_1799 stack, int slot) {
        class_1799 itemStack = destination.method_5438(slot);
        if (SluiceBlockEntity.canPlaceItemInContainer(destination, stack, slot)) {
            int j;
            boolean bl = false;
            boolean bl2 = destination.method_5442();
            if (itemStack.method_7960()) {
                destination.method_5447(slot, stack);
                stack = class_1799.field_8037;
                bl = true;
            } else if (SluiceBlockEntity.canMergeItems(itemStack, stack)) {
                int i = stack.method_7914() - itemStack.method_7947();
                j = Math.min(stack.method_7947(), i);
                stack.method_7934(j);
                itemStack.method_7933(j);
                boolean bl3 = bl = j > 0;
            }
            if (bl) {
                if (bl2 && destination instanceof SluiceBlockEntity) {
                    SluiceBlockEntity hopperBlockEntity = (SluiceBlockEntity)destination;
                    j = 0;
                    hopperBlockEntity.setCooldown(8 - j);
                }
                destination.method_5431();
            }
        }
        return stack;
    }

    private static boolean canPlaceItemInContainer(class_1263 container, class_1799 stack, int slot) {
        class_1278 worldlyContainer;
        if (!container.method_5437(slot, stack)) {
            return false;
        }
        if (container instanceof class_1278 && !(worldlyContainer = (class_1278)container).method_5492(slot, stack, null)) {
            boolean var10000 = false;
            return var10000;
        }
        boolean var10000 = true;
        return var10000;
    }

    private static boolean canMergeItems(class_1799 stack1, class_1799 stack2) {
        return stack1.method_7947() <= stack1.method_7914() && class_1799.method_31577((class_1799)stack1, (class_1799)stack2);
    }
}

