/*
 * Decompiled with CFR 0.152.
 */
package fuzs.effectdescriptions.client.helper;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import fuzs.effectdescriptions.EffectDescriptions;
import fuzs.effectdescriptions.config.ClientConfig;
import fuzs.puzzleslib.api.core.v1.ModLoaderEnvironment;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_124;
import net.minecraft.class_1291;
import net.minecraft.class_1292;
import net.minecraft.class_1293;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1799;
import net.minecraft.class_2477;
import net.minecraft.class_2561;
import net.minecraft.class_4081;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_7923;
import org.apache.commons.lang3.StringUtils;

public class EffectLinesHelper {
    public static Optional<class_2561> getEffectDescriptionComponent(String id, boolean preventIndentation) {
        String description = class_2477.method_10517().method_4678(id + ".desc") ? id + ".desc" : (class_2477.method_10517().method_4678(id + ".description") ? id + ".description" : (class_2477.method_10517().method_4678("description." + id) ? "description." + id : null));
        if (description != null) {
            int indentation;
            class_5250 component = class_2561.method_43471((String)description);
            if (!preventIndentation && (indentation = ((ClientConfig)EffectDescriptions.CONFIG.get(ClientConfig.class)).descriptionIndentation) > 0) {
                component = class_2561.method_43470((String)StringUtils.repeat((String)" ", (int)indentation)).method_10852((class_2561)component);
            }
            return Optional.of(component.method_27692(class_124.field_1080));
        }
        return Optional.empty();
    }

    public static void tryAddDisplayName(List<class_2561> lines, class_1293 mobEffectInstance, boolean smallWidgets) {
        if (smallWidgets || ((ClientConfig)EffectDescriptions.CONFIG.get(ClientConfig.class)).alwaysAddEffectNameToTooltips) {
            class_5250 effectComponent = class_2561.method_43471((String)mobEffectInstance.method_5586());
            if (mobEffectInstance.method_5578() > 0) {
                effectComponent = class_2561.method_43469((String)"potion.withAmplifier", (Object[])new Object[]{effectComponent, class_2561.method_43471((String)("potion.potency." + mobEffectInstance.method_5578()))});
            }
            class_5250 durationComponent = class_2561.method_43470((String)"(").method_10852(class_1292.method_5577((class_1293)mobEffectInstance, (float)1.0f)).method_27693(")");
            effectComponent.method_10852(class_5244.field_41874).method_10852((class_2561)durationComponent);
            effectComponent.method_27692(mobEffectInstance.method_5579().method_18792().method_18793());
            lines.add((class_2561)effectComponent);
        }
    }

    public static void tryAddAttributes(List<class_2561> lines, class_1293 mobEffectInstance) {
        if (!((ClientConfig)EffectDescriptions.CONFIG.get(ClientConfig.class)).addAttributesToWidgetTooltips) {
            return;
        }
        List<Pair<class_1320, class_1322>> attributes = EffectLinesHelper.getAttributesFromEffects(List.of(mobEffectInstance));
        if (!attributes.isEmpty()) {
            lines.add(class_5244.field_39003);
            lines.add((class_2561)class_2561.method_43471((String)"potion.whenDrank").method_27692(class_124.field_1064));
            for (Pair<class_1320, class_1322> pair : attributes) {
                class_1322 attributeModifier = (class_1322)pair.getSecond();
                double d0 = attributeModifier.method_6186();
                double d1 = attributeModifier.method_6182() != class_1322.class_1323.field_6330 && attributeModifier.method_6182() != class_1322.class_1323.field_6331 ? attributeModifier.method_6186() : attributeModifier.method_6186() * 100.0;
                if (d0 > 0.0) {
                    lines.add((class_2561)class_2561.method_43469((String)("attribute.modifier.plus." + attributeModifier.method_6182().method_6191()), (Object[])new Object[]{class_1799.field_8029.format(d1), class_2561.method_43471((String)((class_1320)pair.getFirst()).method_26830())}).method_27692(class_124.field_1078));
                    continue;
                }
                if (!(d0 < 0.0)) continue;
                lines.add((class_2561)class_2561.method_43469((String)("attribute.modifier.take." + attributeModifier.method_6182().method_6191()), (Object[])new Object[]{class_1799.field_8029.format(d1 *= -1.0), class_2561.method_43471((String)((class_1320)pair.getFirst()).method_26830())}).method_27692(class_124.field_1061));
            }
        }
    }

    private static List<Pair<class_1320, class_1322>> getAttributesFromEffects(List<class_1293> effects) {
        ArrayList attributes = Lists.newArrayList();
        for (class_1293 mobeffectinstance : effects) {
            for (Map.Entry entry : mobeffectinstance.method_5579().method_5565().entrySet()) {
                class_1322 attributeModifier = (class_1322)entry.getValue();
                double attributeModifierValue = mobeffectinstance.method_5579().method_5563(mobeffectinstance.method_5578(), attributeModifier);
                class_1322 newAttributeModifier = new class_1322(attributeModifier.method_6185(), attributeModifierValue, attributeModifier.method_6182());
                attributes.add(new Pair((Object)((class_1320)entry.getKey()), (Object)newAttributeModifier));
            }
        }
        return attributes;
    }

    private static class_124 getMobEffectColor(class_1291 mobEffect) {
        return switch (mobEffect.method_18792()) {
            case class_4081.field_18271 -> class_124.field_1078;
            case class_4081.field_18272 -> class_124.field_1061;
            default -> class_124.field_1065;
        };
    }

    public static void tryAddModName(List<class_2561> lines, class_1293 mobEffectInstance) {
        if (((ClientConfig)EffectDescriptions.CONFIG.get(ClientConfig.class)).addModNameToWidgetTooltips) {
            ModLoaderEnvironment.INSTANCE.getModName(class_7923.field_41174.method_10221((Object)mobEffectInstance.method_5579()).method_12836()).map(s -> class_2561.method_43470((String)s).method_27692(class_124.field_1078)).ifPresent(lines::add);
        }
    }

    public static void tryAddInternalName(List<class_2561> lines, class_1293 mobEffectInstance) {
        if (((ClientConfig)EffectDescriptions.CONFIG.get(ClientConfig.class)).addInternalIdToWidgetTooltips) {
            lines.add((class_2561)class_2561.method_43470((String)class_7923.field_41174.method_10221((Object)mobEffectInstance.method_5579()).toString()).method_27692(class_124.field_1063));
        }
    }
}

